/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.jcl.common.jes;

import com.urbancode.air.plugin.command.jcl.common.jes.JMConnection;
import com.urbancode.air.plugin.command.jcl.common.jes.JobDataset;
import com.urbancode.air.plugin.command.jcl.common.jes.JobStep;
import com.urbancode.air.plugin.command.jcl.common.jes.utils.IJESMinerConstants;
import com.urbancode.air.plugin.command.jcl.common.jes.utils.JmonProtocol;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public final class JESJob {
    private final JMConnection jm;
    private String jobName;
    private String jobID;
    private String sysoutClass;
    private String memberName;
    private String returnCode;
    private String returnStatus;
    private String returnInfo;
    private JobDataset[] datasets = null;
    private JobStep[] jobsteps = null;
    private boolean jobCompleted;

    public JESJob(JMConnection jm) {
        this.jm = jm;
    }

    public void setStatus(List<String> status) {
        for (String item : status) {
            if (item.startsWith("155-Job.Name=")) {
                this.jobName = item.substring(item.indexOf("=") + 1);
                continue;
            }
            if (item.startsWith("155-Job.ID=")) {
                this.jobID = item.substring(item.indexOf("=") + 1);
                continue;
            }
            if (item.startsWith("155-SYSOUT.Class=")) {
                this.sysoutClass = item.substring(item.indexOf("=") + 1);
                continue;
            }
            if (item.startsWith("155-Member.Name=")) {
                this.memberName = item.substring(item.indexOf("=") + 1);
                continue;
            }
            if (item.startsWith("155-Job.Phase=")) {
                String jobPhase = item.substring(item.indexOf("=") + 1);
                this.jobCompleted = jobPhase.equals("19") || jobPhase.equals("20") || jobPhase.equals("21") || jobPhase.equals("12") || jobPhase.equals("254");
                continue;
            }
            if (!item.startsWith("155-Return.Code=")) continue;
            String partone = item.substring(18, 19);
            this.returnStatus = partone.compareTo("8") == 0 ? "ABEND" : (partone.compareTo("4") == 0 ? "COMPLETION" : (partone.compareTo("6") == 0 ? "COMPLETION" : ""));
            String parttwo = item.substring(19, 20);
            if (parttwo.compareTo("0") == 0) {
                this.returnInfo = "NOINFO";
            } else if (parttwo.compareTo("1") == 0) {
                this.returnInfo = "NORMAL";
            } else if (parttwo.compareTo("2") == 0) {
                this.returnInfo = "CC";
            } else if (parttwo.compareTo("3") == 0) {
                this.returnInfo = "JCLERROR";
            } else if (parttwo.compareTo("4") == 0) {
                this.returnInfo = "CANCELLED";
            } else if (parttwo.compareTo("5") == 0) {
                this.returnInfo = "ABENDed";
            } else if (parttwo.compareTo("6") == 0) {
                this.returnInfo = "ConverterABENDed";
            } else if (parttwo.compareTo("7") == 0) {
                this.returnInfo = "SECURITYERROR";
            } else if (parttwo.compareTo("8") == 0) {
                this.returnInfo = "EOMFailure";
            } else if (parttwo.compareTo("9") == 0) {
                this.returnInfo = "CONV ERROR";
            } else if (parttwo.compareTo("A") == 0) {
                this.returnInfo = "SYS FAIL";
            } else {
                this.returnInfo = "UNKNOWN";
                System.out.println("JESJob#setStatus - Return code info back from JES Server - " + item);
            }
            String systemReturnCode = item.substring(20, 23);
            if (!systemReturnCode.equals("000")) {
                Integer decVal = Integer.valueOf(systemReturnCode, 16);
                int decValu = decVal;
                String rcS = Integer.toHexString(decValu);
                rcS = rcS.toUpperCase();
                while (rcS.length() < 3) {
                    rcS = "0" + rcS;
                }
                this.returnCode = "S" + rcS;
                continue;
            }
            String userReturnCode = item.substring(23, 26);
            Integer decVal = Integer.valueOf(userReturnCode, 16);
            String rcU = String.valueOf(decVal);
            while (rcU.length() < 4) {
                rcU = "0" + rcU;
            }
            this.returnCode = "U" + rcU;
        }
    }

    public JobDataset[] getDatasets() {
        if (this.datasets == null) {
            JMConnection jm = this.getJMConnection();
            this.datasets = new JobDataset[0];
            try {
                ArrayList<String> results = jm.sysout(this.jobID);
                this.datasets = this.getDatasets(results);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.datasets;
    }

    public void setDatasets(JobDataset[] dataSets) {
        this.datasets = dataSets;
    }

    public JobDataset[] getDatasets(List<?> results) {
        if (results != null) {
            int i = 0;
            Iterator<?> iter = results.iterator();
            this.datasets = new JobDataset[results.size()];
            JMConnection jm = this.getJMConnection();
            if (jm != null) {
                JmonProtocol protocol = jm.getProtocolLevel();
                if (protocol != null && !protocol.isEarlierThan(IJESMinerConstants.procStepAndDSIDSupportedProtocol)) {
                    while (iter.hasNext()) {
                        JobDataset dataset = new JobDataset();
                        String ds = (String)iter.next();
                        String[] temp = ds.split("[\\s]+");
                        switch (temp.length) {
                            case 8: {
                                dataset.setTime(temp[7].substring(5));
                            }
                            case 7: {
                                dataset.setDate(temp[6].substring(5));
                            }
                            case 6: {
                                dataset.setLineCount(temp[5].substring(8));
                            }
                            case 5: {
                                String dsID = temp[4].substring(5);
                                Integer intDSID = new Integer(dsID);
                                dataset.setDataSetID(intDSID);
                            }
                            case 4: {
                                dataset.setProcStepName(temp[3].substring(5));
                            }
                            case 3: {
                                dataset.setStepName(temp[2].substring(5));
                            }
                            case 2: {
                                dataset.setDDName(temp[1].substring(3));
                                dataset.setDsName(temp[0].substring(4));
                                break;
                            }
                        }
                        dataset.setJobId(this.jobID);
                        dataset.setJob(this);
                        this.datasets[i++] = dataset;
                        if (!dataset.getDDName().equals("JESYSMSG")) continue;
                        this.jobsteps = this.getJobStepInfo(dataset);
                        if (this.jobsteps == null) continue;
                        this.setJobSteps(this.jobsteps);
                    }
                } else {
                    while (iter.hasNext()) {
                        JobDataset dataset = new JobDataset();
                        String ds = (String)iter.next();
                        String[] temp = ds.split("[\\s]+");
                        switch (temp.length) {
                            case 6: {
                                dataset.setTime(temp[5].substring(5));
                            }
                            case 5: {
                                dataset.setDate(temp[4].substring(5));
                            }
                            case 4: {
                                dataset.setLineCount(temp[3].substring(8));
                            }
                            case 3: {
                                dataset.setStepName(temp[2].substring(5));
                            }
                            case 2: {
                                dataset.setDDName(temp[1].substring(3));
                                dataset.setDsName(temp[0].substring(4));
                                break;
                            }
                        }
                        dataset.setJobId(this.jobID);
                        dataset.setJob(this);
                        this.datasets[i++] = dataset;
                        if (!dataset.getDDName().equals("JESYSMSG")) continue;
                        this.jobsteps = this.getJobStepInfo(dataset);
                        if (this.jobsteps == null) continue;
                        this.setJobSteps(this.jobsteps);
                    }
                }
            }
        }
        this.pushStepReturnCodeToJobDataSets(this.datasets, this.jobsteps);
        return this.datasets;
    }

    private JMConnection getJMConnection() {
        return this.jm;
    }

    public String getJobID() {
        return this.jobID;
    }

    public void setJobID(String string) {
        this.jobID = string;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public void setMemberName(String string) {
        this.memberName = string;
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(String string) {
        this.returnCode = string;
    }

    public String getReturnInfo() {
        return this.returnInfo;
    }

    public String getReturnStatus() {
        return this.returnStatus;
    }

    public String getSysoutClass() {
        return this.sysoutClass;
    }

    public void setSysoutClass(String string) {
        this.sysoutClass = string;
    }

    public boolean getJobCompleted() {
        return this.jobCompleted;
    }

    private JobStep[] getJobStepInfo(JobDataset jobDataSet) {
        Vector<JobStep> v = new Vector<JobStep>();
        JMConnection jm = this.getJMConnection();
        int cutOff = Integer.MAX_VALUE;
        String jobId = jobDataSet.getJobId();
        String dsName = jobDataSet.getdsName();
        try {
            InputStream spoolDatasetStream = jm.getOutputSDS(jobId, dsName, cutOff);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(spoolDatasetStream));
            boolean nextLineRead = false;
            boolean foundEnd = false;
            String s = null;
            String jobName = "";
            String procStep = "";
            String stepName = "";
            String returnCode = "";
            while (!foundEnd) {
                if (!nextLineRead && (s = bufferedReader.readLine()) == null) {
                    foundEnd = true;
                }
                if (s == null) continue;
                nextLineRead = false;
                if (s.indexOf("IEF142I") != 0) continue;
                jobName = "";
                procStep = "";
                stepName = "";
                returnCode = "";
                StringTokenizer st = new StringTokenizer(s, " -");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!token.equalsIgnoreCase("IEF142I")) continue;
                    jobName = st.nextToken();
                    stepName = st.nextToken();
                    token = st.nextToken();
                    if (!token.equals("STEP")) {
                        procStep = stepName;
                        stepName = token;
                        st.nextToken();
                    }
                    st.nextToken();
                    st.nextToken();
                    st.nextToken();
                    st.nextToken();
                    returnCode = st.nextToken();
                }
                if (stepName.isEmpty() || returnCode.isEmpty()) continue;
                JobStep jobStep = new JobStep(stepName, returnCode);
                v.add(jobStep);
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!v.isEmpty()) {
            this.jobsteps = new JobStep[v.size()];
            v.copyInto(this.jobsteps);
        }
        return this.jobsteps;
    }

    private void setJobSteps(JobStep[] steps) {
        this.jobsteps = steps;
    }

    private void pushStepReturnCodeToJobDataSets(JobDataset[] jobDatasets, JobStep[] jobSteps) {
        if (jobDatasets == null || jobSteps == null) {
            return;
        }
        for (JobDataset jobDataset : jobDatasets) {
            Arrays.stream(jobSteps).filter(jobStep -> jobStep.getStepName().equalsIgnoreCase(jobDataset.getStepName())).findFirst().ifPresent(jobStep -> jobDataset.setStepReturnCode(jobStep.getStepReturnCode()));
        }
    }
}

