/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.jcl.common.jes;

import com.ibm.urbancode.zos.jes.passticket.PassTicketGenerator;
import com.urbancode.air.plugin.command.jcl.common.JmonInputs;
import com.urbancode.air.plugin.command.jcl.common.jes.JESJob;
import com.urbancode.air.plugin.command.jcl.common.jes.JMConnection;
import com.urbancode.air.plugin.command.jcl.common.jes.JMException;
import com.urbancode.air.plugin.command.jcl.common.jes.JobDataset;
import com.urbancode.air.plugin.command.jcl.common.jes.Logger;
import com.urbancode.air.plugin.command.jcl.common.jes.SystemMessageException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class JobUtil {
    private static final String DEFAULT_APPL_ID_FOR_JMON = "FEKAPPL";
    private static final int SLEEP_INTERVAL_IN_SECS = 2;
    private final Logger logger = Logger.getDefault();
    private final String host;
    private final String port;
    private int cutoff;
    private int timeoutInSecs;
    private int maxReturnCode;
    private String showOutput;
    private int returnCode = -1;
    private JMConnection jm = null;
    private JESJob latestJob = null;
    private String userid;
    private String password;
    private boolean useRunId;
    private boolean isPassTicketAuthentication;
    private String libPath;

    private JobUtil(String host, String port) {
        this.host = host;
        this.port = port;
    }

    public static JobUtil from(JmonInputs jmonInputs) {
        JobUtil jobUtil = new JobUtil(jmonInputs.getHostname(), jmonInputs.getPort());
        if (jmonInputs.isUseRunId()) {
            jobUtil.useRunId = true;
        } else if (jmonInputs.isUsePassTicket()) {
            jobUtil.userid = jmonInputs.getUserid();
            jobUtil.isPassTicketAuthentication = true;
            jobUtil.libPath = jmonInputs.getIrrracfLibraryPath();
        } else {
            jobUtil.userid = jmonInputs.getUserid();
            jobUtil.password = jmonInputs.getPassword();
        }
        jobUtil.timeoutInSecs = jmonInputs.getTimeoutInSecs();
        jobUtil.cutoff = jmonInputs.getCutoff();
        jobUtil.maxReturnCode = jmonInputs.getMaxRC();
        jobUtil.showOutput = jmonInputs.getShowOutput();
        return jobUtil;
    }

    public String[] getShowOutput() {
        String[] split = this.showOutput.split(",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim().toUpperCase();
        }
        return split;
    }

    public int getCutoff() {
        return this.cutoff;
    }

    public void setPasswordUsingPassTicket() throws Exception {
        this.password = PassTicketGenerator.generate((String)this.userid, (String)this.libPath, (String)DEFAULT_APPL_ID_FOR_JMON);
        if (this.jm == null) {
            this.jm = new JMConnection();
            this.jm.setUseRunId(this.useRunId);
        }
        this.jm.connect(this.host, this.port, this.userid, this.password);
    }

    private JMConnection getJm() throws SystemMessageException {
        if (this.jm == null) {
            this.jm = new JMConnection();
            this.jm.setUseRunId(this.useRunId);
            this.jm.connect(this.host, this.port, this.userid, this.password);
        }
        return this.jm;
    }

    public String submitJob(String jclString) throws Exception {
        String response = this.getJm().submit(jclString);
        String[] responseWords = response.split(" ");
        return responseWords[1];
    }

    public JESJob getJob(String jobid, boolean useCache) throws JMException, SystemMessageException {
        if (useCache && this.latestJob != null) {
            return this.latestJob;
        }
        ArrayList<String> status = this.getJm().getStatus(jobid);
        if (status != null) {
            JESJob job = new JESJob(this.getJm());
            job.setJobID(jobid);
            job.setStatus(status);
            this.latestJob = job;
            return job;
        }
        throw new JMException("Failed to get status for job " + jobid);
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    private void printOutputSDS(JobDataset dataset) throws Exception {
        String line;
        InputStream outputSDS = this.getJm().getOutputSDS(dataset.getJobId(), dataset.getdsName(), this.cutoff);
        String datasetDescription = dataset.getdsName() + "  DD=" + dataset.getDDName() + "  LineCnt=" + dataset.getLineCount() + "  Date=" + dataset.getDate() + "  Time=" + dataset.getTime();
        BufferedReader reader = new BufferedReader(new InputStreamReader(outputSDS));
        System.out.println("========================================================================================================================");
        System.out.println(datasetDescription);
        System.out.println("========================================================================================================================");
        while ((line = reader.readLine()) != null) {
            System.out.println(line);
        }
    }

    public boolean isJclError(String jobid) throws Exception {
        if (jobid == null) {
            throw new JMException("jobid is null");
        }
        JESJob job = this.getJob(jobid, false);
        if (job != null) {
            if (job.getJobCompleted() && "JCLERROR".equals(job.getReturnInfo())) {
                JobDataset[] datasets;
                System.out.println("JCL Error.");
                for (JobDataset dataset : datasets = job.getDatasets()) {
                    this.logger.writeDebug("printing ds=" + dataset.getdsName());
                    this.printOutputSDS(dataset);
                }
                return true;
            }
            return false;
        }
        throw new Exception("Failed to get job status.");
    }

    public void printLog(String jobid) throws Exception {
        if (jobid == null) {
            throw new JMException("jobid is null");
        }
        JESJob job = this.getJob(jobid, true);
        if (job != null) {
            JobDataset[] datasets = job.getDatasets();
            String[] dsNameList = this.getShowOutput();
            boolean showAll = false;
            for (String dsName : dsNameList) {
                if (!"ALL".equals(dsName)) continue;
                showAll = true;
                break;
            }
            for (JobDataset dataset : datasets) {
                if (showAll) {
                    this.printOutputSDS(dataset);
                    continue;
                }
                for (String dsName : dsNameList) {
                    if (!dataset.getDDName().equalsIgnoreCase(dsName)) continue;
                    this.printOutputSDS(dataset);
                }
            }
        } else {
            throw new JMException("Failed to get job status.");
        }
    }

    public boolean waitForJob(String jobid) throws Exception {
        if (jobid == null) {
            throw new Exception("jobid is null");
        }
        for (int elapsedTimeInSecs = 0; elapsedTimeInSecs < this.timeoutInSecs; elapsedTimeInSecs += 2) {
            JESJob job = this.getJob(jobid, false);
            if (job != null) {
                if (job.getJobCompleted()) {
                    int intCode;
                    System.out.println("Job Completed");
                    System.out.println("JobID=" + job.getJobID());
                    System.out.println("JobName=" + job.getJobName());
                    System.out.println("JobReturnCode=" + job.getReturnCode());
                    System.out.println("JobReturnInfo=" + job.getReturnInfo());
                    System.out.println("JobReturnStatus=" + job.getReturnStatus());
                    String returnCode = job.getReturnCode();
                    returnCode = returnCode.substring(1);
                    this.returnCode = intCode = Integer.parseInt(returnCode);
                    if (this.maxReturnCode >= 0) {
                        if ("COMPLETION".equals(job.getReturnStatus())) {
                            return intCode <= this.maxReturnCode;
                        }
                        System.out.println("Job does not end with completion code.");
                        return false;
                    }
                    if ("COMPLETION".equals(job.getReturnStatus())) {
                        System.out.println("Job completed successfully.");
                        return true;
                    }
                    System.out.println("Job does not end with completion status..");
                    return false;
                }
            } else {
                throw new JMException("Failed to get job status.");
            }
            this.logger.writeDebug("Waiting... 2");
            Thread.sleep(2000L);
        }
        System.out.println("Timeout waiting for job to complete. Timeout=" + this.timeoutInSecs + " seconds.");
        return false;
    }

    public void disconnect() {
        if (this.jm != null) {
            try {
                this.jm.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "JobUtil [host=" + this.host + ", port=" + this.port + ", userid=" + this.userid + ", password=" + this.password + ", cutoff=" + this.cutoff + ", timeout=" + this.timeoutInSecs + ", interval=" + 2 + ", maxReturnCode=" + this.maxReturnCode + ", showOutput=" + this.showOutput + ", returnCode=" + this.returnCode + "]";
    }

    public boolean isPassTicketAuthentication() {
        return this.isPassTicketAuthentication;
    }
}

