/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.inputs;

import com.ibm.jzos.ZFile;
import com.ibm.urbancode.zos.xml.utils.common.DeployedVersion;
import com.urbancode.air.plugin.exceptions.InvalidInputException;
import com.urbancode.air.plugin.exceptions.MissingInputException;
import com.urbancode.air.plugin.inputs.HfsMappingHelper;
import com.urbancode.air.plugin.inputs.InputsValidator;
import java.util.Properties;

public class DeployPackageInputs {
    public static final String RESOURCE_ID = "resourceId";
    public static final String COMPONENT_ID = "componentId";
    public static final String COMPONENT_NAME = "componentName";
    public static final String VERSION_NAME = "versionName";
    public static final String VERSION_ID = "versionId";
    public static final String VERSION_TYPE = "versionType";
    public static final String DEPLOY_BASE_PATH = "deployBasePath";
    public static final String TEMP_DSN_PREFIX = "tempDsnPrefix";
    public static final String PDS_MAPPING = "pdsMapping";
    public static final String CHECK_ACCESS = "checkAccess";
    public static final String ALLOW_CREATE_DATASET = "allowCreateDataset";
    public static final String ALLOW_CREATE_DIRECTORY = "allowCreateDirectory";
    public static final String VERSION_MERGE = "versionMerge";
    public static final String PRINT_LOGS = "printLogs";
    public static final String DELETE_CURRENT_CONTENTS = "deleteCurrentContents";
    public static final String INCREMENTAL_MODE = "incrementalMode";
    public static final String INCREMENTAL_MODE_FULL = "FULL";
    public static final String INCREMENTAL_MODE_INVENTORY = "INVENTORY";
    public static final String INCREMENTAL_MODE_RUNTIME = "RUNTIME";
    public static final String CONTAINER_FILTER = "containerFilter";
    public static final String HFS_TARGET_DIR = "hfsTargetDir";
    public static final String DO_BACKUP = "doBackup";
    public static final String ENVIRONMENT_ID = "environmentId";
    public static final String REPLACE_PDS_MEMBER = "replacePdsMember";
    public static final String ISPF_GATEWAY_PATH = "ispfGatewayPath";
    private final String resourceId;
    private final String componentId;
    private final String componentName;
    private final String versionName;
    private final String versionId;
    private final String versionType;
    private final String tempDsnPrefix;
    private final String pdsMapping;
    private final boolean isCheckAccessEnabled;
    private final boolean isCreateDatasetAllowed;
    private final boolean isCreateDirectoryAllowed;
    private final boolean isMergedVersion;
    private final boolean isPrintLogsEnabled;
    private final boolean isDeleteCurrentContentsEnabled;
    private final String incrementalMode;
    private final String containerFilter;
    private final String hfsMapping;
    private final String environmentId;
    private final boolean isReplacePdsMemberEnabled;
    private final String ispfGatewayBinPath;
    private final boolean isBackupEnabled;
    private final boolean isOldHfsMappingFormat;
    private final DeployedVersion deployedVersion;

    private DeployPackageInputs(Properties inputProperties) {
        this.resourceId = inputProperties.getProperty(RESOURCE_ID).trim();
        this.componentId = inputProperties.getProperty(COMPONENT_ID).trim();
        this.componentName = inputProperties.getProperty(COMPONENT_NAME).trim();
        this.versionName = inputProperties.getProperty(VERSION_NAME).trim();
        this.versionId = inputProperties.getProperty(VERSION_ID).trim();
        this.versionType = inputProperties.getProperty(VERSION_TYPE).trim();
        String passedTempDsnPrefix = inputProperties.getProperty(TEMP_DSN_PREFIX).trim();
        this.tempDsnPrefix = passedTempDsnPrefix.isEmpty() ? ZFile.getDefaultHLQ() : passedTempDsnPrefix;
        this.pdsMapping = inputProperties.getProperty(PDS_MAPPING).trim().toUpperCase();
        this.incrementalMode = inputProperties.getProperty(INCREMENTAL_MODE).trim();
        this.containerFilter = inputProperties.getProperty(CONTAINER_FILTER).trim();
        this.ispfGatewayBinPath = inputProperties.getProperty(ISPF_GATEWAY_PATH).trim();
        this.environmentId = inputProperties.getProperty(ENVIRONMENT_ID).trim();
        String hfsTargetDir = inputProperties.getProperty(HFS_TARGET_DIR).trim();
        this.isOldHfsMappingFormat = !HfsMappingHelper.hasCommaSeparatedMapping(hfsTargetDir);
        this.hfsMapping = HfsMappingHelper.determineMapping(hfsTargetDir);
        this.isCheckAccessEnabled = Boolean.parseBoolean(inputProperties.getProperty(CHECK_ACCESS).trim());
        this.isCreateDatasetAllowed = Boolean.parseBoolean(inputProperties.getProperty(ALLOW_CREATE_DATASET).trim());
        this.isCreateDirectoryAllowed = Boolean.parseBoolean(inputProperties.getProperty(ALLOW_CREATE_DIRECTORY).trim());
        this.isMergedVersion = Boolean.parseBoolean(inputProperties.getProperty(VERSION_MERGE).trim());
        this.isPrintLogsEnabled = Boolean.parseBoolean(inputProperties.getProperty(PRINT_LOGS).trim());
        this.isDeleteCurrentContentsEnabled = Boolean.parseBoolean(inputProperties.getProperty(DELETE_CURRENT_CONTENTS).trim());
        this.isBackupEnabled = Boolean.parseBoolean(inputProperties.getProperty(DO_BACKUP).trim());
        this.isReplacePdsMemberEnabled = Boolean.parseBoolean(inputProperties.getProperty(REPLACE_PDS_MEMBER).trim());
        this.deployedVersion = new DeployedVersion(inputProperties);
    }

    public static DeployPackageInputs getValidatedInputs(Properties inputProperties) {
        DeployPackageInputs inputs = new DeployPackageInputs(inputProperties);
        inputs.validateInputs();
        return inputs;
    }

    private void validateInputs() {
        InputsValidator.checkIfEmpty(this.componentId, "Component Id");
        InputsValidator.checkIfEmpty(this.versionId, "Version Id");
        this.validateVersionType();
        this.validateIncrementalMode();
        InputsValidator.checkIfEmpty(this.ispfGatewayBinPath, "ISPF Gateway Path");
        InputsValidator.checkIfEmpty(this.environmentId, "Environment Id");
        if (this.isMergedVersion && this.hasContainerFilter()) {
            throw new InvalidInputException("Container Filters is not supported for a merged version");
        }
        InputsValidator.checkDsnPrefixLength(this.tempDsnPrefix);
    }

    public void validateHFSInputs() {
        if (this.hfsMapping.isEmpty()) {
            throw new MissingInputException("Version contains HFS files. HFS Mapping is required.");
        }
        if (this.isBackupEnabled && this.isDeleteCurrentContentsEnabled) {
            throw new InvalidInputException("Backup of the target directory cannot be taken since we are deleting the target directory contents. Either the checkbox 'Delete the Target Directory contents' should be selected or the checkbox 'Backup for Rollback' checkbox should be selected. Please make the necessary changes and rerun deployment.");
        }
    }

    private void validateVersionType() {
        InputsValidator.checkIfEmpty(this.versionType, "Version Type");
        if (this.versionTypeIsNotFull() && this.versionTypeIsNotIncremental()) {
            throw new InvalidInputException("Invalid version type - " + this.versionType + ". Version Type must be either " + INCREMENTAL_MODE_FULL + " or " + "INCREMENTAL");
        }
    }

    private boolean versionTypeIsNotIncremental() {
        return !this.versionType.equalsIgnoreCase("INCREMENTAL");
    }

    private boolean versionTypeIsNotFull() {
        return !this.versionType.equalsIgnoreCase(INCREMENTAL_MODE_FULL);
    }

    private void validateIncrementalMode() {
        InputsValidator.checkIfEmpty(this.incrementalMode, "Delta Deploy");
        if (!(this.incrementalModeIsFull() || this.incrementalModeIsInventory() || this.incrementalModeIsRuntime())) {
            throw new InvalidInputException("Invalid delta deploy - " + this.incrementalMode + ". Valid delta deploy values are " + INCREMENTAL_MODE_FULL + "/" + INCREMENTAL_MODE_INVENTORY + "/" + INCREMENTAL_MODE_RUNTIME);
        }
    }

    public boolean incrementalModeIsRuntime() {
        return this.incrementalMode.equalsIgnoreCase(INCREMENTAL_MODE_RUNTIME);
    }

    public boolean incrementalModeIsInventory() {
        return this.incrementalMode.equalsIgnoreCase(INCREMENTAL_MODE_INVENTORY);
    }

    public boolean incrementalModeIsFull() {
        return this.incrementalMode.equalsIgnoreCase(INCREMENTAL_MODE_FULL);
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public String getVersionType() {
        return this.versionType;
    }

    public boolean isCheckAccessEnabled() {
        return this.isCheckAccessEnabled;
    }

    public String getPdsMapping() {
        return this.pdsMapping;
    }

    public String getTempDsnPrefix() {
        return this.tempDsnPrefix;
    }

    public boolean isCreateDirectoryAllowed() {
        return this.isCreateDirectoryAllowed;
    }

    public boolean isCreateDatasetAllowed() {
        return this.isCreateDatasetAllowed;
    }

    public boolean isMergedVersion() {
        return this.isMergedVersion;
    }

    public boolean isPrintLogsEnabled() {
        return this.isPrintLogsEnabled;
    }

    public boolean isDeleteCurrentContentsEnabled() {
        return this.isDeleteCurrentContentsEnabled;
    }

    public String getContainerFilter() {
        return this.containerFilter;
    }

    public boolean hasContainerFilter() {
        return !this.containerFilter.isEmpty();
    }

    public String getHfsMapping() {
        return this.hfsMapping;
    }

    public boolean isOldHfsMappingFormat() {
        return this.isOldHfsMappingFormat;
    }

    public boolean isBackupEnabled() {
        return this.isBackupEnabled;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public boolean isReplacePdsMemberDisabled() {
        return !this.isReplacePdsMemberEnabled;
    }

    public String getIspfGatewayBinPath() {
        return this.ispfGatewayBinPath;
    }

    public DeployedVersion getDeployedVersion() {
        return this.deployedVersion;
    }
}

