/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractSentinelIterator<T>
implements Iterator<T> {
    private T item = this.sentinel();

    protected AbstractSentinelIterator() {
    }

    @Override
    public boolean hasNext() {
        if (this.isSentinel(this.item)) {
            this.item = this.nextItem();
        }
        return !this.isSentinel(this.item);
    }

    @Override
    public T next() {
        T result = this.item;
        this.item = this.sentinel();
        if (this.isSentinel(result) && this.isSentinel(result = this.nextItem())) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract T nextItem();

    protected T sentinel() {
        return null;
    }

    protected boolean isSentinel(T item) {
        return item == null;
    }
}

