/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.zinventory;

import com.ibm.urbancode.zos.common.util.Console;
import com.ibm.urbancode.zos.common.util.UdClientHelper;
import com.ibm.urbancode.zos.zinventory.ZInventoryException;
import com.ibm.urbancode.zos.zinventory.ZInventoryRequestGenerator;
import com.urbancode.commons.util.IO;
import com.urbancode.ud.client.UDRestClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ZInventoryTable {
    private static final int SUCCESS_CODE = 204;
    private static final String Z_INVENTORY_BASE_PATH = "/cli/zInventory";
    private static final String ROLLBACK_PATH = "/rollback";
    private static final String ENVIRONMENT = "environment";
    private static final String VERSION = "version";
    private static final String DEPLOY_TIME = "deploy-time";
    private static final String RESOURCES = "resources";
    private static final int NOT_FOUND_CODE = 404;
    private final String environmentId;
    private final String versionId;

    public ZInventoryTable(String versionId, String environmentId) {
        this.versionId = versionId;
        this.environmentId = environmentId;
    }

    public void updateForRollback() throws IOException, URISyntaxException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair(ENVIRONMENT, this.environmentId));
        params.add((NameValuePair)new BasicNameValuePair(VERSION, this.versionId));
        this.rollbackDataInZInventoryTable(params);
    }

    public void updateForDeploy(long deployTime, String componentVersionWorkingDir) throws XMLStreamException, JSONException, IOException, URISyntaxException {
        JSONObject requestBody = new JSONObject();
        requestBody.put(ENVIRONMENT, (Object)this.environmentId);
        requestBody.put(VERSION, (Object)this.versionId);
        requestBody.put(DEPLOY_TIME, deployTime);
        requestBody.put(RESOURCES, this.getResources(componentVersionWorkingDir));
        this.addDeploymentDataToZInventoryTable(requestBody.toString());
    }

    private List<JSONObject> getResources(String componentVersionWorkingDir) throws XMLStreamException, IOException {
        ZInventoryRequestGenerator zInventoryRequestGenerator = new ZInventoryRequestGenerator(componentVersionWorkingDir);
        return zInventoryRequestGenerator.buildRequestPayload();
    }

    private void addDeploymentDataToZInventoryTable(String requestBody) throws IOException, URISyntaxException {
        try (DefaultHttpClient httpClient = UDRestClient.createHttpClient((String)"PasswordIsAuthToken", (String)UdClientHelper.UD_PASS, (boolean)true);){
            URI uri = new URI(UdClientHelper.WEB_URL + Z_INVENTORY_BASE_PATH);
            HttpPost method = new HttpPost(uri);
            method.setEntity((HttpEntity)new StringEntity(requestBody));
            this.invokeMethod((HttpRequestBase)method, httpClient);
        }
    }

    private void rollbackDataInZInventoryTable(List<NameValuePair> params) throws URISyntaxException, IOException {
        try (DefaultHttpClient httpClient = UDRestClient.createHttpClient((String)"PasswordIsAuthToken", (String)UdClientHelper.UD_PASS, (boolean)true);){
            URI uri = new URIBuilder(UdClientHelper.WEB_URL + Z_INVENTORY_BASE_PATH + ROLLBACK_PATH).addParameters(params).build();
            HttpPost method = new HttpPost(uri);
            this.invokeMethod((HttpRequestBase)method, httpClient);
        }
    }

    private String getBody(CloseableHttpResponse response) throws IOException {
        StringBuilder builder = new StringBuilder();
        InputStream body = response.getEntity().getContent();
        if (body != null) {
            try (InputStreamReader reader = IO.reader(body, IO.utf8());){
                IO.copy((Reader)reader, builder);
            }
        }
        return builder.toString();
    }

    private void invokeMethod(HttpRequestBase request, DefaultHttpClient httpClient) throws IOException {
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 204) {
            Console.printProcessOutput("Added Data to Z Inventory");
        } else if (statusCode == 404) {
            System.out.println();
        } else {
            throw new ZInventoryException("Status code - " + statusCode + "\nReason phrase - " + response.getStatusLine().getReasonPhrase() + "\n" + this.getBody(response));
        }
    }
}

