/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.version.mappings;

import com.ibm.urbancode.zos.xml.utils.common.XmlHelper;
import com.ibm.urbancode.zos.xml.utils.common.XmlIndentHandler;
import java.io.StringWriter;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ContainerMapperMvsXml {
    private static final String MAP_TYPE_PDS = "PDS";
    private static final String MAP_ELEMENT = "map";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String SOURCE_CONTAINER = "sourceContainer";
    private static final String TARGET_CONTAINERS = "targetContainers";
    private static final String TARGET_CONTAINER = "targetContainer";
    private static final String MAPS_ELEMENT = "maps";
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String XML_VERSION = "1.0";
    private final XmlIndentHandler xmlIndentHandler = new XmlIndentHandler();
    private XMLStreamWriter xmlStreamWriter = null;
    private final Map<String, Set<String>> map;

    private ContainerMapperMvsXml(Map<String, Set<String>> map) {
        this.map = map;
    }

    public static String from(Map<String, Set<String>> map) throws XMLStreamException {
        ContainerMapperMvsXml containerMapperXml = new ContainerMapperMvsXml(map);
        return containerMapperXml.create();
    }

    private String create() throws XMLStreamException {
        StringWriter stringWriter = new StringWriter();
        XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
        try {
            this.xmlStreamWriter = outputFactory.createXMLStreamWriter(stringWriter);
            this.writeXmlElements();
        }
        finally {
            if (this.xmlStreamWriter != null) {
                this.xmlStreamWriter.close();
            }
        }
        return stringWriter.toString();
    }

    private void writeXmlElements() throws XMLStreamException {
        this.writeXmlHeaderTag();
        this.writeStartingMapsTag();
        for (Map.Entry<String, Set<String>> entry : this.map.entrySet()) {
            this.writeStartingMapTag();
            this.writeSelfClosingContainerTag(SOURCE_CONTAINER, entry.getKey());
            this.writeTargetContainerTags(entry.getValue());
            this.writeEndingTag();
        }
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeEndDocument();
    }

    private void writeXmlHeaderTag() throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument(XmlHelper.getFileEncoding(), XML_VERSION);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeStartingMapsTag() throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement(MAPS_ELEMENT);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeStartingMapTag() throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement(MAP_ELEMENT);
        this.xmlStreamWriter.writeAttribute(TYPE_ATTRIBUTE, MAP_TYPE_PDS);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeTargetContainerTags(Set<String> targets) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getStartingTagIndent());
        this.xmlStreamWriter.writeStartElement(TARGET_CONTAINERS);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
        for (String target : targets) {
            this.writeSelfClosingContainerTag(TARGET_CONTAINER, target);
        }
        this.writeEndingTag();
    }

    private void writeSelfClosingContainerTag(String element, String name) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getSelfClosingTagIndent());
        this.xmlStreamWriter.writeEmptyElement(element);
        this.xmlStreamWriter.writeAttribute(NAME_ATTRIBUTE, name);
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }

    private void writeEndingTag() throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(this.xmlIndentHandler.getEndingTagIndent());
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(LINE_SEPARATOR);
    }
}

