/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.versions.cleanup;

import com.ibm.urbancode.zos.common.util.FileHelper;
import com.ibm.urbancode.zos.common.util.UdClientHelper;
import com.urbancode.air.plugin.command.versions.cleanup.PluginInputs;
import com.urbancode.commons.util.ssl.XTrustProvider;
import com.urbancode.ud.client.EnvironmentClient;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

final class CommonUtil {
    private static final String NAME_ATTRIBUTE = "name";

    private CommonUtil() {
    }

    public static void printComponentInfo(PluginInputs pluginInputs) {
        System.out.println();
        System.out.println("Application : " + pluginInputs.getApplicationName());
        System.out.println("Environment : " + pluginInputs.getEnvironmentName());
        System.out.println("Component   : " + pluginInputs.getComponentName());
        System.out.println();
    }

    public static EnvironmentClient getEnvironmentClient() throws URISyntaxException {
        EnvironmentClient envClient = UdClientHelper.getEnvironmentClient();
        XTrustProvider.install();
        return envClient;
    }

    public static int deleteVersionsDirectory(JSONArray versions, String componentDeployPath) throws JSONException, IOException {
        int count = 0;
        for (int i = 0; i < versions.length(); ++i) {
            JSONObject version = versions.getJSONObject(i);
            if (!CommonUtil.isValid(version)) continue;
            String versionName = version.getString(NAME_ATTRIBUTE).trim();
            String versionDeployDirectory = componentDeployPath + File.separator + versionName;
            FileHelper.cleanDirectory(versionDeployDirectory);
            System.out.println("Removed version:" + versionName);
            ++count;
        }
        return count;
    }

    public static int printVersionsName(JSONArray versions) throws JSONException {
        int count = 0;
        System.out.println("Versions to be removed:");
        System.out.println("-----------------------------------");
        for (int i = 0; i < versions.length(); ++i) {
            JSONObject version = versions.getJSONObject(i);
            if (!CommonUtil.isValid(version)) continue;
            String versionName = version.getString(NAME_ATTRIBUTE).trim();
            System.out.println(versionName);
            ++count;
        }
        return count;
    }

    private static boolean isValid(JSONObject version) throws JSONException {
        return null != version && version.has(NAME_ATTRIBUTE) && !version.getString(NAME_ATTRIBUTE).trim().isEmpty();
    }
}

