/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.metadata;

import java.util.Objects;

public class MetadataUtils {
    private static final String SHARED_LIBRARY = "MetadataUtils";
    private static final String SHARED_LIBRARY_64 = "MetadataUtils64";
    private static final String VM_BITMODE = "com.ibm.vm.bitmode";
    private static final String BITMODE_64 = "64";
    private static final String Z_OS = "z/OS";
    private static final String OS_NAME = "os.name";
    private static final int ERR_REC = 8;

    private static void loadNativeLibrary() {
        if (Z_OS.equals(System.getProperty(OS_NAME))) {
            String bitmode = System.getProperty(VM_BITMODE);
            String sharedLib = BITMODE_64.equals(bitmode) ? SHARED_LIBRARY_64 : SHARED_LIBRARY;
            try {
                System.loadLibrary(sharedLib);
            }
            catch (Exception e) {
                System.out.println("ERROR: Unable to load " + sharedLib);
                e.printStackTrace();
                System.exit(8);
            }
        }
    }

    private static native boolean addMetadataImpl(String var0, String var1, String var2, String var3, boolean var4) throws Exception;

    private static native boolean replaceMetadataImpl(String var0, String var1, String var2, String var3, boolean var4) throws Exception;

    private static native boolean removeMetadataImpl(String var0, String var1, String var2, boolean var3) throws Exception;

    private static native String getMetadataImpl(String var0, String var1, String var2, boolean var3) throws Exception;

    private static native String getTextClassIDsImpl(String var0, String var1, boolean var2) throws Exception;

    public static native boolean logToStderr();

    public static native boolean logToStdout();

    private static String checkDSN(String fullyQualifiedDSN) {
        Objects.requireNonNull(fullyQualifiedDSN, "Please specify a non-null fullyQualifiedDSN.");
        int minDsnLength = 3;
        int maxDsnLength = 44;
        if (fullyQualifiedDSN.length() < minDsnLength || fullyQualifiedDSN.length() > maxDsnLength) {
            throw new IllegalArgumentException("Please specify a fullyQualifiedDSN of length " + minDsnLength + " to " + maxDsnLength + " characters.");
        }
        if ((fullyQualifiedDSN = fullyQualifiedDSN.toUpperCase()).contains("'") || fullyQualifiedDSN.contains("\"")) {
            throw new IllegalArgumentException("Please specify a fullyQualifiedDSN without quotes or apostrophes.");
        }
        return fullyQualifiedDSN;
    }

    private static String checkMember(String memberName) {
        Objects.requireNonNull(memberName, "Please specify a non-null memberName.");
        int minMemberLength = 1;
        int maxMemberLength = 8;
        memberName = memberName.toUpperCase();
        if (memberName.length() < minMemberLength || memberName.length() > maxMemberLength) {
            throw new IllegalArgumentException("Please specify a memberName of length " + minMemberLength + " to " + maxMemberLength + " characters.");
        }
        return memberName;
    }

    public static String checkMetadataId(String metadataId) {
        Objects.requireNonNull(metadataId, "Please specify a non-null metadataId.");
        int minMetadataIdLength = 1;
        int maxMetadataIdLength = 16;
        if (metadataId.length() < minMetadataIdLength || metadataId.length() > maxMetadataIdLength) {
            throw new IllegalArgumentException("Please specify a metadataId of length " + minMetadataIdLength + " to " + maxMetadataIdLength + " characters.");
        }
        if (!(metadataId = metadataId.toUpperCase()).matches("[A-Z0-9\\_]{" + minMetadataIdLength + "," + maxMetadataIdLength + "}")) {
            throw new IllegalArgumentException("Please specify a metadataId consisting of A-Z 0-9 or underscore.");
        }
        if (metadataId.matches("[a-zA-Z]_.*")) {
            throw new IllegalArgumentException("Please specify a metadataId not starting with '<letter>_' as those are reserved by IBM for internal use.");
        }
        return metadataId;
    }

    private static String checkTextToAdd(String textToAdd) {
        Objects.requireNonNull(textToAdd, "Please specify a non-null textToAdd.");
        if (textToAdd.isEmpty()) {
            throw new IllegalArgumentException("Please specify a non-empty textToAdd.");
        }
        int maxTextLength = 0x100000;
        if (textToAdd.length() > maxTextLength) {
            throw new IllegalArgumentException("Please specify a textToAdd upto " + maxTextLength + " characters. (specified value length was " + textToAdd.length() + ").");
        }
        return textToAdd;
    }

    public static boolean addMetadata(String fullyQualifiedDSN, String memberName, String metadataId, String textToAdd, boolean debugMode) throws Exception {
        return MetadataUtils.addMetadataImpl(MetadataUtils.checkDSN(fullyQualifiedDSN), MetadataUtils.checkMember(memberName), MetadataUtils.checkMetadataId(metadataId), MetadataUtils.checkTextToAdd(textToAdd), debugMode);
    }

    public static boolean replaceMetadata(String fullyQualifiedDSN, String memberName, String metadataId, String textToAdd, boolean debugMode) throws Exception {
        return MetadataUtils.replaceMetadataImpl(MetadataUtils.checkDSN(fullyQualifiedDSN), MetadataUtils.checkMember(memberName), MetadataUtils.checkMetadataId(metadataId), MetadataUtils.checkTextToAdd(textToAdd), debugMode);
    }

    public static boolean removeMetadata(String fullyQualifiedDSN, String memberName, String metadataId, boolean debugMode) throws Exception {
        return MetadataUtils.removeMetadataImpl(MetadataUtils.checkDSN(fullyQualifiedDSN), MetadataUtils.checkMember(memberName), MetadataUtils.checkMetadataId(metadataId), debugMode);
    }

    public static String getMetadata(String fullyQualifiedDSN, String memberName, String metadataId, boolean debugMode) throws Exception {
        return MetadataUtils.getMetadataImpl(MetadataUtils.checkDSN(fullyQualifiedDSN), MetadataUtils.checkMember(memberName), MetadataUtils.checkMetadataId(metadataId), debugMode);
    }

    public static String getTextClassIDs(String fullyQualifiedDSN, String memberName, boolean debugMode) throws Exception {
        return MetadataUtils.getTextClassIDsImpl(MetadataUtils.checkDSN(fullyQualifiedDSN), MetadataUtils.checkMember(memberName), debugMode);
    }

    static {
        MetadataUtils.loadNativeLibrary();
    }
}

