/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.xml.utils.deploy;

import com.ibm.urbancode.zos.xml.utils.common.ContainerType;
import com.ibm.urbancode.zos.xml.utils.common.CopyType;
import com.ibm.urbancode.zos.xml.utils.common.XmlHelper;
import com.ibm.urbancode.zos.xml.utils.deploy.Container;
import com.ibm.urbancode.zos.xml.utils.deploy.ContainerMap;
import com.ibm.urbancode.zos.xml.utils.deploy.ElementsSorter;
import com.ibm.urbancode.zos.xml.utils.deploy.Inputs;
import com.ibm.urbancode.zos.xml.utils.deploy.InputsNode;
import com.ibm.urbancode.zos.xml.utils.deploy.OrderBy;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifestXml;
import com.ibm.urbancode.zos.xml.utils.deploy.Resource;
import com.ibm.urbancode.zos.xml.utils.deploy.TargetDatasetUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class PackageManifest {
    private static final Predicate<Container> IS_DELETED = Container::isDeleted;
    private static final Predicate<Container> IS_NOT_DELETED = IS_DELETED.negate();
    private final List<Container> containers = new ArrayList<Container>();
    private final String manifestFilePath;
    private List<Container> addedContainers = null;
    private List<Container> deletedContainers = null;
    private Container container = null;
    private Resource resource = null;
    private boolean isDeleted = false;
    private boolean hasDataset;
    private boolean hasHFSFile;
    private boolean hasGenericArtifact;
    private String manifestVersion;
    private String manifestType;
    private String timeZone;

    private PackageManifest(String manifestFilePath) {
        this.manifestFilePath = manifestFilePath;
    }

    public static PackageManifest from(String manifestFilePath, String mvsContainerMappingsFilePath) throws XMLStreamException, IOException {
        PackageManifest manifest = PackageManifest.from(manifestFilePath);
        ContainerMap containerMap = ContainerMap.from(mvsContainerMappingsFilePath);
        TargetDatasetUpdater.update(manifest, containerMap);
        return manifest;
    }

    public static PackageManifest from(String manifestFilePath) throws XMLStreamException, IOException {
        PackageManifest packageManifest = new PackageManifest(manifestFilePath);
        try (InputStream inputStream = Files.newInputStream(Paths.get(manifestFilePath, new String[0]), new OpenOption[0]);){
            packageManifest.parse(inputStream);
        }
        return packageManifest;
    }

    public PackageManifest sort(OrderBy orderBy) {
        new ElementsSorter<Container>(this.containers, orderBy).sort();
        for (Container container : this.containers) {
            container.sortResources(orderBy);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputStream inputStream) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newFactory();
        try (XMLStreamReader xmlStreamReader = null;){
            xmlStreamReader = inputFactory.createXMLStreamReader(inputStream, XmlHelper.getFileEncoding());
            while (xmlStreamReader.hasNext()) {
                int next = xmlStreamReader.next();
                if (next == 1) {
                    this.processStartElement(xmlStreamReader);
                    continue;
                }
                if (next != 2) continue;
                this.processEndElement(xmlStreamReader);
            }
        }
    }

    private void processStartElement(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String tagName = xmlStreamReader.getLocalName().trim();
        if (tagName.equalsIgnoreCase("manifest")) {
            this.manifestVersion = XmlHelper.getAttributeValue(xmlStreamReader, "version");
            if (this.manifestVersion == null) {
                this.manifestVersion = "v1_0";
            }
            this.manifestType = XmlHelper.getAttributeValue(xmlStreamReader, "type");
            this.timeZone = XmlHelper.getAttributeValue(xmlStreamReader, "timeZone");
        } else if (tagName.equalsIgnoreCase("deleted")) {
            this.isDeleted = true;
        } else if (tagName.equalsIgnoreCase("container")) {
            this.processContainerTag(xmlStreamReader);
        } else if (tagName.equalsIgnoreCase("resource") && this.container != null) {
            this.processResourceTag(xmlStreamReader);
        } else if (tagName.equalsIgnoreCase("property")) {
            this.processPropertyTag(xmlStreamReader);
        } else if (tagName.equalsIgnoreCase("inputs")) {
            this.processInputsTag(xmlStreamReader);
        }
    }

    private void processContainerTag(XMLStreamReader xmlStreamReader) {
        String containerName = XmlHelper.getAttributeValue(xmlStreamReader, "name");
        String containerDeployType = XmlHelper.getAttributeValue(xmlStreamReader, "deployType");
        ContainerType containerType = XmlHelper.getContainerType(xmlStreamReader, containerName);
        this.setContainerTypeFlag(containerType);
        this.container = new Container(containerName, containerType);
        this.container.setDeployType(containerDeployType);
        String copyType = XmlHelper.getAttributeValue(xmlStreamReader, "copyType");
        if (copyType != null) {
            this.container.setCopyType(CopyType.valueOf(copyType));
        }
        if (this.isDeleted) {
            this.container.setDeleted();
        }
    }

    private void setContainerTypeFlag(ContainerType containerType) {
        if (containerType == ContainerType.PDS || containerType == ContainerType.SEQUENTIAL) {
            this.hasDataset = true;
        } else if (containerType == ContainerType.DIRECTORY) {
            this.hasHFSFile = true;
        } else if (containerType == ContainerType.GENERIC) {
            this.hasGenericArtifact = true;
        }
    }

    private void processResourceTag(XMLStreamReader xmlStreamReader) {
        String resourceName = XmlHelper.getAttributeValue(xmlStreamReader, "name");
        String resourceType = XmlHelper.getAttributeValue(xmlStreamReader, "type");
        String resourceDeployType = XmlHelper.getAttributeValue(xmlStreamReader, "deployType");
        String lastModifiedTimestamp = XmlHelper.getAttributeValue(xmlStreamReader, "lastModifiedTimestamp");
        this.resource = new Resource(resourceName);
        this.resource.setType(resourceType);
        if (resourceDeployType != null) {
            this.resource.setResourceDeployType(resourceDeployType);
        } else if (this.container.getDeployType() != null) {
            this.resource.setContainerDeployType(this.container.getDeployType());
        }
        this.resource.setLastModifiedTimestamp(lastModifiedTimestamp);
    }

    private void processPropertyTag(XMLStreamReader xmlStreamReader) {
        String propertyName = XmlHelper.getAttributeValue(xmlStreamReader, "name");
        String propertyValue = XmlHelper.getAttributeValue(xmlStreamReader, "value");
        if (this.resource != null) {
            this.resource.addCustomerProperty(propertyName, propertyValue);
        } else if (this.container != null) {
            this.container.addCustomerProperty(propertyName, propertyValue);
        }
    }

    private void processInputsTag(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        Inputs inputs = InputsNode.fromXml(xmlStreamReader);
        if (this.resource != null) {
            this.resource.setInputs(inputs);
        } else if (this.container != null && this.container.isSequential()) {
            this.container.setInputs(inputs);
        }
    }

    private void processEndElement(XMLStreamReader xmlStreamReader) {
        String tagName = xmlStreamReader.getLocalName().trim();
        if (tagName.equalsIgnoreCase("deleted")) {
            this.isDeleted = false;
        } else if (tagName.equalsIgnoreCase("container")) {
            this.containers.add(this.container);
            this.container = null;
        } else if (tagName.equalsIgnoreCase("resource")) {
            this.container.addResource(this.resource);
            this.resource = null;
        }
    }

    public List<Container> getContainers() {
        return Collections.unmodifiableList(this.containers);
    }

    public List<Container> getAddedContainers() {
        if (this.addedContainers != null) {
            return Collections.unmodifiableList(this.addedContainers);
        }
        this.addedContainers = this.containers.stream().filter(IS_NOT_DELETED).collect(Collectors.toList());
        return Collections.unmodifiableList(this.addedContainers);
    }

    public List<Container> getDeletedContainers() {
        if (this.deletedContainers != null) {
            return Collections.unmodifiableList(this.deletedContainers);
        }
        this.deletedContainers = this.containers.stream().filter(IS_DELETED).collect(Collectors.toList());
        return Collections.unmodifiableList(this.deletedContainers);
    }

    public boolean hasDataset() {
        return this.hasDataset;
    }

    public boolean hasHFSFile() {
        return this.hasHFSFile;
    }

    public boolean hasGenericArtifact() {
        return this.hasGenericArtifact;
    }

    public boolean hasOnlyGenericArtifacts() {
        return this.hasGenericArtifact() && !this.hasDataset() && !this.hasHFSFile();
    }

    public boolean isNewPackageFormat() {
        return this.manifestVersion.equals("v2_0");
    }

    public void merge(PackageManifest otherManifest) {
        if (!this.manifestVersion.equals(otherManifest.getVersion())) {
            throw new IllegalArgumentException("Merging versions with different package manifest format is not supported.\nFile " + this.manifestFilePath + " is in format " + this.manifestVersion + " and File " + otherManifest.getManifestFilePath() + " is in format " + otherManifest.getVersion());
        }
        if (this.manifestVersion.equals("v1_0")) {
            if (this.hasHFSFile) {
                throw new IllegalArgumentException("File " + this.manifestFilePath + " contains HFS artifacts. Merging versions with HFS artifacts is not supported in " + "v1_0" + " format.");
            }
            if (otherManifest.hasHFSFile()) {
                throw new IllegalArgumentException("File " + otherManifest.getManifestFilePath() + " contains HFS artifacts. Merging versions with HFS artifacts is not supported in " + "v1_0" + " format.");
            }
        }
        for (Container otherContainer : otherManifest.getContainers()) {
            int index = this.getIndex(this.containers, otherContainer);
            if (index == -1) {
                this.containers.add(otherContainer);
                continue;
            }
            Container container = this.containers.get(index);
            for (Resource resource : otherContainer.getResources()) {
                container.addResource(resource);
            }
        }
    }

    private int getIndex(List<Container> containers, Container otherContainer) {
        for (int i = 0; i < containers.size(); ++i) {
            Container container = containers.get(i);
            if (!container.getSourceContainerName().equals(otherContainer.getSourceContainerName()) || container.getType() != otherContainer.getType() || container.isDeleted() != otherContainer.isDeleted()) continue;
            return i;
        }
        return -1;
    }

    public String getVersion() {
        return this.manifestVersion;
    }

    public String getManifestType() {
        return this.manifestType;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getManifestFilePath() {
        return this.manifestFilePath;
    }

    public String getXml() {
        try {
            return PackageManifestXml.from(this);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Failed to create XML from Package Manifest");
        }
    }
}

