/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.manifest;

import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestHandler;
import com.ibm.team.enterprise.automation.manifest.ManifestUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ManifestReader {
    private static ManifestReader instance;
    private final SAXParser parser;
    private Manifest manifest = null;

    private ManifestReader() throws Exception {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(ManifestUtils.getInstance().getSchemaURL());
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setSchema(schema);
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        this.parser = factory.newSAXParser();
    }

    public static ManifestReader getInstance() throws Exception {
        if (instance == null) {
            instance = new ManifestReader();
        }
        return instance;
    }

    public Manifest getManifest(File file) throws SAXException, IOException {
        if (file.isFile()) {
            this.read(file);
        }
        return this.manifest;
    }

    private void read(File file) throws SAXException, IOException {
        try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
            InputSource inputSource = new InputSource(inputStreamReader);
            ManifestHandler manifestHandler = new ManifestHandler();
            this.parser.parse(inputSource, (DefaultHandler)manifestHandler);
            this.manifest = manifestHandler.getManifest();
        }
    }
}

