/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.deploy.common;

import com.ibm.urbancode.zos.deploy.common.DataSet;
import com.ibm.urbancode.zos.deploy.common.Member;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageManifestParser {
    private static final String DeletedTagName = "deleted";
    private static final String DataSetTagName = "container";
    private static final String MemberTagName = "resource";
    private static final String PropertyTagName = "property";
    private static final String NameAttribute = "name";
    private static final String TypeAttribute = "type";
    private static final String DeployTypeAttribute = "deployType";
    private static final String packageManifestFileEncoding = "1047";
    private static final String PropertyTagNameAttribute = "name";
    private static final String PropertyTagValueAttribute = "value";

    public static Set<DataSet> parseDeployedDatasets(InputStream rollbackInputStream) throws XMLStreamException {
        HashMap<String, DataSet> deployedDatasetMap = new HashMap<String, DataSet>();
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader eventReader4Dataset = null;
        eventReader4Dataset = inputFactory.createXMLEventReader(rollbackInputStream, packageManifestFileEncoding);
        DataSet currentDataset = null;
        String currentDataSetName = null;
        String currentDataSetNameKey = null;
        String currentDataSetDeployType = null;
        String currentDataSetType = null;
        Member currentMember = null;
        boolean deleted = false;
        while (eventReader4Dataset.hasNext()) {
            String tagName;
            XMLEvent event = eventReader4Dataset.nextEvent();
            if (event.isStartElement()) {
                StartElement startElement = event.asStartElement();
                tagName = startElement.getName().getLocalPart().trim();
                if (tagName.equalsIgnoreCase(DeletedTagName)) {
                    deleted = true;
                    continue;
                }
                if (tagName.equalsIgnoreCase(DataSetTagName)) {
                    currentDataSetName = PackageManifestParser.getAttributeValue(startElement, "name");
                    currentDataSetNameKey = deleted ? currentDataSetName + "_DELETE" : currentDataSetName;
                    currentDataSetDeployType = PackageManifestParser.getAttributeValue(startElement, DeployTypeAttribute);
                    currentDataSetType = PackageManifestParser.getAttributeValue(startElement, TypeAttribute);
                    if (deployedDatasetMap.containsKey(currentDataSetNameKey)) {
                        currentDataset = (DataSet)deployedDatasetMap.get(currentDataSetNameKey);
                        continue;
                    }
                    currentDataset = new DataSet();
                    currentDataset.setType(currentDataSetType);
                    currentDataset.setDeployType(currentDataSetDeployType);
                    currentDataset.setName(currentDataSetName);
                    currentDataset.setSrcDataSetName(currentDataSetName);
                    currentDataset.setDelete(deleted);
                    deployedDatasetMap.put(currentDataSetNameKey, currentDataset);
                    continue;
                }
                if (tagName.equalsIgnoreCase(MemberTagName)) {
                    if (null == currentDataset || null == currentDataSetName) continue;
                    String memeberName = PackageManifestParser.getAttributeValue(startElement, "name");
                    String memberType = PackageManifestParser.getAttributeValue(startElement, TypeAttribute);
                    String memberDeployType = PackageManifestParser.getAttributeValue(startElement, DeployTypeAttribute);
                    if (null == memberDeployType || memberDeployType.length() == 0) {
                        memberDeployType = currentDataSetDeployType;
                    }
                    Member dsMember = new Member();
                    dsMember.setName(memeberName);
                    dsMember.setType(memberType);
                    dsMember.setDataSetName(currentDataSetName);
                    dsMember.setSrcDataSetName(currentDataSetName);
                    dsMember.setDeployType(memberDeployType);
                    currentMember = dsMember;
                    currentDataset.addMember(dsMember);
                    continue;
                }
                if (!tagName.equalsIgnoreCase(PropertyTagName)) continue;
                String propertyName = PackageManifestParser.getAttributeValue(startElement, "name");
                String propertyValue = PackageManifestParser.getAttributeValue(startElement, PropertyTagValueAttribute);
                if (null == propertyName || propertyName.length() <= 0) continue;
                if (null == propertyValue) {
                    propertyValue = "";
                }
                if (null != currentMember) {
                    currentMember.addCustomerProperty(propertyName, propertyValue);
                    continue;
                }
                if (null == currentDataset) continue;
                currentDataset.addCustomerProperty(propertyName, propertyValue);
                continue;
            }
            if (!event.isEndElement()) continue;
            EndElement endElement = event.asEndElement();
            tagName = endElement.getName().getLocalPart().trim();
            if (tagName.equalsIgnoreCase(DeletedTagName)) {
                deleted = false;
                continue;
            }
            if (tagName.equalsIgnoreCase(DataSetTagName)) {
                currentDataset = null;
                currentDataSetName = null;
                currentDataSetDeployType = null;
                continue;
            }
            if (!tagName.equalsIgnoreCase(MemberTagName)) continue;
            currentMember = null;
        }
        return new HashSet<DataSet>(deployedDatasetMap.values());
    }

    private static String getAttributeValue(StartElement startElement, String attributeName) {
        if (null == startElement || null == attributeName) {
            return null;
        }
        String attrValue = null;
        QName qn = new QName(attributeName);
        Attribute attribute = startElement.getAttributeByName(qn);
        if (null != attribute) {
            attrValue = attribute.getValue().trim();
        }
        return attrValue;
    }
}

