package com.ibm.urbancode.zos.common
/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Build
 * IBM UrbanCode Deploy
 * IBM UrbanCode Release
 * IBM AnthillPro
 * (c) Copyright IBM Corporation 2002, 2015. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */

import com.ibm.zos.sdsf.core.ISFRequestResults;
import com.ibm.zos.sdsf.core.ISFRequestSettings;
import com.ibm.zos.sdsf.core.ISFRunner;

public class MVSHelper {
	final def MAX_USERID_LENGTH = 8
	final def MAX_COMMAND_LENGTH = 126
	final debug = false
	def sdsfJarFile
	def sdsfLibraryPath

	def ISFRunner runner = null
	def ISFRequestResults results = null
	def returnCode = 0


	def createRunner(){
		if(runner == null){
			// Build a request settings to change the console name.
			// Console names should be unique to avoid in use conditions.
			final ISFRequestSettings settings = new ISFRequestSettings();
			final StringBuilder sb = new StringBuilder(System.getProperty("user.name"));
			if (sb.length() < MAX_USERID_LENGTH) {
				sb.append("x");
			}
			settings.addISFCons(sb.toString());

			// Get a runner used to access SDSF and assign the request settings
			runner = new ISFRunner(settings);
		}
	}

	def runCommand(mvsCommand){
		if(!mvsCommand || mvsCommand.length() < 1){
			println ("Command is empty")
			returnCode = 100
			return
		}
		if(mvsCommand.length() > MAX_COMMAND_LENGTH){
			println ("Command exceeded $MAX_COMMAND_LENGTH bytes")
			returnCode = 100
			return
		}

		createRunner()
		println('===============================')
		println (mvsCommand);
		returnCode = runner.system(mvsCommand)
		println "ReturnCode = " + returnCode

		// Get the results object
		results = runner.getRequestResults();
		if(returnCode > 0){
			println "ReasonCode = " + results.getReasonCode()
			results.printMessageList()
		}
		results.printResponseList()
	}

	def verifySDSF(){
		if(!sdsfLibraryPath || sdsfLibraryPath.length() < 1){
			println "SDSF Native Library Path can not be empty";
			return false
		}
		System.setProperty("java.library.path",sdsfLibraryPath+":"+System.getProperty("java.library.path"))

		createRunner()
		def code = runner.queryAuth();
		if(code != 0){
			println "Failed to run QUERY AUTH in SDSF. You must be authorized to use SDSF from Java and you must be authorized to the SDSF functions that you invoke from Java."
			return false
		}
		def r = runner.getRequestResults();
		def canUseLog = r.getMessageList().any{ it=="ISF444I ULOG" }
		if(!canUseLog){
			println "Warning: User " +  System.getProperty("user.name") + " is not authorized to use ULOG command from SDSF Java interface. "
			println "Warning: You may issue MVS commands but may not see the response of the commands."
			println "Warning: RACF resource ISFCMD.ODSP.ULOG.jesx CL(SDSF) gives user authority to issue the ULOG command."
		}

		return true
	}

	def debug(s){
		if(debug) println(s)
	}

}
