package com.ibm.urbancode.zos.common

import groovy.xml.StreamingMarkupBuilder
import groovy.xml.XmlUtil
/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

class PackageManifestXMLHelper {
	def fXmlParser;
	
	public PackageManifestXMLHelper() {
		fXmlParser = new XmlParser();
	}

	def getAllDeployDatasets(manifestFilePath) {
		def manifestFile = new File(manifestFilePath);
		if(!manifestFile.exists()){
			throw new IllegalArgumentException("${manifestFilePath} not found. Please make sure a Copy or FTP plug-in step is successfully executed before the Deploy plug-in step.");
		}
		
		def manifest = fXmlParser.parse(manifestFile);
		def resources = manifest.container + manifest.deleted.container;
		if(!resources || resources.size() < 1){
			throw new IllegalArgumentException("There is no datasets to deploy for this version");
		}
		
		def res = resources."@name";
		res = res*.trim();
		
		return res; 
	}
	
	def removeGenericResourceNodes(manifestFilePath, manifestFilePath4deploy) {
		def manifestFile = new File(manifestFilePath);
		if(!manifestFile.exists()){
			throw new IllegalArgumentException("${manifestFilePath} not found. Please make sure a Copy or FTP plug-in step is successfully executed before the Deploy plug-in step.");
		}
		def manifest = new XmlSlurper(false, false).parse(manifestFile)
		
		def allGenericContainers = manifest.container.findAll({node->
				node.@type == DeploymentConstants.GENERIC_CONTAINER_TYPE;
			});
		
		if (allGenericContainers.size()>0) {
			for (genericNode in allGenericContainers) {
				genericNode.replaceNode{};
			}
		}
		
		def builder = new StreamingMarkupBuilder();
		def smb = builder.bind{
			mkp.yield manifest
		};
	
		def seResult = XmlUtil.serialize(smb);
		def outputXml = seResult.toString().replaceAll("\\<\\?xml version=\"1.0\" encoding=\"UTF-8\"\\?\\>","<?xml version=\"1.0\"?>\n")
	
		new File(manifestFilePath4deploy).withWriter('IBM-1047'){ out ->
			out << outputXml
		}
	}
	
	def isGenericOnlyVersion(manifestFilePath) {
		def ret = false;
		
		def manifestFile = new File(manifestFilePath);
		if(!manifestFile.exists()){
			throw new IllegalArgumentException("${manifestFilePath} not found. Please make sure a Copy or FTP plug-in step is successfully executed before the Deploy plug-in step.");
		}
		def manifest = new XmlSlurper(false, false).parse(manifestFile)
		
		def allAddDatasetsContainers = manifest.container.findAll({node->
			node.@type != DeploymentConstants.GENERIC_CONTAINER_TYPE; 
		});
		if(allAddDatasetsContainers.size()>0) {
			return false;
		}
		
		def allDeleteDatasetsContainers = manifest.deleted.container.findAll({node->
			node.@type != DeploymentConstants.GENERIC_CONTAINER_TYPE; 
		});
		if(allDeleteDatasetsContainers.size()>0) {
			return false;
		}
	
		def allGenericContainers = manifest.container.findAll({node->
			node.@type == DeploymentConstants.GENERIC_CONTAINER_TYPE;
		});
		if (allGenericContainers.size()>0) {
			ret = true;
		}
		
		return ret;
	}
	
}
