import com.ibm.urbancode.zos.common.DeploymentConstants;
import com.ibm.urbancode.zos.common.DeploymentHelper;
import com.ibm.urbancode.zos.common.PackageManifestXMLHelper
import com.ibm.team.enterprise.deployment.toolkit.manifest.GenerateRollbackManifest;
import com.ibm.urbancode.zos.deploy.common.DeploymentResultHelper;

/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

try{
	final def workDir = new File('.').canonicalFile
	final def props = new Properties();
	final def inputPropsFile = new File(args[0]);
	try {
		inputPropsStream = new FileInputStream(inputPropsFile);
		props.load(inputPropsStream);
	}
	catch (IOException e) {
		throw new RuntimeException(e);
	}

	final def resourceId   		= DeploymentHelper.getStringInput(props['resourceId']);
	final def componentName 	= DeploymentHelper.getStringInput(props['componentName']);
	final def versionName 		= DeploymentHelper.getStringInput(props['versionName']);
	final def deployBasePath 	= DeploymentHelper.getStringInput(props['deployBasePath']);
	def toolKitHome 		= DeploymentHelper.getStringInput(System.getenv().get("BUZ_TOOLKIT_HOME"));
	if (!toolKitHome) {//try to compatible with application build on old plug-in(before v5)
		toolKitHome = DeploymentHelper.getStringInput(props['ucdToolKitHome']);
	}
	
	final def checkAccess 		= DeploymentHelper.getBooleanInput(props['checkAccess']);

	final def zosScriptPath 		= DeploymentHelper.getPath4ExecScriptInToolkit(toolKitHome , DeploymentConstants.ZOS_TOOLKIT_ISPF_SCRIPT_NAME);
	final def checkAccessExePath	= DeploymentHelper.getPath4ExecScriptInToolkit(toolKitHome , DeploymentConstants.CHECK_ACCESS_EXE);

	DeploymentHelper.validateDirectoryExist(deployBasePath, "Deploy Base Path ${deployBasePath} does not exist!");

	final def deployBasePathForVersion 	= DeploymentHelper.getVersionPathInDeployBasePath(deployBasePath, resourceId, componentName, versionName, true);
	final def rollbackMfFilePath 		= DeploymentHelper.getFilePathInDeployBasePath(deployBasePathForVersion, DeploymentConstants.ROLLBACK_MANIFEST_FILE_NAME);
	final def backupZipFilePath 		= DeploymentHelper.getFilePathInDeployBasePath(deployBasePathForVersion, DeploymentConstants.DEPLOY_BACKUP_FILE_NAME);
	final def containerFilePath 		= DeploymentHelper.getFilePathInDeployBasePath(deployBasePathForVersion, DeploymentConstants.CONTAINER_MAPPER_FILE_NAME);
	final def dsListFilePath 			= DeploymentHelper.getFilePathInDeployBasePath(deployBasePathForVersion, DeploymentConstants.CHECK_ACCESS_DS_FILE_NAME);
	final def packageManifestFilePath 	= DeploymentHelper.getFilePathInDeployBasePath(deployBasePathForVersion, DeploymentConstants.PACKAGE_MANIFEST_FILE_NAME);
	
	if (DeploymentResultHelper.checkVersionDeployed(deployBasePath, resourceId, componentName, versionName)) {
		def pkgManifestHelper = new PackageManifestXMLHelper();
		if (pkgManifestHelper.isGenericOnlyVersion(packageManifestFilePath)) {
			DeploymentHelper.printActionTitle("Warning: No artifacts to rollback.");
			System.exit(0);
		}
	} else {
		println "Please make sure you have deployed the version successfully and haven't rolled back it already.";
		System.exit(1);
	}

	

	//Do some validation
	DeploymentHelper.validateFileExist(zosScriptPath, "Can not find the ispf gateway script: ${zosScriptPath}. Please make sure z/OS Deploy Toolkit is installed and z/OS Toolkit Home is set to the correct location.");
	def errorInfo = """ does not exist or is not a file. 
Error rolling back because one of the files needed for rollback is not found. 
Please make sure you have deployed the version successfully and haven't rolled back it already."""
	DeploymentHelper.validateFileExist(rollbackMfFilePath, rollbackMfFilePath + errorInfo);
	DeploymentHelper.validateFileExist(containerFilePath, containerFilePath + errorInfo);
	//backup.zip may not exist if the last deploy is create
	//DeploymentHelper.validateFileExist(backupZipFilePath, backupZipFilePath + errorInfo);

	def dsListFileExist = true;
	if( checkAccess ){
		if( !DeploymentHelper.fileExists(dsListFilePath) ){
			dsListFileExist = false;
			println "Warning:The target dataset list file ${dsListFilePath} is not found, make sure you have checked the 'Check Access' option during the deployment stage,the check access was skipped."
			//		throwRollbackFileNotFoundException(dsListFilePath);
		}
	}

	final def wdPath = workDir.canonicalPath;
	final def currentVersionWorkingDir 	= DeploymentHelper.getVersionDirPathInWorkingDir(wdPath,versionName, resourceId);
	final def toDeployDeltaFilePath		= DeploymentHelper.getFilePathInWorkingDir(wdPath, versionName, resourceId, DeploymentConstants.DEPLOY_DELTA_FILE_NAME);
	final def toRollbackMfFilePath 		= DeploymentHelper.getFilePathInWorkingDir(wdPath, versionName, resourceId, DeploymentConstants.ROLLBACK_MANIFEST_FILE_NAME);
	final def toBackupZipFilePath 		= DeploymentHelper.getFilePathInWorkingDir(wdPath, versionName, resourceId, DeploymentConstants.DEPLOY_BACKUP_FILE_NAME);
	final def toContainerFilePath 		= DeploymentHelper.getFilePathInWorkingDir(wdPath, versionName, resourceId, DeploymentConstants.CONTAINER_MAPPER_FILE_NAME);
	final def toDsListFilePath 			= DeploymentHelper.getFilePathInWorkingDir(wdPath, versionName, resourceId, DeploymentConstants.CHECK_ACCESS_DS_FILE_NAME);

	//Do some clean work before copying files
	DeploymentHelper.cleanWorkDir(currentVersionWorkingDir);

	//Copy files need by rollback
	def antCopy = new AntBuilder();
	try {
		DeploymentHelper.printActionTitle("Copy backup into working directory:");
		antCopy.copy(verbose: "true",file:"$rollbackMfFilePath", tofile:"$toDeployDeltaFilePath",overwrite: "true");
		antCopy.copy(verbose: "true",file:"$containerFilePath", tofile:"$toContainerFilePath",overwrite: "true");
		//backup.zip may not exist if the last deploy is create
		antCopy.copy(verbose: "true",file:"$backupZipFilePath", tofile:"$toBackupZipFilePath",overwrite: "true", failonerror: "false");

		if(checkAccess && dsListFileExist){
			antCopy.copy(verbose: "true",file:"$dsListFilePath", tofile:"$toDsListFilePath",overwrite: "true");
		}
		
		println "";
	}
	catch (Exception e) {
		DeploymentHelper.printActionTitle("Error getting backup data.${e.message}");
		System.exit(1);
	}

	//generate rollback manifest based on the deltaDeploy xml
	new GenerateRollbackManifest(toDeployDeltaFilePath,toRollbackMfFilePath);

	if(checkAccess && dsListFileExist){
		DeploymentHelper.printActionTitle("Check access for Roll back action:");
		DeploymentHelper.callCheckAccess(checkAccessExePath, toDsListFilePath, "output");
		println "";
	}

	//Rollback
	DeploymentHelper.rollback(zosScriptPath, currentVersionWorkingDir, DeploymentConstants.ZOS_TOOLKIT_TRACE_ON);

	final def delBackUpFiles = DeploymentHelper.getBooleanInput(props['delBackUpFiles']);
	if( delBackUpFiles ){
		DeploymentHelper.printActionTitle("Delete those backup files on request:")
		DeploymentHelper.cleanBackUpData(deployBasePathForVersion);
		println "";
	}

	//Clear the working directory to avoid dirty data
	//Just delete those files we created
	DeploymentHelper.cleanWorkDir(currentVersionWorkingDir);
} catch (Exception e) {
	DeploymentHelper.printProcessOutput("${e.message}");
	System.exit(1);
}

System.exit(0);
