/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import static java.lang.Integer.valueOf
import com.ibm.urbancode.zos.jes.JESJob;
import com.ibm.urbancode.zos.jes.JobUtil;
import com.ibm.urbancode.zos.jes.passticket.PassTicketUtil;


try{
	def apTool = new AirPluginTool(this.args[0], this.args[1])
	final def workDir = new File('.').canonicalFile
	def props = apTool.getStepProperties();
	final def inputPropsFile = new File(args[0]);

	final def jobId = props['jobId']?.trim();
	final def waitForJob = true;
	final def timeout = props['timeout']?.trim();
	final def showOutput = props['showOutput']?.trim();
	final def cutOff = props['cutOff']?.trim();
	final def maxRC = props['maxRC']?.trim();

	final def hostname = props['hostname']?.trim();
	final def userid = props['userid']?.trim();
	final def password = props['password']?.trim();
	final def port = props['port']?.trim();
	final def usePassticket = Boolean.valueOf(props['usePassticket']?.trim());
	final def irrracfLibraryPath 	= props['irrracfLibraryPath']?.trim();
	final def APPL_ID="FEKAPPL";

	def jobid = jobId;

	
	if(!hostname || hostname.length() < 1){
		throw new IllegalArgumentException("Host Name can not be empty.");
	}
	if(!userid || userid.length() < 1){
		throw new IllegalArgumentException("User ID can not be empty.");
	}
	userid = userid.toUpperCase();

		if(!password || password.length() < 1){
		if(usePassticket){
			println "Password is empty. Using PassTicket authentication."
			password = PassTicketUtil.generatePassTicket(userid,APPL_ID,irrracfLibraryPath);
		}else{
			throw new IllegalArgumentException("Password can not be empty.");
		}
	}
	if(!port || port.length() < 1){
		throw new IllegalArgumentException("Port can not be empty.");
	}
	
	def jobUtil = new JobUtil(hostname,port,userid,password)
	
		try{
			int timeoutValue = valueOf(timeout as String);
			jobUtil.setTimeout(timeoutValue);
		}catch(NumberFormatException e){
			throw new IllegalArgumentException("Time Out isn't a number.");
		}
		try{
			int cutOffValue = valueOf(cutOff as String);
			jobUtil.setCutoff(cutOffValue);
		}catch(NumberFormatException e){
			throw new IllegalArgumentException("Cut Off isn't a number.");
		}		
		try{
			int maxRCValue = valueOf(maxRC as String);
			jobUtil.setMaxReturnCode(maxRCValue);
		}catch(NumberFormatException e){
			throw new IllegalArgumentException("Max Return Code isn't a number.");
		}		
		jobUtil.setShowOutput(showOutput);
		
		def success = jobUtil.waitForJob(jobid);
		jobUtil.printLog(jobid);

		def job = jobUtil.getJob(jobid, true);
		apTool.setOutputProperty("JobId", jobid);
		apTool.setOutputProperty("JobReturnCode", job.getReturnCode()==null?"":job.getReturnCode());
		apTool.setOutputProperty("JobReturnInfo", job.getReturnInfo()==null?"":job.getReturnInfo());
		apTool.setOutputProperty("JobReturnStatus", job.getReturnStatus()==null?"":job.getReturnStatus());
		apTool.storeOutputProperties();

		jobUtil.disconnect();
		if(success){
			System.exit(0);
		}else{
			System.exit(1);
		}

}catch (Exception e) {
    println "Error Running Job: ${e.message}";
	e.printStackTrace();
    System.exit(1);
}

System.exit(0);

