import com.ibm.urbancode.zos.common.DeploymentConstants;
import com.ibm.urbancode.zos.common.DeploymentHelper;
import com.ibm.urbancode.zos.common.PackageManifestXMLHelper
import com.urbancode.air.AirPluginTool


/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

try {
	def apTool = new AirPluginTool(this.args[0], this.args[1]);
	final def workDir = new File('.').canonicalFile
	final def props = new Properties();
	final def inputPropsFile = new File(args[0]);
	try {
		inputPropsStream = new FileInputStream(inputPropsFile);
		props.load(inputPropsStream);
	}
	catch (IOException e) {
		throw new RuntimeException(e);
	}

	final def versionName    	= DeploymentHelper.getStringInput(props['versionName']);
	def repositoryType = DeploymentHelper.getStringInput(props['repositoryType']);
	if ("CODESTATION".equalsIgnoreCase(repositoryType)) {
		println("Version ${versionName} is stored in CodeStation. Use Download Artifacts for zOS step to retrieve the version.");
		println("Copy failed.");
		System.exit(1);
	}

	final def componentName 	= DeploymentHelper.getStringInput(props['componentName']);
	final def repositoryPath 	= DeploymentHelper.getStringInput(props['basePath']);
	final def directoryOffset 	= DeploymentHelper.getStringInput(props['directoryOffset']);
	final def resourceId   		= DeploymentHelper.getStringInput(props['resourceId']);

	def workingDirBasePath = workDir;
	if (directoryOffset) {
		workingDirBasePath = new File(workDir, directoryOffset).canonicalFile;
	}

	final def workingComponentPath 			= workingDirBasePath.canonicalPath;
	final def pkgZipFilePathInRepo 			= DeploymentHelper.getFilePathInRepository(repositoryPath, componentName, versionName, DeploymentConstants.PACKAGE_FILE_NAME);
	final def pkgZipFilePathToWorkingDir	= DeploymentHelper.getFilePathInWorkingDir(workingComponentPath, versionName, resourceId, DeploymentConstants.PACKAGE_FILE_NAME);

	final def pkgManifestFilePathInRepo 	= DeploymentHelper.getFilePathInRepository(repositoryPath, componentName, versionName, DeploymentConstants.PACKAGE_MANIFEST_FILE_NAME);
	final def pkgManifestPathToWorkingdir 	= DeploymentHelper.getFilePathInWorkingDir(workingComponentPath, versionName, resourceId, DeploymentConstants.PACKAGE_MANIFEST_FILE_NAME);

	//Check two files exists before copying
	DeploymentHelper.validateFileExist(pkgManifestFilePathInRepo, "${pkgManifestFilePathInRepo} does not exist in the repository");

	//Clean up before copying step to avoid old dirty data
	final def workVersionDir = DeploymentHelper.getVersionDirPathInWorkingDir(workingComponentPath, versionName, resourceId);
	DeploymentHelper.cleanWorkDir(workVersionDir);

	def ant = new AntBuilder();
	println "Start to copy files";
	try {
		ant.copy(verbose: "true",file:"${pkgManifestFilePathInRepo}", tofile:"${pkgManifestPathToWorkingdir}",overwrite: "true");
	}
	catch (Exception e) {
		println "Error copying package: ${e.message}";
		System.exit(1);
	}

	//Verify the copying result
	DeploymentHelper.verifyGetArtifectResult(pkgManifestPathToWorkingdir,"Error copying ${DeploymentConstants.PACKAGE_MANIFEST_FILE_NAME} to ${pkgManifestPathToWorkingdir}");
	
	def packageManifestHelper = new PackageManifestXMLHelper();
	if (packageManifestHelper.isGenericOnlyVersion(pkgManifestPathToWorkingdir)) {
		apTool.setOutputProperty("genericonly", "true");
	} else {
		apTool.setOutputProperty("genericonly", "false");
		
		def file = new File(pkgZipFilePathInRepo);
		if(file.exists()){
			ant.copy(verbose: "true",file:"${pkgZipFilePathInRepo}", tofile:"${pkgZipFilePathToWorkingDir}",overwrite: "true");
		} else{
			println "Warning: ${pkgZipFilePathInRepo} doesn't exist. Either the version does not have physical artifacts or there is a problem.";
		}
	}
	
	apTool.storeOutputProperties()
} catch (Exception e) {
	println "${e.message}";
	e.printStackTrace();
	System.exit(1);
}

System.exit(0);