import com.ibm.urbancode.zos.common.TSOHelper;
import com.ibm.urbancode.zos.deploy.common.DataSet;
import com.ibm.urbancode.zos.deploy.common.DeploymentResultHelper;
import com.ibm.urbancode.zos.deploy.common.Member;
import com.ibm.urbancode.zos.common.DeploymentHelper;
import com.urbancode.air.AirPluginTool

/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

try{
	final def workDir = new File('.').canonicalFile
	def apTool = new AirPluginTool(this.args[0], this.args[1])
	def props = apTool.getStepProperties();

	final def tsoCommand 		= DeploymentHelper.getStringInput(props['tsoCommand']);
	final def ispfGatewayPath 	= DeploymentHelper.getStringInput(props['ispfGatewayPath']);
	final def stopOnFail 		= DeploymentHelper.getBooleanInput(props['stopOnFail']);
	final def reuseSession 		= DeploymentHelper.getBooleanInput(props['reuseSession']);
	final def showLog 			= DeploymentHelper.getBooleanInput(props['showLog']);
	final def serviceType 		= DeploymentHelper.getStringInput(props['serviceType']);
	final def ispProf 			= DeploymentHelper.getStringInput(props['ispProf']);

	def tsoHelper = new TSOHelper()
	tsoHelper.ispfGatewayPath = ispfGatewayPath
	tsoHelper.reuseSession = reuseSession
	tsoHelper.serviceType = serviceType
	tsoHelper.ispProf = ispProf
//	tsoHelper.debug=true

	def success = true
	def lineCount = 0
	tsoCommand.eachLine {
		lineCount ++
	}
	tsoCommand.eachLine {
		lineCount --
		if(!success && stopOnFail){
			println it
		}else{
			if(it!=null && it.trim().length()>0){
				runTSOCommand(it, tsoHelper, showLog)
				if(tsoHelper.returnCode > 0){
					success = false
					if(stopOnFail && lineCount > 0){
						println "Following commands are not executed because Stop On Fail is set to true."
					}
				}
			}
		}
	}
	if(!success){
		System.exit(1)
	}
} catch (Exception e) {
    println "Error executing TSO/ISPF command: ${e.message}";
	e.printStackTrace();
    System.exit(1);
}

def runTSOCommand(tsoCommand, TSOHelper tsoHelper, boolean showLog){


	println('===============================')
	println (tsoHelper.serviceType + " command: ")
	println (tsoCommand);
	
	exitValue = tsoHelper.runCommand(tsoCommand)
	if( exitValue == 0){
		println('===============================')
		println("Command output: ")

		if(tsoHelper.serviceType == "ISPF"){
			if(tsoHelper.returnCode > 0){
				println("ISPF Gateway call failed with return code: ${tsoHelper.returnCode}")
				println("${tsoHelper.reasonCode}")
			}
		}

		println(tsoHelper.outputText)
	
		if(showLog){
			println('===============================')
			println("ISPF Gateway operations log")
			println(tsoHelper.operationsLog)
		}
	}else{
		println("Process exit code: ${exitValue}")
	}
	println('===============================')
	println("")
}

System.exit(0);

