/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.jes.utils;

import com.ibm.urbancode.zos.jes.utils.IJESMinerConstants;

public class JmonProtocol
implements IJESMinerConstants {
    public static final String COPY_RIGHT = "";
    String major;
    String minor;

    public JmonProtocol(String major, String minor) {
        this.major = major;
        this.minor = minor;
    }

    public JmonProtocol(String level) {
        int idx = level.length() - 2;
        this.major = level.substring(0, idx);
        this.minor = level.substring(idx);
    }

    public String getMajorLevel() {
        return this.major;
    }

    public String getMinorLevel() {
        return this.minor;
    }

    public String getLevel() {
        return this.major + this.minor;
    }

    public String getConnectCommand() {
        return "CONNECT" + this.major + " v" + this.minor;
    }

    public String getProtocolToken() {
        return "PROTOCOL" + this.major + "v" + this.minor;
    }

    public static JmonProtocol scanToken(String tok) {
        String TEMPLATE = "PROTOCOLmmvnn";
        String PREFIX = "PROTOCOL";
        JmonProtocol level = null;
        if (tok != null && tok.length() >= "PROTOCOLmmvnn".length() && tok.startsWith("PROTOCOL")) {
            int vidx = tok.indexOf(118);
            int endidx = tok.indexOf(32);
            endidx = endidx > 0 ? endidx : tok.length();
            level = new JmonProtocol(tok.substring("PROTOCOL".length(), vidx), tok.substring(vidx + 1, endidx));
        }
        return level;
    }

    public static JmonProtocol scanAck(String ack) {
        String TEMPLATE = "ACKNOWLEDGEmmvnn";
        String ACK = "ACKNOWLEDGE";
        JmonProtocol level = null;
        if (ack != null && ack.length() >= "ACKNOWLEDGEmmvnn".length() && ack.startsWith("ACKNOWLEDGE")) {
            int vidx = ack.indexOf(118);
            int endidx = ack.indexOf(32);
            endidx = endidx > 0 ? endidx : ack.length();
            level = new JmonProtocol(ack.substring("ACKNOWLEDGE".length(), vidx), ack.substring(vidx + 1, endidx));
        }
        return level;
    }

    public boolean isLaterThan(JmonProtocol base) {
        if (base == null) {
            return true;
        }
        return this.getLevel().compareTo(base.getLevel()) > 0;
    }

    public boolean isEarlierThan(JmonProtocol base) {
        if (base == null) {
            return false;
        }
        return this.getLevel().compareTo(base.getLevel()) < 0;
    }

    public String toString() {
        return this.major + "v" + this.minor;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JmonProtocol)) {
            return false;
        }
        return this.getLevel().equals(((JmonProtocol)o).getLevel());
    }
}

