/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
package com.ibm.urbancode.zos.common

import groovy.xml.StreamingMarkupBuilder
import groovy.xml.XmlUtil

class PackageManifestXMLHelper {
	def fXmlParser;
	
	public PackageManifestXMLHelper() {
		fXmlParser = new XmlParser();
	}

	def getAllDeployDatasets(manifestFilePath) {
		def manifestFile = new File(manifestFilePath);
		def manifest = fXmlParser.parse(manifestFile);
		
		
		def allAddDatasetsContainers = manifest.container.findAll({node->
			node.@type == DeploymentConstants.PDS_CONTAINER_TYPE ||
			node.@type == DeploymentConstants.SEQUANTIAL_CONTAINER_TYPE
		});
		
		def allDeleteDatasetsContainers = manifest.deleted.container.findAll({node->
			node.@type == DeploymentConstants.PDS_CONTAINER_TYPE ||
			node.@type == DeploymentConstants.SEQUANTIAL_CONTAINER_TYPE
		});
		
		def allCreatedDatasetsContainers = manifest.created.container.findAll({node->
			node.@type == DeploymentConstants.PDS_CONTAINER_TYPE ||
			node.@type == DeploymentConstants.SEQUANTIAL_CONTAINER_TYPE
		});

		def allUpdatedDatasetsContainers = manifest.updated.container.findAll({node->
			node.@type == DeploymentConstants.PDS_CONTAINER_TYPE ||
			node.@type == DeploymentConstants.SEQUANTIAL_CONTAINER_TYPE
		});
		
		def allDataSets = allAddDatasetsContainers + allDeleteDatasetsContainers + allCreatedDatasetsContainers + allUpdatedDatasetsContainers;
		if(!allDataSets || allDataSets.size() < 1){
			throw new IllegalArgumentException("There is no datasets to deploy for this version");
		}
		
		def names = allDataSets."@name";
		names = names*.trim();
		
		return names; 
	}
	
	def removeNodes4Deployment(manifestFilePath, manifestFilePath4deploy) {
		def manifestFile = new File(manifestFilePath);
		if(!manifestFile.exists()){
			throw new IllegalArgumentException("${manifestFilePath} not found. Please make sure a Copy or FTP plug-in step is successfully executed before the Deploy plug-in step.");
		}
		def manifest = new XmlParser().parse(manifestFile)
		
		def allGenericContainers = manifest.container.findAll({node->
				node.@type == DeploymentConstants.GENERIC_CONTAINER_TYPE;
			});
		def allContainerInputsNodes = manifest.container.inputs;
		def allResourceInputsNodes = manifest.container.resource.inputs;
		
		if (allGenericContainers.size()>0 || allContainerInputsNodes.size()>0 || allResourceInputsNodes.size()>0) {
			if (allGenericContainers.size()>0) {
				for (genericNode in allGenericContainers) {
					def parent = genericNode.parent();
					parent.remove(genericNode);
				}
			}
			if (allContainerInputsNodes.size()>0) {
				for (containerInputs in allContainerInputsNodes) {
					def parent = containerInputs.parent();
					parent.remove(containerInputs);
				}
			}
			if (allResourceInputsNodes.size()>0) {
				for (resourceInputs in allResourceInputsNodes) {
					def parent = resourceInputs.parent();
					parent.remove(resourceInputs);
				}
			}
			
			def seResult = new StringWriter().with { sw ->
				new XmlNodePrinter( new PrintWriter( sw ) ).print( manifest );
				sw.toString();
			}
			def outputXml = "<?xml version=\"1.0\"?>\n" + seResult.toString();
		
			new File(manifestFilePath4deploy).withWriter('IBM-1047'){ out ->
				out << outputXml
			}
		}
		else {
			(new AntBuilder()).copy(file:"${manifestFilePath}", tofile:"${manifestFilePath4deploy}");
		}
	}
	
	def isGenericOnlyVersion(manifestFilePath) {
		def ret = false;
		
		def manifestFile = new File(manifestFilePath);
		def manifest = new XmlSlurper(false, false).parse(manifestFile)
		
		def allAddDatasetsContainers = manifest.container.findAll({node->
			node.@type != DeploymentConstants.GENERIC_CONTAINER_TYPE; 
		});
		if(allAddDatasetsContainers.size()>0) {
			return false;
		}
		
		def allDeleteDatasetsContainers = manifest.deleted.container.findAll({node->
			node.@type != DeploymentConstants.GENERIC_CONTAINER_TYPE; 
		});
		if(allDeleteDatasetsContainers.size()>0) {
			return false;
		}
	
		def allGenericContainers = manifest.container.findAll({node->
			node.@type == DeploymentConstants.GENERIC_CONTAINER_TYPE;
		});
		if (allGenericContainers.size()>0) {
			ret = true;
		}
		
		return ret;
	}
	
	//check for any PDS or sequential type containers.
	def hasDataSets(manifestFilePath) {
		def manifestFile = new File(manifestFilePath);
		def manifest = new XmlSlurper(false, false).parse(manifestFile)
		
		def allAddDatasetsContainers = manifest.container.findAll({node->
			node.@type == DeploymentConstants.PDS_CONTAINER_TYPE || 
			node.@type == DeploymentConstants.SEQUANTIAL_CONTAINER_TYPE
		});
	
		if(allAddDatasetsContainers.size()>0) {
			return true;
		}
		
		def allDeleteDatasetsContainers = manifest.deleted.container.findAll({node->
			node.@type == DeploymentConstants.PDS_CONTAINER_TYPE || 
			node.@type == DeploymentConstants.SEQUANTIAL_CONTAINER_TYPE
		});
		if(allDeleteDatasetsContainers.size()>0) {
			return true;
		}
		
		def allCreatedDatasetsContainers = manifest.created.container.findAll({node->
			node.@type == DeploymentConstants.PDS_CONTAINER_TYPE ||
			node.@type == DeploymentConstants.SEQUANTIAL_CONTAINER_TYPE
		});
		if(allCreatedDatasetsContainers.size()>0) {
			return true;
		}
		def allUpdatedDatasetsContainers = manifest.updated.container.findAll({node->
			node.@type == DeploymentConstants.PDS_CONTAINER_TYPE ||
			node.@type == DeploymentConstants.SEQUANTIAL_CONTAINER_TYPE
		});
		if(allUpdatedDatasetsContainers.size()>0) {
			return true;
		}

		
		return false;
	}

	//check for any HFS file containers
	def hasHFSFiles(manifestFilePath) {
		def manifestFile = new File(manifestFilePath);
		def manifest = new XmlSlurper(false, false).parse(manifestFile)
		
		def allAddDirectoryContainers = manifest.container.findAll({node->
			node.@type == DeploymentConstants.DIRECTORY_CONTAINER_TYPE 
		});
	
		if(allAddDirectoryContainers.size()>0) {
			return true;
		}
		
		def allDeleteDirectoryContainers = manifest.deleted.container.findAll({node->
			node.@type == DeploymentConstants.DIRECTORY_CONTAINER_TYPE 
		});
		if(allDeleteDirectoryContainers.size()>0) {
			return true;
		}

		def allCreatedDirectoryContainers = manifest.created.container.findAll({node->
			node.@type == DeploymentConstants.DIRECTORY_CONTAINER_TYPE
		});
		if(allCreatedDirectoryContainers.size()>0) {
			return true;
		}

		def allUpdatedDirectoryContainers = manifest.updated.container.findAll({node->
			node.@type == DeploymentConstants.DIRECTORY_CONTAINER_TYPE
		});
		if(allCreatedDirectoryContainers.size()>0) {
			return true;
		}

		return false;
	}
		
}
