/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
package com.ibm.urbancode.zos.common;
 
import com.ibm.jzos.*;
import java.util.regex.Pattern
public class DataSetHelper {
	public static Map<String,String> searchNonVsamDataset(String pattern,int max=-1){
		CatalogSearch catSearch = new CatalogSearch(pattern);
		catSearch.setEntryTypes(new String("A"));
		catSearch.addFieldName("ENTNAME");
		catSearch.addFieldName("VOLSER");
		catSearch.search();
		def Map<String,String> result = [:];
		while(catSearch.hasNext()){
			CatalogSearch.Entry entry=catSearch.next();
			if(entry.isDatasetEntry()){
				CatalogSearchField datasetName = entry.getField("ENTNAME")
				CatalogSearchField volume = entry.getField("VOLSER");
				if(max<0||(max>0&&result.size()<=max)){
					result.put(datasetName.getFString().trim(), volume.getFString().trim());
				}else{
					break;
				}
			}
		}
		return result;
	}
	
	//get PDS members based on the member pattern
	//return the data set name if it is sequential
	public static List<String> getMemebers(String datasetName, String volume, String memberPattern){
		def List<String> result=[];
        def pattern = makeRegexPattren(memberPattern);
        
		Format1DSCB dscb = ZFile.obtainDSN(getSlashSlashQuotedDSN(datasetName), volume);
		if(dscb.getDS1DSORG() == Format1DSCB.DS1DSGPS){
			//DSORG = PS
			result.add(getSlashSlashQuotedDSN(datasetName));
		}else if (dscb.getDS1DSORG() == Format1DSCB.DS1DSGPO){
			//DSORG = PO
			if(memberPattern?.trim()){
				def PdsDirectory pds = new PdsDirectory(getSlashSlashQuotedDSN(datasetName))
				def Iterator iterator=pds.iterator();
				while(iterator.hasNext()){
					PdsDirectory.MemberInfo member = iterator.next();
					def memberName = member.getName();
					if(memberName.matches(pattern)){
						result.add(getSlashSlashQuotedDSN("$datasetName($memberName)"));
					}
				}
				pds.close();
			}
		}
		return result;
	}

	public static String getSlashSlashQuotedDSN(String datasetName){
		return ZFile.getSlashSlashQuotedDSN(datasetName,true);
	}
	
    
    public static String makeRegexPattren(String memberPattern){
        // memberPattern is a member name. It supports * (and only *) as wildcard. 
        // This method turns it into a regular expression pattern
        //
        //Data set name specification:
        //Each name segment (qualifier) is 1 to 8 characters, the first of which must be alphabetic (A to Z)
        //or national (# @ $). The remaining seven characters are either alphabetic, numeric (0 - 9), national,
        //a hyphen (-). Name segments are separated by a period (.).
        //
        //The metacharacters in Java regular expression are: <([{\^-=$!|]})?*+.>
        def pattern = memberPattern;
        pattern = pattern.replace("\$","\\\$"); //$ is a Metacharacters in Java regular expression so we have to escape it.
        pattern = pattern.replace("-","\\-");   //- is a Metacharacters in Java regular expression so we have to escape it.
        pattern = pattern.replace("(","\\(");   //( is a Metacharacters in Java regular expression so we have to escape it.
        pattern = pattern.replace(")","\\)");   //) is a Metacharacters in Java regular expression so we have to escape it.
        pattern = pattern.replace("*",".*");    //* in regular expression should be .*
        return pattern;
    }
}
