/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.ibm.urbancode.zos.common.MVSHelper;
import com.ibm.zos.sdsf.core.ISFRequestResults;
import com.ibm.zos.sdsf.core.ISFRequestSettings;
import com.ibm.zos.sdsf.core.ISFRunner;
import com.urbancode.air.AirPluginTool

try{
	final def workDir = new File('.').canonicalFile
	def apTool = new AirPluginTool(this.args[0], this.args[1])
	def props = apTool.getStepProperties();

	final def mvsCommand 		= props['mvsCommand']?.trim();
	final def stopOnFail 		= Boolean.valueOf(props['stopOnFail']?.trim());
	final def failMessage 		= props['failMessage']?.trim();
	final def sdsfJarFile 		= props['sdsfJarFile']?.trim();
	final def sdsfLibraryPath 	= props['sdsfLibraryPath']?.trim();


	if(!sdsfJarFile || sdsfJarFile.length() < 1){
		throw new IllegalArgumentException("SDSF Jar File can not be empty.");
	}
	def File sdsfJar = new File(sdsfJarFile)
	if(!(sdsfJar.exists() && sdsfJar.canRead())){
		throw new IllegalArgumentException("Error reading SDSF Jar File: $sdsfJarFile")
	}

	if(!sdsfLibraryPath || sdsfLibraryPath.length() < 1){
		throw new IllegalArgumentException("SDSF Native Library Path can not be empty.");
	}
	if(!mvsCommand || mvsCommand.length() < 1){
		throw new IllegalArgumentException("MVS Commands can not be empty.");
	}
	def mvsHelper = new MVSHelper()
	mvsHelper.sdsfJarFile = sdsfJarFile
	mvsHelper.sdsfLibraryPath = sdsfLibraryPath

	if(!mvsHelper.verifySDSF()){
		System.exit(1)
	}

	if (failMessage==null) failMessage =""
	def success = true
	def lineCount = 0
	mvsCommand.eachLine { lineCount ++ }
	mvsCommand.eachLine {
		lineCount --
		if(!success && stopOnFail){
			println it
		}else{
			if(it!=null && it.trim().length()>0){
				mvsHelper.runCommand(it)
				def containsFailMessage = false
				if(mvsHelper.returnCode == 0){
					println "==============================="
					mvsHelper.results.getResponseList().each{ message ->
						failMessage.eachLine { fMessage ->
							if(message.contains(fMessage)){
								containsFailMessage=true
								println   "Following line in command response contains fail message : " + fMessage
								println message
								println()
							}
						}
					}
					if(containsFailMessage){
						println "Step failed."
						println()
					}
				}
				if(mvsHelper.returnCode > 0 || containsFailMessage){
					success = false
					if(stopOnFail && lineCount > 0){
						println "Following commands are not executed because Stop On Fail is set to true."
					}
				}
			}
		}
	}
	if(!success){
		System.exit(1)
	}
} catch (Exception e) {
	println "Error executing MVS command: ${e.message}";
	e.printStackTrace();
	System.exit(1);
}

System.exit(0);

