/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZUtil;
import com.ibm.urbancode.zos.dataset.util.DataSetReader;
import com.ibm.urbancode.zos.jes.JESJob;
import com.ibm.urbancode.zos.jes.JMException;
import com.ibm.urbancode.zos.jes.JobUtil;
import com.ibm.urbancode.zos.jes.SystemMessageException;
import com.ibm.urbancode.zos.jes.passticket.PassTicketUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SubmitJob {
    private Properties inputProperties;
    private Properties outputProperties;

    public SubmitJob(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() throws IOException, Exception {
        try {
            String mvsFilename = this.inputProperties.getProperty("mvsFilename").trim();
            String ussFilename = this.inputProperties.getProperty("ussFilename").trim();
            String jclString = this.inputProperties.getProperty("jclString").trim();
            String jobCard = this.inputProperties.getProperty("jobCard").trim();
            String explicitTokens = this.inputProperties.getProperty("explicitTokens").trim();
            String explicitTokensForeachJob = this.inputProperties.getProperty("explicitTokensForeachJob").trim();
            boolean waitForJob = Boolean.valueOf(this.inputProperties.getProperty("waitForJob").trim());
            boolean stopOnFail = Boolean.valueOf(this.inputProperties.getProperty("stopOnFail").trim());
            String timeout = this.inputProperties.getProperty("timeout").trim();
            String showOutput = this.inputProperties.getProperty("showOutput").trim();
            String cutOff = this.inputProperties.getProperty("cutOff").trim();
            String maxRC = this.inputProperties.getProperty("maxRC").trim();
            String hostname = this.inputProperties.getProperty("hostname").trim();
            String userid = this.inputProperties.getProperty("userid").trim();
            String password = this.inputProperties.getProperty("password").trim();
            String port = this.inputProperties.getProperty("port").trim();
            boolean usePassticket = Boolean.valueOf(this.inputProperties.getProperty("usePassticket").trim());
            String irrracfLibraryPath = this.inputProperties.getProperty("irrracfLibraryPath").trim();
            String APPL_ID = "FEKAPPL";
            if (SubmitJob.isNullOrEmpty(hostname)) {
                throw new IllegalArgumentException("Host Name can not be empty.");
            }
            if (SubmitJob.isNullOrEmpty(userid)) {
                throw new IllegalArgumentException("User ID can not be empty.");
            }
            userid = userid.toUpperCase();
            if (SubmitJob.isNullOrEmpty(password)) {
                if (usePassticket) {
                    System.out.println("Password is empty. Using PassTicket authentication.");
                    password = PassTicketUtil.generatePassTicket((String)userid, (String)APPL_ID, (String)irrracfLibraryPath);
                } else {
                    throw new IllegalArgumentException("Password can not be empty.");
                }
            }
            if (SubmitJob.isNullOrEmpty(port)) {
                throw new IllegalArgumentException("Port can not be empty.");
            }
            if (SubmitJob.isNullOrEmpty(explicitTokensForeachJob)) {
                explicitTokensForeachJob = "";
            }
            if (SubmitJob.isNullOrEmpty(explicitTokens)) {
                explicitTokens = "";
            }
            String[] tempList = ("\n" + explicitTokensForeachJob).split("\n//");
            ArrayList<String> explicitTokensForeachJobList = new ArrayList<String>();
            for (String str : tempList) {
                String line = str.trim();
                if (SubmitJob.isNullOrEmpty(line) || line == "//") continue;
                explicitTokensForeachJobList.add(line);
            }
            if (explicitTokensForeachJobList.size() == 0) {
                explicitTokensForeachJobList.add("");
            }
            int jobcount = 0;
            int failcount = 0;
            for (String str : explicitTokensForeachJobList) {
                String mergedRule = explicitTokens + "\n" + str;
                mergedRule = mergedRule.trim();
                JobUtil jobUtil = new JobUtil(hostname, port, userid, password);
                if (waitForJob) {
                    try {
                        int timeoutValue = Integer.valueOf(timeout);
                        jobUtil.setTimeout(timeoutValue);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Time Out isn't a number.");
                    }
                    try {
                        int cutOffValue = Integer.valueOf(cutOff);
                        jobUtil.setCutoff(cutOffValue);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Cut Off isn't a number.");
                    }
                    try {
                        int maxRCValue = Integer.valueOf(maxRC);
                        jobUtil.setMaxReturnCode(maxRCValue);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Max Return Code isn't a number.");
                    }
                    jobUtil.setShowOutput(showOutput);
                }
                TreeMap<String, String> jcls = new TreeMap<String, String>();
                if (!SubmitJob.isNullOrEmpty(mvsFilename)) {
                    DataSetReader dsr = new DataSetReader(mvsFilename);
                    jcls.putAll(dsr.getDataSets());
                } else if (!SubmitJob.isNullOrEmpty(ussFilename)) {
                    jcls.put(ussFilename, this.readUssFile(ussFilename));
                } else if (!SubmitJob.isNullOrEmpty(jclString)) {
                    jcls.put("Step JCL", jclString);
                } else {
                    throw new IllegalArgumentException("At least one JCL input (JCL Dataset, JCL File or JCL) must be specified.");
                }
                if (jcls.size() > 1 && explicitTokensForeachJobList.size() > 1) {
                    System.out.println("Replace Token sets for Each Job must be used with a single JCL.");
                    System.exit(1);
                } else if (jcls.size() > 1) {
                    System.out.println("=================================== Total " + jcls.size() + " jobs to submit ============================================================");
                } else if (explicitTokensForeachJobList.size() > 1) {
                    System.out.println("=================================== Total " + explicitTokensForeachJobList.size() + " jobs to submit ============================================================");
                }
                for (Map.Entry entry : jcls.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    ++jobcount;
                    if (explicitTokensForeachJobList.size() > 1 || jcls.size() > 1) {
                        System.out.println("=================================== Submitting job" + jobcount + " : " + key + " ==================================================================");
                    } else {
                        System.out.println("=================================== Submitting job : " + key + " ==================================================================");
                    }
                    boolean success = this.submitOneJob(jobUtil, key, value, jobCard, mergedRule, waitForJob, this.outputProperties, jobcount);
                    if (!success && stopOnFail) {
                        System.out.println("Step failed because Stop On Fail is turned on and job" + jobcount + " : " + key + " failed.");
                        System.exit(1);
                    }
                    if (success) continue;
                    ++failcount;
                }
            }
            System.out.println(jobcount + " job(s) completed. ");
            this.outputProperties.setProperty("jobCount", Integer.toString(jobcount));
            if (failcount > 0) {
                System.out.println(failcount + " job(s) failed. ");
                System.exit(1);
            }
            if (jobcount == 0) {
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
        catch (Exception e) {
            System.out.println("Error Running Job: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        return 0;
    }

    private boolean submitOneJob(JobUtil jobUtil, String jclname, String jcl, String jobCard, String mergedRule2, boolean waitForJob, Properties outProps, int jobcount2) {
        String updatedContent;
        jobUtil.setJclString(jcl);
        if (!SubmitJob.isNullOrEmpty(mergedRule2)) {
            jobUtil.setJclString(this.replaceJCL(jobUtil.getJclString(), mergedRule2));
        }
        if ((updatedContent = this.checkJobCard(jobUtil.getJclString(), jobCard)) != jobUtil.getJclString()) {
            jobUtil.setJclString(updatedContent);
        }
        String jobid = null;
        try {
            jobid = jobUtil.submitJob();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        outProps.setProperty("JobId" + jobcount2, jobid);
        outProps.setProperty("JobJCL" + jobcount2, jclname);
        outProps.setProperty("JobId", jobid);
        outProps.setProperty("JobJCL", jclname);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            if (jobUtil.isJclError(jobid)) {
                JESJob job = jobUtil.getJob(jobid, true);
                outProps.setProperty("JobReturnCode", job.getReturnCode() == null ? "" : job.getReturnCode());
                outProps.setProperty("JobReturnInfo", job.getReturnInfo() == null ? "" : job.getReturnInfo());
                outProps.setProperty("JobReturnStatus", job.getReturnStatus() == null ? "" : job.getReturnStatus());
                jobUtil.disconnect();
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (waitForJob) {
            boolean success = false;
            try {
                success = jobUtil.waitForJob(jobid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                jobUtil.printLog(jobid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            JESJob job = null;
            try {
                job = jobUtil.getJob(jobid, true);
            }
            catch (JMException e) {
                e.printStackTrace();
            }
            catch (SystemMessageException e) {
                e.printStackTrace();
            }
            outProps.setProperty("JobReturnCode" + jobcount2, job.getReturnCode() == null ? "" : job.getReturnCode());
            outProps.setProperty("JobReturnInfo" + jobcount2, job.getReturnInfo() == null ? "" : job.getReturnInfo());
            outProps.setProperty("JobReturnStatus" + jobcount2, job.getReturnStatus() == null ? "" : job.getReturnStatus());
            outProps.setProperty("JobReturnCode", job.getReturnCode() == null ? "" : job.getReturnCode());
            outProps.setProperty("JobReturnInfo", job.getReturnInfo() == null ? "" : job.getReturnInfo());
            outProps.setProperty("JobReturnStatus", job.getReturnStatus() == null ? "" : job.getReturnStatus());
            jobUtil.disconnect();
            return success;
        }
        return false;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public String replaceJCL(String jcl, String rules) {
        String[] originalLines = jcl.split("\n");
        String targetJcl = jcl;
        BufferedReader reader = new BufferedReader(new StringReader(rules));
        try {
            String line = reader.readLine();
            int noOfOccurences = 0;
            while (line != null) {
                if (line.indexOf("->") > 0) {
                    int index = line.indexOf("->");
                    String propName = line.substring(0, index).trim();
                    String propValue = index < line.length() - 2 ? line.substring(index + 2) : "";
                    noOfOccurences += StringUtils.countMatches((CharSequence)targetJcl, (CharSequence)propName);
                    targetJcl = targetJcl.replace(propName, propValue);
                } else {
                    System.out.println("Found invalid explicit token " + line + " - missing -> separator");
                    System.exit(1);
                }
                line = reader.readLine();
            }
            System.out.println("  [replace] Replaced " + noOfOccurences + " occurrences in 1 files.");
            System.out.println("========================================================================================================================");
            System.out.println("JCL after replacing token.");
            String[] lines = targetJcl.split("\n");
            int i = 1;
            byte[] recBuf = null;
            byte[] oriRecBuf = null;
            boolean contentExceedMaxNum = false;
            ArrayList<String> linesAfterTrancateArr = new ArrayList<String>();
            String whiteSpaceStr = "";
            byte[] whitespaceBytes = null;
            try {
                whiteSpaceStr = new String(" ".getBytes(), ZUtil.getDefaultPlatformEncoding());
                whitespaceBytes = whiteSpaceStr.getBytes(ZUtil.getDefaultPlatformEncoding());
                byte byte4WhiteSpace = whitespaceBytes[0];
                for (String jclline : lines) {
                    String afterTruncate;
                    if (jclline.startsWith("//*")) {
                        linesAfterTrancateArr.add(jclline);
                        ++i;
                        continue;
                    }
                    recBuf = jclline.getBytes(ZUtil.getDefaultPlatformEncoding());
                    int columNum = recBuf.length;
                    oriRecBuf = originalLines[i - 1].getBytes(ZUtil.getDefaultPlatformEncoding());
                    int oriColumNum = oriRecBuf.length;
                    boolean truncFlag = false;
                    if (oriColumNum == 80) {
                        if (columNum < 80) {
                            linesAfterTrancateArr.add(this.createStringAfterFillBlank(oriRecBuf, recBuf, 80, 9, byte4WhiteSpace));
                        } else if (columNum == 80) {
                            linesAfterTrancateArr.add(jclline);
                        } else if (columNum > 80) {
                            afterTruncate = this.createStringAfterTruncateBlank(oriRecBuf, recBuf, 80, 9, byte4WhiteSpace, i, jclline);
                            if (afterTruncate.isEmpty()) {
                                contentExceedMaxNum = true;
                            } else {
                                linesAfterTrancateArr.add(afterTruncate);
                            }
                        }
                    } else if (oriColumNum == 72 && oriRecBuf[71] != byte4WhiteSpace) {
                        if (columNum < 72) {
                            linesAfterTrancateArr.add(this.createStringAfterFillBlank(oriRecBuf, recBuf, 72, 1, byte4WhiteSpace));
                        } else if (columNum == 72) {
                            linesAfterTrancateArr.add(jclline);
                        } else if (columNum > 72) {
                            afterTruncate = this.createStringAfterTruncateBlank(oriRecBuf, recBuf, 72, 1, byte4WhiteSpace, i, jclline);
                            if (afterTruncate.isEmpty()) {
                                contentExceedMaxNum = true;
                            } else {
                                linesAfterTrancateArr.add(afterTruncate);
                            }
                        }
                    } else if (columNum <= 71) {
                        linesAfterTrancateArr.add(jclline);
                    } else if (columNum > 71) {
                        afterTruncate = this.createStringAfterTruncateBlank(oriRecBuf, recBuf, 72, 0, byte4WhiteSpace, i, jclline);
                        if (afterTruncate.isEmpty()) {
                            contentExceedMaxNum = true;
                        } else {
                            linesAfterTrancateArr.add(afterTruncate);
                        }
                    }
                    ++i;
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (contentExceedMaxNum) {
                System.out.println("Job not submitted because the content exceed 71 bytes after replacing tokens.");
                System.exit(1);
            } else {
                targetJcl = String.join((CharSequence)"\n", linesAfterTrancateArr);
            }
            System.out.println("========================================================================================================================");
            System.out.println(targetJcl);
            return targetJcl;
        }
        catch (IOException e) {
            System.out.println("Program failed with IO Exception " + e);
            return "";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String checkJobCard(String jcl, String jobCard) {
        if (jobCard != null) {
            jobCard = jobCard.trim();
        }
        if (jcl != null && jcl.length() > 0) {
            String[] jclLines = jcl.split("\n");
            String firstLine = jclLines[0];
            String regex = "\\bJOB\\b";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(firstLine);
            if (matcher.find() && firstLine.startsWith("//")) return jcl;
            System.out.println("No JOB statement found in the JCL.");
            if (jobCard != null && jobCard.length() > 0) {
                System.out.println("Adding default JOB statement");
                String[] jobCardLines = jobCard.split("\n");
                String firstLineJobCard = jobCardLines[0];
                Matcher matcher1 = pattern.matcher(firstLineJobCard);
                if (matcher1.find() && firstLineJobCard.startsWith("//")) return jobCard + "\n" + jcl;
                System.out.println("Error: JOB statement must be provided in the first line.");
                System.exit(1);
                return null;
            } else {
                System.out.println("No default JOB statement found");
                System.out.println("Error: JOB statement must be provided in the first line.");
                System.exit(1);
            }
            return null;
        } else {
            System.out.println("Error:JCL content is empty");
            System.exit(1);
        }
        return null;
    }

    String createStringAfterTruncateBlank(byte[] oriByteArr, byte[] replacedByteArr, int TmpByteArrLength, int remainLength, byte blank, int lineNumber, String line) {
        int withoutLineMetaInfoLength;
        byte[] currentBytesAfterTrancate = new byte[TmpByteArrLength];
        Arrays.fill(currentBytesAfterTrancate, blank);
        String createdString = "";
        int tmpStartOfmetaInfoLength = withoutLineMetaInfoLength = replacedByteArr.length - remainLength;
        while (withoutLineMetaInfoLength-- > 0 && replacedByteArr[withoutLineMetaInfoLength] == blank) {
        }
        if (++withoutLineMetaInfoLength > 71) {
            System.out.println("Error: line " + lineNumber + " excceeds 71 bytes.");
            System.out.println(lineNumber + ":" + line);
            return createdString;
        }
        System.arraycopy(replacedByteArr, 0, currentBytesAfterTrancate, 0, withoutLineMetaInfoLength);
        if (remainLength > 0) {
            System.arraycopy(oriByteArr, oriByteArr.length - remainLength, currentBytesAfterTrancate, TmpByteArrLength - remainLength, remainLength);
        }
        try {
            createdString = new String(currentBytesAfterTrancate, ZUtil.getDefaultPlatformEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return createdString;
    }

    public String createStringAfterFillBlank(byte[] oriByteArr, byte[] replacedByteArr, int TmpByteArrLength, int remainLength, byte blank) throws UnsupportedEncodingException {
        byte[] currentBytesAfterTrancate = new byte[TmpByteArrLength];
        Arrays.fill(currentBytesAfterTrancate, blank);
        int withoutLineMetaInfoLength = replacedByteArr.length - remainLength;
        System.arraycopy(replacedByteArr, 0, currentBytesAfterTrancate, 0, withoutLineMetaInfoLength);
        if (remainLength > 0) {
            System.arraycopy(oriByteArr, oriByteArr.length - remainLength, currentBytesAfterTrancate, TmpByteArrLength - remainLength, remainLength);
        }
        return new String(currentBytesAfterTrancate, ZUtil.getDefaultPlatformEncoding());
    }

    public String readUssFile(String name) {
        StringBuilder contentBuilder = new StringBuilder();
        try {
            String sCurrentLine;
            BufferedReader br = new BufferedReader(new FileReader(name));
            while ((sCurrentLine = br.readLine()) != null) {
                contentBuilder.append(sCurrentLine).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contentBuilder.toString();
    }
}

