/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.dataset.util;

import com.ibm.jzos.CatalogSearch;
import com.ibm.jzos.CatalogSearchField;
import com.ibm.jzos.DSCB;
import com.ibm.jzos.Format1DSCB;
import com.ibm.jzos.Format8DSCB;
import com.ibm.jzos.PdsDirectory;
import com.ibm.jzos.ZFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatasetHelper {
    public static Map<String, String> searchNonVsamDataset(String pattern) {
        int max = -1;
        CatalogSearch catSearch = new CatalogSearch(pattern);
        catSearch.setEntryTypes(new String("A"));
        catSearch.addFieldName("ENTNAME");
        catSearch.addFieldName("VOLSER");
        catSearch.search();
        HashMap<String, String> result = new HashMap<String, String>();
        while (catSearch.hasNext()) {
            CatalogSearch.Entry entry = (CatalogSearch.Entry)catSearch.next();
            if (!entry.isDatasetEntry()) continue;
            CatalogSearchField datasetName = entry.getField("ENTNAME");
            CatalogSearchField volume = entry.getField("VOLSER");
            if (max >= 0 && (max <= 0 || result.size() > max)) break;
            result.put(datasetName.getFString().trim(), volume.getFString().trim());
        }
        return result;
    }

    public static List<String> getMembers(String datasetName, String volume, String memberPattern) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        String pattern = DatasetHelper.makeRegexPattren(memberPattern);
        DSCB[] dscb = ZFile.readDSCBChain((String)DatasetHelper.getSlashSlashQuotedDSN(datasetName), (String)volume);
        int fmtDSCB = 0;
        try {
            fmtDSCB = ((Format1DSCB)dscb[0]).getDS1DSORG();
        }
        catch (Exception e1) {
            try {
                fmtDSCB = ((Format8DSCB)dscb[0]).getDS1DSORG();
            }
            catch (Exception e2) {
                System.out.println("DSCB found was neither of Format1DSCB nor Format8DSCB");
                e2.printStackTrace();
                System.exit(1);
            }
        }
        if (fmtDSCB == 16384) {
            result.add(DatasetHelper.getSlashSlashQuotedDSN(datasetName));
        } else if (fmtDSCB == 512 && !DatasetHelper.isNullOrEmpty(memberPattern.trim())) {
            PdsDirectory pds = new PdsDirectory(DatasetHelper.getSlashSlashQuotedDSN(datasetName));
            for (PdsDirectory.MemberInfo member : pds) {
                String memberName = member.getName();
                if (!memberName.matches(pattern)) continue;
                result.add(DatasetHelper.getSlashSlashQuotedDSN(datasetName + "(" + memberName + ")"));
            }
            pds.close();
        }
        return result;
    }

    public static String getSlashSlashQuotedDSN(String datasetName) {
        return ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
    }

    public static String makeRegexPattren(String memberPattern) {
        String pattern = memberPattern;
        pattern = pattern.replace("$", "\\$");
        pattern = pattern.replace("-", "\\-");
        pattern = pattern.replace("(", "\\(");
        pattern = pattern.replace(")", "\\)");
        pattern = pattern.replace("*", ".*");
        return pattern;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }
}

