/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZUtil;
import com.ibm.urbancode.zos.dataset.util.DataSetReader;
import com.ibm.urbancode.zos.jes.JESJob;
import com.ibm.urbancode.zos.jes.JMException;
import com.ibm.urbancode.zos.jes.JobUtil;
import com.ibm.urbancode.zos.jes.SystemMessageException;
import com.ibm.urbancode.zos.jes.passticket.PassTicketUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SubmitJob {
    private Properties inputProperties;
    private Properties outputProperties;
    final String osName = System.getProperty("os.name").toLowerCase(Locale.US);
    boolean isZos = true;
    private String encoding;

    public SubmitJob(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() throws IOException, Exception {
        try {
            String mvsFilename = this.inputProperties.getProperty("mvsFilename").trim();
            String ussFilename = this.inputProperties.getProperty("ussFilename").trim();
            String jclString = this.inputProperties.getProperty("jclString").trim();
            String jobCard = this.inputProperties.getProperty("jobCard").trim();
            String explicitTokens = this.inputProperties.getProperty("explicitTokens").trim();
            String explicitTokensForeachJob = this.inputProperties.getProperty("explicitTokensForeachJob").trim();
            boolean waitForJob = Boolean.valueOf(this.inputProperties.getProperty("waitForJob").trim());
            boolean stopOnFail = Boolean.valueOf(this.inputProperties.getProperty("stopOnFail").trim());
            String timeout = this.inputProperties.getProperty("timeout").trim();
            String showOutput = this.inputProperties.getProperty("showOutput").trim();
            String cutOff = this.inputProperties.getProperty("cutOff").trim();
            String maxRC = this.inputProperties.getProperty("maxRC").trim();
            String hostname = this.inputProperties.getProperty("hostname").trim();
            String userid = this.inputProperties.getProperty("userid").trim();
            String password = this.inputProperties.getProperty("password").trim();
            String port = this.inputProperties.getProperty("port").trim();
            boolean usePassticket = Boolean.valueOf(this.inputProperties.getProperty("usePassticket").trim());
            String irrracfLibraryPath = this.inputProperties.getProperty("irrracfLibraryPath").trim();
            String APPL_ID = "FEKAPPL";
            if (this.osName.equalsIgnoreCase("z/OS")) {
                this.encoding = ZUtil.getDefaultPlatformEncoding();
                this.isZos = true;
            } else {
                this.encoding = System.getProperty("console.encoding", System.getProperty("file.encoding", "UTF-8"));
                this.isZos = false;
            }
            if (SubmitJob.isNullOrEmpty(hostname)) {
                throw new IllegalArgumentException("Host Name can not be empty.");
            }
            if (SubmitJob.isNullOrEmpty(userid)) {
                throw new IllegalArgumentException("User ID can not be empty.");
            }
            userid = userid.toUpperCase();
            if (SubmitJob.isNullOrEmpty(password)) {
                if (!this.isZos) {
                    throw new IllegalArgumentException("Password is mandatory for non-zOS agent.");
                }
                if (usePassticket) {
                    System.out.println("Password is empty. Using PassTicket authentication.");
                    password = PassTicketUtil.generatePassTicket((String)userid, (String)APPL_ID, (String)irrracfLibraryPath);
                } else {
                    throw new IllegalArgumentException("Password can not be empty.");
                }
            }
            if (SubmitJob.isNullOrEmpty(port)) {
                throw new IllegalArgumentException("Port can not be empty.");
            }
            if (SubmitJob.isNullOrEmpty(explicitTokensForeachJob)) {
                explicitTokensForeachJob = "";
            }
            if (SubmitJob.isNullOrEmpty(explicitTokens)) {
                explicitTokens = "";
            }
            if (!this.isZos && !SubmitJob.isNullOrEmpty(mvsFilename)) {
                if (!SubmitJob.isNullOrEmpty(explicitTokensForeachJob) || !SubmitJob.isNullOrEmpty(explicitTokens)) {
                    throw new IllegalArgumentException("Token replacements can't be done from non zOS agents for MVS files");
                }
                if (mvsFilename.contains("*")) {
                    throw new IllegalArgumentException("PDS member patterns can't be used from  non zOS agents for MVS files");
                }
                if (!mvsFilename.contains("(")) {
                    throw new IllegalArgumentException("PDS without member names can't be used from non zOS agents for MVS files");
                }
            }
            String[] tempList = ("\n" + explicitTokensForeachJob).split("\n//");
            ArrayList<String> explicitTokensForeachJobList = new ArrayList<String>();
            for (String str : tempList) {
                String line = str.trim();
                if (SubmitJob.isNullOrEmpty(line) || line == "//") continue;
                explicitTokensForeachJobList.add(line);
            }
            if (explicitTokensForeachJobList.size() == 0) {
                explicitTokensForeachJobList.add("");
            }
            int jobcount = 0;
            int failcount = 0;
            for (String str : explicitTokensForeachJobList) {
                String mergedRule = explicitTokens + "\n" + str;
                mergedRule = mergedRule.trim();
                JobUtil jobUtil = new JobUtil(hostname, port, userid, password);
                if (waitForJob) {
                    try {
                        int timeoutValue = Integer.valueOf(timeout);
                        jobUtil.setTimeout(timeoutValue);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Time Out isn't a number.");
                    }
                    try {
                        int cutOffValue = Integer.valueOf(cutOff);
                        jobUtil.setCutoff(cutOffValue);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Cut Off isn't a number.");
                    }
                    try {
                        int maxRCValue = Integer.valueOf(maxRC);
                        jobUtil.setMaxReturnCode(maxRCValue);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Max Return Code isn't a number.");
                    }
                    jobUtil.setShowOutput(showOutput);
                }
                TreeMap<String, String> jcls = new TreeMap<String, String>();
                if (!SubmitJob.isNullOrEmpty(mvsFilename)) {
                    if (!this.isZos) {
                        jobUtil.setMvsFilename(mvsFilename);
                    } else {
                        DataSetReader dsr = new DataSetReader(mvsFilename);
                        jcls.putAll(dsr.getDataSets());
                    }
                } else if (!SubmitJob.isNullOrEmpty(ussFilename)) {
                    jcls.put(ussFilename, this.readUssFile(ussFilename));
                } else if (!SubmitJob.isNullOrEmpty(jclString)) {
                    jcls.put("Step JCL", jclString);
                } else {
                    throw new IllegalArgumentException("At least one JCL input (JCL Dataset, JCL File or JCL) must be specified.");
                }
                if (jcls.size() > 1 && explicitTokensForeachJobList.size() > 1) {
                    System.out.println("Replace Token sets for Each Job must be used with a single JCL.");
                    return 1;
                }
                if (jcls.size() > 1) {
                    System.out.println("=================================== Total " + jcls.size() + " jobs to submit ============================================================");
                } else if (explicitTokensForeachJobList.size() > 1) {
                    System.out.println("=================================== Total " + explicitTokensForeachJobList.size() + " jobs to submit ============================================================");
                }
                if (!this.isZos && !SubmitJob.isNullOrEmpty(mvsFilename)) {
                    boolean success = this.submitOneASCIIJob(jobUtil, waitForJob);
                    ++jobcount;
                    if (success || !stopOnFail) continue;
                    System.out.println("Step failed because Stop On Fail is turned on and job failed.");
                    return 1;
                }
                for (Map.Entry entry : jcls.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    ++jobcount;
                    if (explicitTokensForeachJobList.size() > 1 || jcls.size() > 1) {
                        System.out.println("=================================== Submitting job" + jobcount + " : " + key + " ==================================================================");
                    } else {
                        System.out.println("=================================== Submitting job : " + key + " ==================================================================");
                    }
                    boolean success = this.submitOneJob(jobUtil, key, value, jobCard, mergedRule, waitForJob, jobcount);
                    if (!success && stopOnFail) {
                        System.out.println("Step failed because Stop On Fail is turned on and job" + jobcount + " : " + key + " failed.");
                        return 1;
                    }
                    if (success) continue;
                    ++failcount;
                }
            }
            System.out.println(jobcount + " job(s) completed. ");
            this.outputProperties.setProperty("jobCount", Integer.toString(jobcount));
            if (failcount > 0) {
                System.out.println(failcount + " job(s) failed. ");
                return 1;
            }
            if (jobcount == 0) {
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            System.out.println("Error Running Job: " + e.getMessage());
            e.printStackTrace();
            return 1;
        }
    }

    private boolean submitOneJob(JobUtil jobUtil, String jclname, String jcl, String jobCard, String mergedRule2, boolean waitForJob, int jobcount2) throws InterruptedException, Exception {
        String updatedContent;
        jobUtil.setJclString(jcl);
        if (!SubmitJob.isNullOrEmpty(mergedRule2)) {
            jobUtil.setJclString(this.replaceJCL(jobUtil.getJclString(), mergedRule2));
        }
        if ((updatedContent = this.checkJobCard(jobUtil.getJclString(), jobCard)) != jobUtil.getJclString()) {
            jobUtil.setJclString(updatedContent);
        }
        String jobid = null;
        jobid = jobUtil.submitJob();
        this.outputProperties.setProperty("JobId" + jobcount2, jobid);
        this.outputProperties.setProperty("JobJCL" + jobcount2, jclname);
        this.outputProperties.setProperty("JobId", jobid);
        this.outputProperties.setProperty("JobJCL", jclname);
        Thread.sleep(500L);
        if (jobUtil.isJclError(jobid)) {
            JESJob job = jobUtil.getJob(jobid, true);
            this.outputProperties.setProperty("JobReturnCode", job.getReturnCode() == null ? "" : job.getReturnCode());
            this.outputProperties.setProperty("JobReturnInfo", job.getReturnInfo() == null ? "" : job.getReturnInfo());
            this.outputProperties.setProperty("JobReturnStatus", job.getReturnStatus() == null ? "" : job.getReturnStatus());
            jobUtil.disconnect();
            return false;
        }
        if (waitForJob) {
            boolean success = false;
            success = jobUtil.waitForJob(jobid);
            jobUtil.printLog(jobid);
            JESJob job = null;
            try {
                job = jobUtil.getJob(jobid, true);
            }
            catch (JMException e) {
                throw e;
            }
            catch (SystemMessageException e) {
                throw e;
            }
            this.outputProperties.setProperty("JobReturnCode" + jobcount2, job.getReturnCode() == null ? "" : job.getReturnCode());
            this.outputProperties.setProperty("JobReturnInfo" + jobcount2, job.getReturnInfo() == null ? "" : job.getReturnInfo());
            this.outputProperties.setProperty("JobReturnStatus" + jobcount2, job.getReturnStatus() == null ? "" : job.getReturnStatus());
            this.outputProperties.setProperty("JobReturnCode", job.getReturnCode() == null ? "" : job.getReturnCode());
            this.outputProperties.setProperty("JobReturnInfo", job.getReturnInfo() == null ? "" : job.getReturnInfo());
            this.outputProperties.setProperty("JobReturnStatus", job.getReturnStatus() == null ? "" : job.getReturnStatus());
            jobUtil.disconnect();
            return success;
        }
        return true;
    }

    private boolean submitOneASCIIJob(JobUtil jobUtil, boolean waitForJob) throws Exception, InterruptedException, JMException, SystemMessageException {
        String jobid = null;
        jobid = jobUtil.submitJob();
        this.outputProperties.setProperty("JobId", jobid);
        Thread.sleep(500L);
        if (jobUtil.isJclError(jobid)) {
            JESJob job = jobUtil.getJob(jobid, true);
            this.outputProperties.setProperty("JobReturnCode", job.getReturnCode() == null ? "" : job.getReturnCode());
            this.outputProperties.setProperty("JobReturnInfo", job.getReturnInfo() == null ? "" : job.getReturnInfo());
            this.outputProperties.setProperty("JobReturnStatus", job.getReturnStatus() == null ? "" : job.getReturnStatus());
            jobUtil.disconnect();
            return false;
        }
        if (waitForJob) {
            boolean success = false;
            success = jobUtil.waitForJob(jobid);
            jobUtil.printLog(jobid);
            JESJob job = null;
            try {
                job = jobUtil.getJob(jobid, true);
            }
            catch (JMException e) {
                throw e;
            }
            catch (SystemMessageException e) {
                throw e;
            }
            this.outputProperties.setProperty("JobReturnCode", job.getReturnCode() == null ? "" : job.getReturnCode());
            this.outputProperties.setProperty("JobReturnInfo", job.getReturnInfo() == null ? "" : job.getReturnInfo());
            this.outputProperties.setProperty("JobReturnStatus", job.getReturnStatus() == null ? "" : job.getReturnStatus());
            this.outputProperties.setProperty("JobReturnCode", job.getReturnCode() == null ? "" : job.getReturnCode());
            this.outputProperties.setProperty("JobReturnInfo", job.getReturnInfo() == null ? "" : job.getReturnInfo());
            this.outputProperties.setProperty("JobReturnStatus", job.getReturnStatus() == null ? "" : job.getReturnStatus());
            jobUtil.disconnect();
            return success;
        }
        return true;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public String replaceJCL(String jcl, String rules) throws Exception {
        String[] originalLines = jcl.split("\n");
        String targetJcl = jcl;
        BufferedReader reader = new BufferedReader(new StringReader(rules));
        try {
            String line = reader.readLine();
            int noOfOccurences = 0;
            while (line != null) {
                String propValue;
                String propName;
                if (line.indexOf("->") > 0) {
                    int index = line.indexOf("->");
                    propName = line.substring(0, index).trim();
                    propValue = index < line.length() - 2 ? line.substring(index + 2) : "";
                    noOfOccurences += StringUtils.countMatches((CharSequence)targetJcl, (CharSequence)propName);
                } else {
                    throw new Exception("Found invalid explicit token " + line + " - missing -> separator");
                }
                targetJcl = targetJcl.replace(propName, propValue);
                line = reader.readLine();
            }
            System.out.println("  [replace] Replaced " + noOfOccurences + " occurrences in 1 files.");
            System.out.println("========================================================================================================================");
            System.out.println("JCL after replacing token.");
            String[] lines = targetJcl.split("\n");
            int i = 1;
            byte[] recBuf = null;
            byte[] oriRecBuf = null;
            boolean contentExceedMaxNum = false;
            ArrayList<String> linesAfterTrancateArr = new ArrayList<String>();
            String whiteSpaceStr = "";
            byte[] whitespaceBytes = null;
            whiteSpaceStr = new String(" ".getBytes(), this.encoding);
            whitespaceBytes = whiteSpaceStr.getBytes(this.encoding);
            byte byte4WhiteSpace = whitespaceBytes[0];
            for (String jclline : lines) {
                String afterTruncate;
                if (jclline.startsWith("//*")) {
                    linesAfterTrancateArr.add(jclline);
                    ++i;
                    continue;
                }
                recBuf = jclline.getBytes(this.encoding);
                int columNum = recBuf.length;
                oriRecBuf = originalLines[i - 1].getBytes(this.encoding);
                int oriColumNum = oriRecBuf.length;
                boolean truncFlag = false;
                if (oriColumNum == 80) {
                    if (columNum < 80) {
                        linesAfterTrancateArr.add(this.createStringAfterFillBlank(oriRecBuf, recBuf, 80, 9, byte4WhiteSpace));
                    } else if (columNum == 80) {
                        linesAfterTrancateArr.add(jclline);
                    } else if (columNum > 80) {
                        afterTruncate = this.createStringAfterTruncateBlank(oriRecBuf, recBuf, 80, 9, byte4WhiteSpace, i, jclline);
                        if (afterTruncate.isEmpty()) {
                            contentExceedMaxNum = true;
                        } else {
                            linesAfterTrancateArr.add(afterTruncate);
                        }
                    }
                } else if (oriColumNum == 72 && oriRecBuf[71] != byte4WhiteSpace) {
                    if (columNum < 72) {
                        linesAfterTrancateArr.add(this.createStringAfterFillBlank(oriRecBuf, recBuf, 72, 1, byte4WhiteSpace));
                    } else if (columNum == 72) {
                        linesAfterTrancateArr.add(jclline);
                    } else if (columNum > 72) {
                        afterTruncate = this.createStringAfterTruncateBlank(oriRecBuf, recBuf, 72, 1, byte4WhiteSpace, i, jclline);
                        if (afterTruncate.isEmpty()) {
                            contentExceedMaxNum = true;
                        } else {
                            linesAfterTrancateArr.add(afterTruncate);
                        }
                    }
                } else if (columNum <= 71) {
                    linesAfterTrancateArr.add(jclline);
                } else if (columNum > 71) {
                    afterTruncate = this.createStringAfterTruncateBlank(oriRecBuf, recBuf, 72, 0, byte4WhiteSpace, i, jclline);
                    if (afterTruncate.isEmpty()) {
                        contentExceedMaxNum = true;
                    } else {
                        linesAfterTrancateArr.add(afterTruncate);
                    }
                }
                ++i;
            }
            if (contentExceedMaxNum) {
                throw new Exception("Job not submitted because the content exceed 71 bytes after replacing tokens.");
            }
            targetJcl = this.getStringJoin("\n", linesAfterTrancateArr);
            System.out.println("========================================================================================================================");
            System.out.println(targetJcl);
            return targetJcl;
        }
        catch (IOException e) {
            System.out.println("Program failed with IO Exception " + e);
            return "";
        }
    }

    public String getStringJoin(String strDelimiter, ArrayList<String> strArray) {
        StringBuilder strBuilder = new StringBuilder();
        int lastIndex = strArray.size() - 1;
        for (int counter = 0; counter < lastIndex; ++counter) {
            strBuilder.append(strArray.get(counter)).append(strDelimiter);
        }
        strBuilder.append(strArray.get(lastIndex));
        return strBuilder.toString();
    }

    public String checkJobCard(String jcl, String jobCard) throws Exception {
        if (jobCard != null) {
            jobCard = jobCard.trim();
        }
        if (jcl != null && jcl.length() > 0) {
            String[] jclLines = jcl.split("\n");
            String firstLine = jclLines[0];
            String regex = "\\bJOB\\b";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(firstLine);
            if (!matcher.find() || !firstLine.startsWith("//")) {
                System.out.println("No JOB statement found in the JCL.");
                if (jobCard != null && jobCard.length() > 0) {
                    System.out.println("Adding default JOB statement");
                    String[] jobCardLines = jobCard.split("\n");
                    String firstLineJobCard = jobCardLines[0];
                    Matcher matcher1 = pattern.matcher(firstLineJobCard);
                    if (!matcher1.find() || !firstLineJobCard.startsWith("//")) {
                        throw new Exception("JOB statement must be provided in the first line.");
                    }
                    return jobCard + "\n" + jcl;
                }
                System.out.println("No default JOB statement found");
                throw new Exception("JOB statement must be provided in the first line.");
            }
            return jcl;
        }
        throw new Exception("JCL content is empty");
    }

    String createStringAfterTruncateBlank(byte[] oriByteArr, byte[] replacedByteArr, int TmpByteArrLength, int remainLength, byte blank, int lineNumber, String line) throws UnsupportedEncodingException {
        int withoutLineMetaInfoLength;
        byte[] currentBytesAfterTrancate = new byte[TmpByteArrLength];
        Arrays.fill(currentBytesAfterTrancate, blank);
        String createdString = "";
        int tmpStartOfmetaInfoLength = withoutLineMetaInfoLength = replacedByteArr.length - remainLength;
        while (withoutLineMetaInfoLength-- > 0 && replacedByteArr[withoutLineMetaInfoLength] == blank) {
        }
        if (++withoutLineMetaInfoLength > 71) {
            System.out.println("Error: line " + lineNumber + " exceeds 71 bytes.");
            System.out.println(lineNumber + ":" + line);
            return createdString;
        }
        System.arraycopy(replacedByteArr, 0, currentBytesAfterTrancate, 0, withoutLineMetaInfoLength);
        if (remainLength > 0) {
            System.arraycopy(oriByteArr, oriByteArr.length - remainLength, currentBytesAfterTrancate, TmpByteArrLength - remainLength, remainLength);
        }
        createdString = new String(currentBytesAfterTrancate, this.encoding);
        return createdString;
    }

    public String createStringAfterFillBlank(byte[] oriByteArr, byte[] replacedByteArr, int TmpByteArrLength, int remainLength, byte blank) throws UnsupportedEncodingException {
        byte[] currentBytesAfterTrancate = new byte[TmpByteArrLength];
        Arrays.fill(currentBytesAfterTrancate, blank);
        int withoutLineMetaInfoLength = replacedByteArr.length - remainLength;
        System.arraycopy(replacedByteArr, 0, currentBytesAfterTrancate, 0, withoutLineMetaInfoLength);
        if (remainLength > 0) {
            System.arraycopy(oriByteArr, oriByteArr.length - remainLength, currentBytesAfterTrancate, TmpByteArrLength - remainLength, remainLength);
        }
        return new String(currentBytesAfterTrancate, this.encoding);
    }

    public String readUssFile(String name) throws IOException {
        String sCurrentLine;
        StringBuilder contentBuilder = new StringBuilder();
        BufferedReader br = new BufferedReader(new FileReader(name));
        while ((sCurrentLine = br.readLine()) != null) {
            contentBuilder.append(sCurrentLine).append("\n");
        }
        return contentBuilder.toString();
    }
}

