/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.jes;

import com.ibm.urbancode.zos.jes.Base64;
import com.ibm.urbancode.zos.jes.JMDataInputStream;
import com.ibm.urbancode.zos.jes.JMException;
import com.ibm.urbancode.zos.jes.JMPrintStream;
import com.ibm.urbancode.zos.jes.Logger;
import com.ibm.urbancode.zos.jes.SystemMessageException;
import com.ibm.urbancode.zos.jes.utils.IJESMinerConstants;
import com.ibm.urbancode.zos.jes.utils.JmonProtocol;
import com.ibm.urbancode.zos.jes.zOSJESResources;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.osgi.util.NLS;

public class JMConnection
implements IJESMinerConstants {
    public static final String copyright = "";
    protected static final JmonProtocol clientProtocolLevel = new JmonProtocol("01", "08");
    protected JmonProtocol negotiatedProtocol = null;
    protected String jmonVersion = null;
    protected String JESName = null;
    protected JMDataInputStream sin;
    protected JMPrintStream sout;
    protected Socket socket = null;
    static InetAddress goodInetAddress = null;
    public boolean flag = true;
    public String output = null;
    protected StringBuffer buf = null;
    protected int cutoff;
    protected String savedHost = null;
    protected String savedPort = null;
    protected String savedUserid = null;
    private String savedPassword = null;
    private String savedHostCodepage = null;
    private String savedLocalCodepage = null;

    public JMConnection() {
        Logger.getDefault().writeDebug("JMConnection constructor called.");
    }

    public void setCutoff(int maxlines) {
        this.cutoff = maxlines;
    }

    public boolean connect(String host, String port, String userid, String password) throws SystemMessageException {
        Logger.getDefault().writeDebug(String.format("JMConnection direct connecting %s:%s (%s)", host, port, this.hashCode()));
        int port_number = 6715;
        String mesg = copyright;
        host = host.toUpperCase();
        try {
            int portIn;
            port_number = portIn = Integer.parseInt(port);
            try {
                this.socket = new Socket(host, port_number);
            }
            catch (IOException e2) {
                String pmsg = NLS.bind(zOSJESResources.MSG_CONNECT_FAILED, host, String.valueOf(port_number));
                String pmsgDetails = NLS.bind(zOSJESResources.MSG_CONNECT_FAILED_DETAILS, e2.getMessage());
                SystemMessageException msg = new SystemMessageException("JESJ10019", "error", pmsg, pmsgDetails);
                throw msg;
            }
            this.sin = new JMDataInputStream(this.socket.getInputStream());
            this.sout = new JMPrintStream(this.socket.getOutputStream());
            this.sout.println(clientProtocolLevel.getConnectCommand());
            String getinfo = this.sin.readLine();
            if (getinfo == null) {
                String pmsg = NLS.bind(zOSJESResources.MSG_CONNECT_FAILED, host, String.valueOf(port_number));
                String pmsgDetails = NLS.bind(zOSJESResources.MSG_CONNECT_FAILED_DETAILS, "Null acknowledgment");
                SystemMessageException msg = new SystemMessageException("JESJ10019", "error", pmsg, pmsgDetails);
                throw msg;
            }
            Logger.getDefault().writeDebug(getinfo);
            this.negotiatedProtocol = JmonProtocol.scanAck(getinfo);
            if (this.negotiatedProtocol == null) {
                String pmsg = NLS.bind(zOSJESResources.MSG_CONNECT_FAILED, host, String.valueOf(port_number));
                String pmsgDetails = NLS.bind(zOSJESResources.MSG_CONNECT_FAILED_DETAILS, "Acknowledgement not received");
                SystemMessageException msg = new SystemMessageException("JESJ10019", "error", pmsg, pmsgDetails);
                throw msg;
            }
            if (clientProtocolLevel.isEarlierThan(this.negotiatedProtocol)) {
                String pmsg = NLS.bind(zOSJESResources.MSG_PROTOCOL_UNSUPPORTED, this.negotiatedProtocol);
                String pmsgDetails = zOSJESResources.MSG_PROTOCOL_UNSUPPORTED;
                SystemMessageException msg = new SystemMessageException("JESJ10021", "error", pmsg, pmsgDetails);
                throw msg;
            }
            String connectReply = getinfo;
            JmonProtocol v104 = new JmonProtocol("0104");
            if (v104.isLaterThan(this.negotiatedProtocol)) {
                userid = userid.toUpperCase();
                password = password.toUpperCase();
            }
            this.sout.println("HELLO " + userid + " " + Base64.basicEncoding(password));
            getinfo = this.sin.readLine();
            if (getinfo == null) {
                String pmsg = NLS.bind(zOSJESResources.MSG_CONNECT_FAILED, host, String.valueOf(port_number));
                String pmsgDetails = NLS.bind(zOSJESResources.MSG_CONNECT_FAILED_DETAILS, zOSJESResources.JESException_ConnectionClosed);
                SystemMessageException msg = new SystemMessageException("JESJ10019", "error", pmsg, pmsgDetails);
                throw msg;
            }
            while (getinfo.charAt(3) == '-') {
                mesg = mesg + getinfo;
                getinfo = this.sin.readLine();
            }
            if ((mesg = mesg + getinfo).substring(0, 3).compareTo("102") == 0) {
                StringTokenizer st = new StringTokenizer(mesg);
                if (st.hasMoreTokens()) {
                    String tokenValue = st.nextToken();
                    tokenValue = st.nextToken();
                    if (tokenValue.compareTo("Version") == 0) {
                        this.jmonVersion = tokenValue = st.nextToken();
                        this.JESName = tokenValue = st.nextToken();
                    } else {
                        this.jmonVersion = "1.0.0";
                        this.JESName = "JES2";
                    }
                }
                this.savedHost = host;
                this.savedPort = port;
                this.savedUserid = userid;
                this.savedPassword = password;
                if (this.savedHostCodepage != null && this.savedLocalCodepage != null) {
                    try {
                        this.setCodePage(this.savedLocalCodepage, this.savedHostCodepage);
                    }
                    catch (JMException e) {
                        String pmsg = NLS.bind(zOSJESResources.MSG_CONNECT_FAILED, host, String.valueOf(port_number));
                        String pmsgDetails = NLS.bind(zOSJESResources.MSG_CONNECT_FAILED_DETAILS, e.getLocalizedMessage());
                        SystemMessageException msg = new SystemMessageException("JESJ10019", "error", pmsg, pmsgDetails);
                        throw msg;
                    }
                }
                Logger.getDefault().writeLog(String.format("JMConnection direct connected %s (%s) %s", host, this.hashCode(), connectReply));
                return true;
            }
            String pmsg = NLS.bind(zOSJESResources.MSG_CONNECT_FAILED, host, String.valueOf(port_number));
            String pmsgDetails = NLS.bind(zOSJESResources.MSG_CONNECT_FAILED_DETAILS, mesg);
            SystemMessageException msg = new SystemMessageException("JESJ10019", "error", pmsg, pmsgDetails);
            throw msg;
        }
        catch (IOException e) {
            String pmsg = NLS.bind(zOSJESResources.MSG_CONNECT_FAILED, host, String.valueOf(port_number));
            String pmsgDetails = NLS.bind(zOSJESResources.MSG_CONNECT_FAILED_DETAILS, e.getMessage());
            SystemMessageException msg = new SystemMessageException("JESJ10019", "error", pmsg, pmsgDetails);
            throw msg;
        }
    }

    public String setCodePage(String localCp, String hostCp) throws JMException {
        String mesg = copyright;
        String sendinfo = copyright;
        int done = 0;
        sendinfo = "SETCODEPAGE " + localCp + " " + hostCp;
        while (done < 2) {
            try {
                this.aboutToSendCommand();
                this.sout.println(sendinfo);
                String getinfo = this.sin.readLine();
                if (getinfo == null) {
                    if (++done < 2) {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                    }
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                while (getinfo.charAt(3) == '-') {
                    mesg = mesg + getinfo + "\n";
                    getinfo = this.sin.readLine();
                }
                if ((mesg = mesg + getinfo).substring(0, 3).compareTo("171") == 0) {
                    this.savedLocalCodepage = localCp;
                    this.savedHostCodepage = hostCp;
                    mesg = mesg.substring(4, mesg.length());
                    return mesg;
                }
                if (mesg.substring(0, 3).compareTo("134") == 0) {
                    mesg = copyright;
                    continue;
                }
                if (mesg.substring(0, 3).compareTo("105") == 0) {
                    mesg = copyright;
                    continue;
                }
                throw new JMException(mesg.substring(4, mesg.length()));
            }
            catch (IOException e) {
                if (e instanceof SocketException && ++done < 2) {
                    try {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(e.getMessage());
                    }
                    catch (SystemMessageException systemMessageException) {
                        continue;
                    }
                }
                throw new JMException(e.getMessage());
            }
            catch (SystemMessageException smsg) {
                ++done;
            }
        }
        return mesg;
    }

    public String cancel(String jobid) throws JMException {
        String sendinfo = new String(copyright);
        String mesg = new String(copyright);
        int done = 0;
        sendinfo = "CANCEL " + jobid;
        while (done < 2) {
            try {
                this.aboutToSendCommand();
                this.sout.println(sendinfo);
                String getinfo = this.sin.readLine();
                if (getinfo == null) {
                    if (++done < 2) {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                    }
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                while (getinfo.charAt(3) == '-') {
                    mesg = mesg + getinfo + "\n";
                    getinfo = this.sin.readLine();
                }
                if ((mesg = mesg + getinfo).substring(0, 3).compareTo("117") == 0) {
                    mesg = mesg.substring(4, mesg.length());
                    return mesg;
                }
                if (mesg.substring(0, 3).compareTo("134") == 0) {
                    mesg = copyright;
                    continue;
                }
                if (mesg.substring(0, 3).compareTo("105") == 0) {
                    mesg = copyright;
                    continue;
                }
                throw new JMException(mesg.substring(4, mesg.length()));
            }
            catch (IOException e) {
                if (e instanceof SocketException && ++done < 2) {
                    try {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(e.getMessage());
                    }
                    catch (SystemMessageException systemMessageException) {
                        continue;
                    }
                }
                throw new JMException(e.getMessage());
            }
            catch (SystemMessageException smsg) {
                ++done;
            }
        }
        return mesg;
    }

    public InputStream getOutputSDS(String jobName, String dsn, int cutOff) throws Exception {
        StringBuffer buffer = new StringBuffer();
        String sendinfo = new String(copyright);
        int done = 0;
        int count = 0;
        sendinfo = "GETSDSC " + jobName + " " + dsn + " " + cutOff;
        while (done < 2) {
            try {
                this.aboutToSendCommand();
                this.sout.println(sendinfo);
                String getinfo = this.sin.readLine();
                if (getinfo == null) {
                    if (++done < 2) {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                    }
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                if (getinfo.startsWith("132")) {
                    throw new JMException(getinfo.substring(4, getinfo.length()));
                }
                if (getinfo.startsWith("133- message is")) {
                    return null;
                }
                if (getinfo.startsWith("133")) {
                    while (getinfo.startsWith("133") && count <= cutOff) {
                        buffer.append(getinfo.substring(5));
                        buffer.append("\n");
                        ++count;
                        getinfo = this.sin.readLine();
                    }
                    return new ByteArrayInputStream(buffer.toString().getBytes());
                }
                if (getinfo.indexOf("167 End of SYSOUT DATA") <= -1) {
                    if (getinfo.startsWith("134") || getinfo.startsWith("105")) continue;
                    throw new JMException(getinfo.substring(4, getinfo.length()));
                }
                break;
            }
            catch (IOException e) {
                if (e instanceof SocketException && ++done < 2) {
                    if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                    throw new JMException(e.getMessage());
                }
                throw new JMException(e.getMessage());
            }
        }
        return new ByteArrayInputStream(buffer.toString().getBytes("UTF-8"));
    }

    public String hold(String jobid) throws JMException {
        String sendinfo = new String(copyright);
        String mesg = new String(copyright);
        int done = 0;
        sendinfo = "HOLD " + jobid;
        while (done < 2) {
            try {
                this.aboutToSendCommand();
                this.sout.println(sendinfo);
                String getinfo = this.sin.readLine();
                if (getinfo == null) {
                    if (++done < 2) {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                    }
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                while (getinfo.charAt(3) == '-') {
                    mesg = mesg + getinfo + "\n";
                    getinfo = this.sin.readLine();
                }
                if ((mesg = mesg + getinfo).substring(0, 3).compareTo("165") == 0) {
                    mesg = mesg.substring(4, mesg.length());
                    return mesg;
                }
                if (mesg.substring(0, 3).compareTo("134") == 0) {
                    mesg = copyright;
                    continue;
                }
                if (mesg.substring(0, 3).compareTo("105") == 0) {
                    mesg = copyright;
                    continue;
                }
                throw new JMException(mesg.substring(4, mesg.length()));
            }
            catch (IOException e) {
                if (e instanceof SocketException && ++done < 2) {
                    try {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(e.getMessage());
                    }
                    catch (SystemMessageException systemMessageException) {
                        continue;
                    }
                }
                throw new JMException(e.getMessage());
            }
            catch (SystemMessageException smsg) {
                ++done;
            }
        }
        return mesg;
    }

    public String kill(String sessionid) throws JMException {
        String sendinfo = new String(copyright);
        String mesg = new String(copyright);
        sendinfo = "KILL " + sessionid;
        try {
            this.aboutToSendCommand();
            this.sout.println(sendinfo);
            String getinfo = this.sin.readLine();
            if (getinfo == null) {
                throw new JMException(zOSJESResources.JESException_ConnectionClosed);
            }
            if (getinfo.substring(0, 3).compareTo("104") == 0) {
                while (getinfo.charAt(3) == '-') {
                    mesg = mesg + getinfo.substring(4, getinfo.length()) + "\n";
                    getinfo = this.sin.readLine();
                }
            } else {
                throw new JMException(getinfo.substring(4, getinfo.length()));
            }
            mesg = mesg + getinfo.substring(4, getinfo.length());
        }
        catch (IOException e) {
            throw new JMException(e.getMessage());
        }
        catch (SystemMessageException e) {
            throw new JMException(e.getMessage());
        }
        return mesg;
    }

    public String purge(String jobid) throws JMException {
        String sendinfo = new String(copyright);
        String mesg = new String(copyright);
        int done = 0;
        sendinfo = "PURGE " + jobid;
        while (done < 2) {
            try {
                this.aboutToSendCommand();
                this.sout.println(sendinfo);
                String getinfo = this.sin.readLine();
                if (getinfo == null) {
                    if (++done < 2) {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                    }
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                while (getinfo.charAt(3) == '-') {
                    mesg = mesg + getinfo + "\n";
                    getinfo = this.sin.readLine();
                }
                if ((mesg = mesg + getinfo).substring(0, 3).compareTo("119") == 0) {
                    mesg = mesg.substring(4, mesg.length());
                    return mesg;
                }
                if (mesg.substring(0, 3).compareTo("134") == 0) {
                    mesg = copyright;
                    continue;
                }
                if (mesg.substring(0, 3).compareTo("105") == 0) {
                    mesg = copyright;
                    continue;
                }
                throw new JMException(mesg.substring(4, mesg.length()));
            }
            catch (IOException e) {
                if (e instanceof SocketException && ++done < 2) {
                    try {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(e.getMessage());
                    }
                    catch (SystemMessageException systemMessageException) {
                        continue;
                    }
                }
                throw new JMException(e.getMessage());
            }
            catch (SystemMessageException smsg) {
                ++done;
            }
        }
        return mesg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String disconnect() throws JMException {
        String msgQuit = "105 Connection QUIT";
        String msgClosingSocket = "105 Closing connection socket";
        String logClosingSocket = "Disconnect: Could not send QUIT. Closing socket.";
        String logClosingUnconfirmed = "Disconnect: QUIT sent. No reply. Closing socket.";
        String logClosingConfirmed = "Disconnect: QUIT sent. Reply confirmed. Closing socket.";
        String sendinfo = "QUIT";
        String mesg = copyright;
        Logger.getDefault().writeDebug(String.format("JMConnection direct disconnect %s (%s)", this.savedHost, this.hashCode()));
        try {
            if (this.sin != null && this.sin.hasInput()) {
                Logger.getDefault().writeLog("Disconnect: Could not send QUIT. Closing socket.");
                String string = "105 Closing connection socket";
                return string;
            }
            this.sout.println(sendinfo);
            String getinfo = this.sin.readLine();
            if (getinfo == null) {
                Logger.getDefault().writeLog("Disconnect: QUIT sent. No reply. Closing socket.");
                String string = "105 Connection QUIT";
                return string;
            }
            while (getinfo.charAt(3) == '-') {
                mesg = mesg + getinfo;
                getinfo = this.sin.readLine();
            }
            if ((mesg = mesg + getinfo).substring(0, 3).compareTo("105") == 0) {
                mesg = "Disconnect: QUIT sent. Reply confirmed. Closing socket.";
            }
        }
        catch (IOException e) {
            Logger.getDefault().writeLog("Disconnect: Could not send QUIT. Closing socket.");
            String string = "105 Closing connection socket";
            return string;
        }
        finally {
            this.closeSocketConnection();
        }
        return mesg;
    }

    public String release(String jobid) throws JMException {
        String sendinfo = new String(copyright);
        String mesg = new String(copyright);
        int done = 0;
        sendinfo = "RELE " + jobid;
        while (done < 2) {
            try {
                this.aboutToSendCommand();
                this.sout.println(sendinfo);
                String getinfo = this.sin.readLine();
                if (getinfo == null) {
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                while (getinfo.charAt(3) == '-') {
                    mesg = mesg + getinfo + "\n";
                    getinfo = this.sin.readLine();
                }
                if ((mesg = mesg + getinfo).substring(0, 3).compareTo("118") == 0) {
                    mesg = mesg.substring(4, mesg.length());
                    return mesg;
                }
                if (mesg.substring(0, 3).compareTo("134") == 0) {
                    mesg = copyright;
                    continue;
                }
                if (mesg.substring(0, 3).compareTo("105") == 0) {
                    mesg = copyright;
                    continue;
                }
                throw new JMException(mesg.substring(4, mesg.length()));
            }
            catch (IOException e) {
                if (e instanceof SocketException && ++done < 2) {
                    try {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(e.getMessage());
                    }
                    catch (SystemMessageException systemMessageException) {
                        continue;
                    }
                }
                throw new JMException(e.getMessage());
            }
            catch (SystemMessageException e) {
                throw new JMException(e.getMessage());
            }
        }
        return mesg;
    }

    public String search(String prefix, String owner, String status, String clas, String outputclass) throws JMException {
        String mesg;
        block6: {
            String sendinfo = new String(copyright);
            mesg = new String(copyright);
            sendinfo = "SEARCH " + prefix + " " + owner + " " + status + " " + clas + " " + outputclass;
            try {
                this.aboutToSendCommand();
                this.sout.println(sendinfo);
                String getinfo = this.sin.readLine();
                if (getinfo == null) {
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                if (getinfo.substring(0, 3).compareTo("160") == 0) {
                    while (getinfo.charAt(3) == '-') {
                        mesg = mesg + getinfo.substring(4, getinfo.length()) + "\n";
                        getinfo = this.sin.readLine();
                    }
                    break block6;
                }
                throw new JMException(getinfo);
            }
            catch (IOException iOException) {
            }
            catch (SystemMessageException systemMessageException) {
                // empty catch block
            }
        }
        return mesg;
    }

    public ArrayList searchPlus(String prefix, String owner, String status, String clas, String outputclass, String jobid) throws JMException {
        String sendinfo = new String(copyright);
        ArrayList<String> lines = new ArrayList<String>();
        int done = 0;
        if (owner.equals("&USERID") || owner.trim().equals(copyright)) {
            owner = this.savedUserid;
        }
        sendinfo = "SEARCHPLUS " + prefix.toUpperCase() + " " + owner.toUpperCase() + " " + status.toUpperCase() + " " + clas.toUpperCase() + " " + outputclass.toUpperCase();
        JmonProtocol protocol = this.getProtocolLevel();
        if (protocol != null && !protocol.isEarlierThan(IJESMinerConstants.retrieveJobSupportedProtocol)) {
            sendinfo = sendinfo + " " + jobid.toUpperCase();
        }
        if (protocol != null && !protocol.isEarlierThan(IJESMinerConstants.searchplusOptionsSupported)) {
            sendinfo = sendinfo + " " + "-N";
        }
        while (done < 2) {
            try {
                this.aboutToSendCommand();
                this.sout.println(sendinfo);
                String getinfo = this.sin.readLine();
                if (getinfo == null) {
                    if (++done < 2) {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                    }
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                Logger.getDefault().writeLog(getinfo);
                if (getinfo.startsWith("134") || getinfo.startsWith("105")) continue;
                if (getinfo.startsWith("162")) {
                    return lines;
                }
                if (!getinfo.startsWith("160-")) {
                    getinfo = this.sin.readLine();
                    throw new JMException(getinfo);
                }
                while (getinfo.startsWith("160") || getinfo.startsWith("155") || getinfo.startsWith("145")) {
                    lines.add(getinfo);
                    if (getinfo.startsWith("160 ")) break;
                    getinfo = this.sin.readLine();
                }
                return lines;
            }
            catch (IOException e) {
                if (e instanceof SocketException && ++done < 2) {
                    try {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(e.getMessage());
                    }
                    catch (SystemMessageException systemMessageException) {
                        continue;
                    }
                }
                throw new JMException(e.getMessage());
            }
            catch (SystemMessageException smsg) {
                ++done;
            }
        }
        return lines;
    }

    public ArrayList getStatus(String jobid) throws JMException {
        int done = 0;
        ArrayList<String> lines = new ArrayList<String>();
        while (done < 2) {
            try {
                this.aboutToSendCommand();
                this.sout.println("STAT " + jobid);
                String getinfo = this.sin.readLine();
                if (getinfo == null) {
                    if (++done < 2) {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                    }
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                if (getinfo.startsWith("134") || getinfo.startsWith("105")) continue;
                if (getinfo.startsWith("123")) {
                    lines.add(getinfo);
                    return lines;
                }
                while (getinfo.startsWith("155-") || getinfo.startsWith("145-")) {
                    lines.add(getinfo);
                    getinfo = this.sin.readLine();
                }
                if (getinfo.startsWith("155 End")) {
                    return lines;
                }
                return null;
            }
            catch (IOException e) {
                if (e instanceof SocketException && ++done < 2) {
                    try {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(e.getMessage());
                    }
                    catch (SystemMessageException systemMessageException) {
                        continue;
                    }
                }
                throw new JMException(e.getMessage());
            }
            catch (SystemMessageException smsg) {
                ++done;
            }
        }
        return null;
    }

    public String submitDs(String MVSJCLFileName) throws JMException {
        String mesg = new String(copyright);
        String sendinfo = new String(copyright);
        int done = 0;
        sendinfo = "SUBMITDS " + MVSJCLFileName;
        while (done < 2) {
            try {
                this.aboutToSendCommand();
                this.sout.println(sendinfo);
                mesg = this.sin.readLine();
                if (mesg == null) {
                    if (++done < 2) {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                    }
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                if (mesg.substring(0, 3).compareTo("115") == 0) {
                    mesg = mesg.substring(4);
                    return mesg;
                }
                if (mesg.startsWith("134") || mesg.startsWith("105")) {
                    mesg = copyright;
                    continue;
                }
                throw new JMException(mesg.substring(4));
            }
            catch (IOException e) {
                if (e instanceof SocketException && ++done < 2) {
                    try {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(e.getMessage());
                    }
                    catch (SystemMessageException systemMessageException) {
                        continue;
                    }
                }
                throw new JMException(e.getMessage());
            }
            catch (SystemMessageException smsg) {
                ++done;
            }
        }
        return mesg;
    }

    public String submit(File JCL) throws JMException {
        FileReader f_reader;
        int done = 0;
        try {
            f_reader = new FileReader(JCL);
        }
        catch (FileNotFoundException e) {
            throw new JMException(e.getMessage());
        }
        BufferedReader f = new BufferedReader(f_reader);
        String sendinfo = new String(copyright);
        String mesg = new String(copyright);
        String tmp = new String(copyright);
        sendinfo = "SUBMIT";
        while (done < 2) {
            try {
                this.aboutToSendCommand();
                this.sout.println(sendinfo);
                String getinfo = this.sin.readLine();
                if (getinfo == null) {
                    if (++done < 2) {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                    }
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                while (getinfo.charAt(3) == '-') {
                    mesg = mesg + getinfo + "\n";
                    getinfo = this.sin.readLine();
                }
                if ((mesg = mesg + getinfo).startsWith("134") || mesg.startsWith("105")) {
                    mesg = copyright;
                    continue;
                }
                if (mesg.substring(0, 3).compareTo("116") != 0) {
                    throw new JMException(mesg.substring(4, mesg.length()));
                }
                mesg = "Allow for file to transfer!!";
                tmp = f.readLine();
                while (tmp != null) {
                    this.sout.println(tmp);
                    tmp = f.readLine();
                }
                this.sout.println("/*EOF");
                getinfo = this.sin.readLine();
                mesg = copyright;
                if (getinfo == null) {
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                while (getinfo.charAt(3) == '-') {
                    mesg = mesg + getinfo + "\n";
                    getinfo = this.sin.readLine();
                }
                if ((mesg = mesg + getinfo).substring(0, 3).compareTo("115") != 0) {
                    throw new JMException(mesg.substring(4, mesg.length()));
                }
                mesg = mesg.substring(4, mesg.length());
                f.close();
                return mesg;
            }
            catch (IOException e) {
                if (e instanceof SocketException && ++done < 2) {
                    try {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(e.getMessage());
                    }
                    catch (SystemMessageException systemMessageException) {
                        continue;
                    }
                }
                throw new JMException(e.getMessage());
            }
            catch (SystemMessageException smsg) {
                ++done;
            }
        }
        return mesg;
    }

    public String submit(String buffer) throws JMException {
        int done = 0;
        StringReader f_reader = new StringReader(buffer);
        BufferedReader f = new BufferedReader(f_reader);
        String sendinfo = new String(copyright);
        String mesg = new String(copyright);
        String tmp = new String(copyright);
        sendinfo = "SUBMIT";
        while (done < 2) {
            try {
                this.aboutToSendCommand();
                this.sout.println(sendinfo);
                String getinfo = this.sin.readLine();
                if (getinfo == null || getinfo.equals("null")) {
                    if (++done < 2) {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                    }
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                while (getinfo.charAt(3) == '-') {
                    mesg = mesg + getinfo + "\n";
                    getinfo = this.sin.readLine();
                }
                if ((mesg = mesg + getinfo).startsWith("134") || mesg.startsWith("105")) {
                    mesg = copyright;
                    continue;
                }
                if (mesg.substring(0, 3).compareTo("116") != 0) {
                    throw new JMException(mesg.substring(4, mesg.length()));
                }
                mesg = "Allow for file to transfer!!";
                tmp = f.readLine();
                while (tmp != null) {
                    this.sout.println(tmp);
                    tmp = f.readLine();
                }
                this.sout.println("/*EOF");
                getinfo = this.sin.readLine();
                mesg = copyright;
                if (getinfo == null || getinfo.equals("null")) {
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                while (getinfo.charAt(3) == '-') {
                    mesg = mesg + getinfo + "\n";
                    getinfo = this.sin.readLine();
                }
                if ((mesg = mesg + getinfo).substring(0, 3).compareTo("115") != 0) {
                    throw new JMException(mesg.substring(4, mesg.length()));
                }
                mesg = mesg.substring(4, mesg.length());
                f.close();
                return mesg;
            }
            catch (IOException e) {
                if (e instanceof SocketException && ++done < 2) {
                    try {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(e.getMessage());
                    }
                    catch (SystemMessageException smsg) {
                        if (done <= 1) continue;
                        throw new JMException(smsg.getMessage());
                    }
                }
                throw new JMException(e.getMessage());
            }
            catch (SystemMessageException smsg) {
                if (++done <= 1) continue;
                throw new JMException(smsg.getMessage());
            }
        }
        return mesg;
    }

    public ArrayList sysout(String jobid) throws JMException {
        int done = 0;
        ArrayList<String> lines = new ArrayList<String>();
        while (done < 2) {
            try {
                this.aboutToSendCommand();
                this.sout.println("SYSOUT " + jobid);
                String getinfo = this.sin.readLine();
                if (getinfo == null) {
                    if (++done < 2) {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                    }
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                if (getinfo.startsWith("134") || getinfo.startsWith("105")) continue;
                while (getinfo.startsWith("145-")) {
                    lines.add(getinfo);
                    getinfo = this.sin.readLine();
                }
                if (getinfo.startsWith("145 End")) {
                    return lines;
                }
                throw new JMException(getinfo.substring(4, getinfo.length()));
            }
            catch (IOException e) {
                if (e instanceof SocketException && ++done < 2) {
                    try {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(e.getMessage());
                    }
                    catch (SystemMessageException systemMessageException) {
                        continue;
                    }
                }
                throw new JMException(e.getMessage());
            }
            catch (SystemMessageException smsg) {
                ++done;
            }
        }
        return null;
    }

    private String returnMessage(String m) {
        int i = 0;
        try {
            i = Integer.parseInt(m);
        }
        catch (NumberFormatException e) {
            System.err.println(e.getMessage());
        }
        switch (i) {
            case 0: {
                return "Commad not implemented";
            }
            case 1: {
                return "Usage error";
            }
        }
        return "okay";
    }

    public void setJobComplete(boolean f1) {
        this.flag = f1;
    }

    public String getJobOutput() {
        return this.output;
    }

    public boolean getJobComplete() {
        return this.flag;
    }

    public String showPublicEnvVar(String env) throws JMException {
        String returnValue;
        block6: {
            String sendinfo = "SHOWPUB " + env;
            returnValue = null;
            try {
                this.aboutToSendCommand();
                this.sout.println(sendinfo);
                String getinfo = this.sin.readLine();
                if (getinfo == null) {
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                if (getinfo.substring(0, 3).compareTo("148") == 0) {
                    int i = getinfo.indexOf(58);
                    if (i > -1) {
                        returnValue = getinfo.substring(i + 1).trim();
                    }
                    break block6;
                }
                throw new JMException(getinfo.substring(4, getinfo.length()));
            }
            catch (IOException e) {
                throw new JMException(e.getMessage());
            }
            catch (SystemMessageException e) {
                throw new JMException(e.getMessage());
            }
        }
        return returnValue;
    }

    public InputStream getOutputSDS(String jobName, String dsn, int cutOff, int startline) throws Exception {
        StringBuffer buffer = new StringBuffer();
        String sendinfo = new String(copyright);
        int done = 0;
        int count = 0;
        sendinfo = "GETSDSC " + jobName + " " + dsn + " " + cutOff + " " + startline;
        while (done < 2) {
            try {
                this.aboutToSendCommand();
                this.sout.println(sendinfo);
                String getinfo = this.sin.readLine();
                if (getinfo == null) {
                    if (++done < 2) {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                    }
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                if (getinfo.startsWith("132")) {
                    throw new JMException(getinfo.substring(4, getinfo.length()));
                }
                if (getinfo.startsWith("133- message is")) {
                    return null;
                }
                if (getinfo.startsWith("133")) {
                    while (getinfo.startsWith("133") && count <= cutOff) {
                        buffer.append(getinfo.substring(5));
                        buffer.append("\n");
                        ++count;
                        getinfo = this.sin.readLine();
                    }
                    return new ByteArrayInputStream(buffer.toString().getBytes("UTF-8"));
                }
                if (getinfo.indexOf("167 End of SYSOUT DATA") <= -1) {
                    if (getinfo.startsWith("134") || getinfo.startsWith("105")) continue;
                    throw new JMException(getinfo.substring(4, getinfo.length()));
                }
                break;
            }
            catch (IOException e) {
                if (e instanceof SocketException && ++done < 2) {
                    if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                    throw new JMException(e.getMessage());
                }
                throw new JMException(e.getMessage());
            }
        }
        return new ByteArrayInputStream(buffer.toString().getBytes("UTF-8"));
    }

    public boolean isJobCompleted(String jobid) {
        try {
            ArrayList list = this.getStatus(jobid);
            for (String item : list) {
                if (!item.startsWith("155-Return.Code=")) continue;
                String partone = item.substring(18, 19);
                String returnStatus = partone.compareTo("8") == 0 ? "ABEND" : (partone.compareTo("4") == 0 ? "COMPLETION" : copyright);
                String parttwo = item.substring(19, 20);
                String returnInfo = parttwo.compareTo("0") == 0 ? "NOINFO" : (parttwo.compareTo("1") == 0 ? "NORMAL" : (parttwo.compareTo("2") == 0 ? "CC" : (parttwo.compareTo("3") == 0 ? "JCLERROR" : (parttwo.compareTo("4") == 0 ? "CANCELLED" : (parttwo.compareTo("5") == 0 ? "ABENDed" : (parttwo.compareTo("6") == 0 ? "ConverterABENDed" : (parttwo.compareTo("7") == 0 ? "SECURITYERROR" : (parttwo.compareTo("8") == 0 ? "EOMFailure" : "unknown"))))))));
                if (returnStatus == null || returnInfo == null || !returnStatus.equals("COMPLETION") && !returnStatus.equals("ABEND") && !returnInfo.equals("JCLERROR") && !returnInfo.equals("CANCELLED")) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean didJobEndWithAbend(String jobid) {
        try {
            ArrayList list = this.getStatus(jobid);
            for (String item : list) {
                if (!item.startsWith("155-Return.Code=")) continue;
                String partone = item.substring(18, 19);
                String returnStatus = partone.compareTo("8") == 0 ? "ABEND" : copyright;
                String parttwo = item.substring(19, 20);
                String returnInfo = parttwo.compareTo("5") == 0 ? "ABENDed" : "unknown";
                if (returnStatus == null || returnInfo == null || !returnStatus.equals("ABEND")) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean didJobEndWithJCLError(String jobid) {
        try {
            ArrayList list = this.getStatus(jobid);
            for (String item : list) {
                String parttwo;
                String returnInfo;
                if (!item.startsWith("155-Return.Code=") || (returnInfo = (parttwo = item.substring(19, 20)).compareTo("3") == 0 ? "JCLERROR" : "unknown") == null || !returnInfo.equals("JCLERROR")) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean didJobEndNormally(String jobid) {
        try {
            ArrayList list = this.getStatus(jobid);
            for (String item : list) {
                if (!item.startsWith("155-Return.Code=")) continue;
                String partone = item.substring(18, 19);
                String returnStatus = partone.compareTo("4") == 0 ? "COMPLETION" : copyright;
                String parttwo = item.substring(19, 20);
                String returnInfo = parttwo.compareTo("1") == 0 ? "NORMAL" : "unknown";
                if (returnStatus == null || returnInfo == null || !returnStatus.equals("COMPLETION") && !returnInfo.equals("NORMAL")) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    void closeSocketConnection() {
        try {
            if (this.sin != null) {
                this.sin.close();
            }
            if (this.sout != null) {
                this.sout.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.sin = null;
        this.sout = null;
        this.socket = null;
    }

    private void aboutToSendCommand() throws SystemMessageException {
        try {
            if (this.socket == null) {
                this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword);
                return;
            }
            if (this.sin.hasInput()) {
                String getinfo = this.sin.readLine();
                if (getinfo != null && getinfo.length() > 80) {
                    getinfo = getinfo.substring(0, 80);
                }
                if (getinfo != null && getinfo.startsWith("134")) {
                    Logger.getDefault().writeLog("Reconnecting after timeout");
                } else {
                    Logger.getDefault().writeLog("Reconnecting due to unexpected socket input: " + getinfo);
                }
                this.closeSocketConnection();
                this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword);
            }
        }
        catch (SystemMessageException e) {
            this.closeSocketConnection();
            throw e;
        }
        catch (IOException e) {
            this.closeSocketConnection();
            this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword);
        }
    }

    public String submit(InputStreamReader reader) throws JMException {
        int done = 0;
        BufferedReader f = new BufferedReader(reader);
        String sendinfo = new String(copyright);
        String mesg = new String(copyright);
        String tmp = new String(copyright);
        sendinfo = "SUBMIT";
        while (done < 2) {
            try {
                this.aboutToSendCommand();
                this.sout.println(sendinfo);
                String getinfo = this.sin.readLine();
                if (getinfo == null) {
                    if (++done < 2) {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                    }
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                while (getinfo.charAt(3) == '-') {
                    mesg = mesg + getinfo + "\n";
                    getinfo = this.sin.readLine();
                }
                if ((mesg = mesg + getinfo).startsWith("134") || mesg.startsWith("105")) {
                    mesg = copyright;
                    continue;
                }
                if (mesg.substring(0, 3).compareTo("116") != 0) {
                    throw new JMException(mesg.substring(4, mesg.length()));
                }
                mesg = "Allow for file to transfer!!";
                tmp = f.readLine();
                while (tmp != null) {
                    this.sout.println(tmp);
                    tmp = f.readLine();
                }
                this.sout.println("/*EOF");
                getinfo = this.sin.readLine();
                mesg = copyright;
                if (getinfo == null) {
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                while (getinfo.charAt(3) == '-') {
                    mesg = mesg + getinfo + "\n";
                    getinfo = this.sin.readLine();
                }
                if ((mesg = mesg + getinfo).substring(0, 3).compareTo("115") != 0) {
                    throw new JMException(mesg.substring(4, mesg.length()));
                }
                mesg = mesg.substring(4, mesg.length());
                f.close();
                return mesg;
            }
            catch (IOException e) {
                if (e instanceof SocketException && ++done < 2) {
                    try {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(e.getMessage());
                    }
                    catch (SystemMessageException systemMessageException) {
                        continue;
                    }
                }
                throw new JMException(e.getMessage());
            }
            catch (SystemMessageException smsg) {
                ++done;
            }
        }
        return mesg;
    }

    public byte[] getJcl(String jobName, String dsn) throws Exception {
        StringBuffer buffer = new StringBuffer();
        String sendinfo = new String(copyright);
        int done = 0;
        int count = 0;
        sendinfo = "GETJCL " + jobName + " " + dsn;
        while (done < 2) {
            try {
                this.aboutToSendCommand();
                this.sout.println(sendinfo);
                String getinfo = this.sin.readLine();
                if (getinfo == null) {
                    if (++done < 2) {
                        if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                        throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                    }
                    throw new JMException(zOSJESResources.JESException_ConnectionClosed);
                }
                if (getinfo.startsWith("132")) {
                    throw new JMException(getinfo.substring(4, getinfo.length()));
                }
                if (getinfo.startsWith("133- message is")) {
                    return null;
                }
                if (getinfo.startsWith("133")) {
                    while (getinfo.startsWith("133")) {
                        buffer.append(getinfo.substring(5));
                        buffer.append("\n");
                        ++count;
                        getinfo = this.sin.readLine();
                    }
                    return buffer.toString().getBytes("UTF-8");
                }
                if (getinfo.indexOf("167 End of SYSOUT DATA") <= -1) {
                    if (getinfo.startsWith("134") || getinfo.startsWith("105")) continue;
                    throw new JMException(getinfo.substring(4, getinfo.length()));
                }
                break;
            }
            catch (IOException e) {
                if (e instanceof SocketException && ++done < 2) {
                    if (this.connect(this.savedHost, this.savedPort, this.savedUserid, this.savedPassword)) continue;
                    throw new JMException(e.getMessage());
                }
                throw new JMException(e.getMessage());
            }
        }
        return buffer.toString().getBytes("UTF-8");
    }

    public JmonProtocol getProtocolLevel() {
        return this.negotiatedProtocol;
    }

    public String getJmonVersion() {
        return this.jmonVersion;
    }

    public String getJESName() {
        return this.JESName;
    }
}

