/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.securedata;

import com.urbancode.air.securedata.Envelope;
import com.urbancode.air.securedata.Keys;
import com.urbancode.air.securedata.SecretContainer;
import com.urbancode.air.securedata.crypto.CipherAlgorithm;
import com.urbancode.air.securedata.crypto.CryptoSuite;
import com.urbancode.air.securedata.crypto.MACAlgorithm;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

class EnvelopeEncoder {
    private final SecretContainer secret;
    private final CryptoSuite suite;
    private final SecureRandom random;

    EnvelopeEncoder(SecretContainer secret, CryptoSuite suite, SecureRandom random) {
        secret.getClass();
        suite.getClass();
        random.getClass();
        this.secret = secret;
        this.suite = suite;
        this.random = random;
    }

    void encodeBody(Envelope envelope) throws GeneralSecurityException {
        envelope.getClass();
        CipherAlgorithm cipherAlgorithm = this.suite.getCipherAlgorithm();
        MACAlgorithm macAlgorithm = this.suite.getMACAlgorithm();
        Envelope.Header header = envelope.getHeader();
        header.setCryptoSuite(this.suite.getName());
        header.setTimestamp(System.currentTimeMillis());
        header.setInitializationVector(cipherAlgorithm.createInitializationVector(this.random));
        Keys keys = new Keys(this.secret, header.getInitializationVector(), header.getTimestamp(), this.suite);
        SecretKey cipherKey = keys.getCipherKey();
        Cipher cipher = cipherAlgorithm.createCipher(cipherKey, header.getInitializationVector(), 1);
        envelope.setBody(cipher.doFinal(envelope.getBody()));
        SecretKey macKey = keys.getMACKey();
        Mac mac = macAlgorithm.createMac();
        mac.init(macKey);
        mac.update(header.toBytesForMAC());
        envelope.setHMAC(mac.doFinal(envelope.getBody()));
    }
}

