/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZFile;
import java.util.Properties;

public class AllocateDataset {
    private Properties inputProperties;
    private Properties outputProperties;

    public AllocateDataset(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        boolean ERR_CODE = true;
        try {
            String indatasetName = this.inputProperties.getProperty("dataSetName").trim();
            String volumeSerial = this.inputProperties.getProperty("volumeSerial").trim();
            int primaryQuantity = Integer.parseInt(this.inputProperties.getProperty("primaryQuantity").trim());
            int secondaryQuantity = Integer.parseInt(this.inputProperties.getProperty("secondaryQuantity").trim());
            int directoryBlocks = Integer.parseInt(this.inputProperties.getProperty("directoryBlocks").trim());
            int recordLength = Integer.parseInt(this.inputProperties.getProperty("recordLength").trim());
            int blockSize = Integer.parseInt(this.inputProperties.getProperty("blockSize").trim());
            String spaceUnit = this.inputProperties.getProperty("spaceUnit");
            String averageRECUnit = this.inputProperties.getProperty("averRecUnit");
            String recordFormat = this.inputProperties.getProperty("recordFormat");
            String dataSetNameType = this.inputProperties.getProperty("dataSetNameType");
            if (this.isNullOrEmpty(indatasetName)) {
                System.out.println(" [Error] Dataset Name can not be empty.");
                return 1;
            }
            String datasetName = "";
            datasetName = indatasetName.startsWith("'") ? indatasetName.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)indatasetName);
            String zFileDsn = ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
            if (ZFile.dsExists((String)zFileDsn)) {
                System.out.println(" [ERROR] Dataset " + datasetName + " already exist");
                return 1;
            }
            if (primaryQuantity < 0 || secondaryQuantity < 0) {
                System.out.println(" [Error] Primary or Secondary Quantity must be a postitive integer.");
                return 1;
            }
            if (recordLength < 0) {
                System.out.println(" [Error] Record length must be a positive integer.");
                return 1;
            }
            if (blockSize < 0) {
                System.out.println(" [Error] Block size must be a positive integer.");
                return 1;
            }
            if (directoryBlocks < 0) {
                System.out.println(" [Error] Directory blocks must be a positive integer.");
                return 1;
            }
            String ddName = ZFile.allocDummyDDName();
            String allocCommand = "alloc fi(" + ddName + ") da(" + datasetName + ")";
            if (!this.isNullOrEmpty(volumeSerial)) {
                allocCommand = allocCommand + " vol(" + volumeSerial + ")";
            }
            allocCommand = allocCommand + " space(" + primaryQuantity + "," + secondaryQuantity + ")";
            allocCommand = spaceUnit.equals("BLKS") ? allocCommand + " block(" + recordLength + ")" : allocCommand + " " + spaceUnit;
            if (blockSize > 0) {
                allocCommand = allocCommand + " blksize(" + blockSize + ")";
            }
            if (!averageRECUnit.equals("---")) {
                allocCommand = allocCommand + " avgrec(" + averageRECUnit + ")";
            }
            allocCommand = allocCommand + " dir(" + directoryBlocks + ") recfm(" + recordFormat + ")";
            if (!spaceUnit.equals("BLKS") || !recordFormat.equals("U")) {
                allocCommand = allocCommand + " lrecl(" + recordLength + ")";
            }
            if (!dataSetNameType.equals("---")) {
                allocCommand = allocCommand + " dsntype(" + dataSetNameType + ")";
            }
            allocCommand = allocCommand + " reuse new catalog msg(wtp)";
            System.out.println("Allocate Comand: " + allocCommand);
            ZFile.bpxwdyn((String)allocCommand);
            ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
            if (ZFile.dsExists((String)zFileDsn)) {
                System.out.println(" [INFO] Dataset " + datasetName + " is created.");
                return 0;
            }
            System.out.println(" [Error] Failed to create dataset " + datasetName);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    private boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }
}

