/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZFile;
import java.util.Properties;

public class AllocateDatasetSms {
    private Properties inputProperties;
    private Properties outputProperties;

    public AllocateDatasetSms(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        boolean ERR_CODE = true;
        try {
            String indatasetName = this.inputProperties.getProperty("datasetName").trim();
            boolean deleteDataset = Boolean.parseBoolean(this.inputProperties.getProperty("deleteDataset"));
            String managementClass = this.inputProperties.getProperty("managementClass").trim();
            String storageClass = this.inputProperties.getProperty("storageClass").trim();
            String dataClass = this.inputProperties.getProperty("dataClass");
            if (this.isNullOrEmpty(indatasetName)) {
                System.out.println(" [Error] Data set name can not be empty.");
                return 1;
            }
            String datasetName = "";
            datasetName = indatasetName.startsWith("'") ? indatasetName.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)indatasetName);
            String zFileDsn = ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
            if (ZFile.dsExists((String)zFileDsn)) {
                if (deleteDataset) {
                    System.out.println(" [INFO] Deleting existing dataset");
                    ZFile.remove((String)zFileDsn);
                } else {
                    System.out.println(" [ERROR] Dataset " + datasetName + " already exist");
                    return 1;
                }
            }
            if (this.isNullOrEmpty(managementClass) && this.isNullOrEmpty(storageClass) && this.isNullOrEmpty(dataClass)) {
                System.out.println(" [Error] At least one class needs to be specified.");
                return 1;
            }
            String ddName = ZFile.allocDummyDDName();
            String allocCommand = "alloc fi(" + ddName + ") da(" + datasetName + ")";
            if (!this.isNullOrEmpty(managementClass)) {
                allocCommand = allocCommand + " MGMTCLAS(" + managementClass + ")";
            }
            if (!this.isNullOrEmpty(storageClass)) {
                allocCommand = allocCommand + " STORCLAS(" + storageClass + ")";
            }
            if (!this.isNullOrEmpty(dataClass)) {
                allocCommand = allocCommand + " DATACLAS(" + dataClass + ")";
            }
            allocCommand = allocCommand + " reuse new catalog msg(wtp)";
            System.out.println("Allocate Comand: " + allocCommand);
            ZFile.bpxwdyn((String)allocCommand);
            ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
            if (ZFile.dsExists((String)zFileDsn)) {
                System.out.println(" [INFO] Dataset " + datasetName + " is created.");
                return 0;
            }
            System.out.println(" [Error] Failed to create dataset " + datasetName);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    private boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }
}

