/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

public class GatewayHelper {
    private String fileName;
    private String dsnPrefix;
    private String datasetName;
    private String slashSlashQuotedDSN;
    private final int ERR_CODE = 1;
    private final int AVAILABLE_RECLEN = 80;
    private final int BLKSIZE = 800;

    public GatewayHelper(String fileName, String dsnPrefix) {
        this.fileName = fileName;
        this.dsnPrefix = dsnPrefix;
    }

    public String createDatasetFromFile() {
        if (this.dsnPrefix == null || this.dsnPrefix.isEmpty()) {
            this.dsnPrefix = ZFile.getDefaultHLQ();
        }
        this.datasetName = this.tempDatasetNameGenerator();
        this.slashSlashQuotedDSN = ZFile.getSlashSlashQuotedDSN((String)this.datasetName, (boolean)true);
        this.createTempDatasetForRexx();
        RecordWriter recordWriter = null;
        BufferedReader bufReader = null;
        try {
            String line;
            bufReader = new BufferedReader(new FileReader(this.fileName));
            recordWriter = RecordWriter.newWriter((String)this.slashSlashQuotedDSN, (int)1);
            int lineCount = 0;
            byte[] recBuf = null;
            String platformEncoding = ZUtil.getDefaultPlatformEncoding();
            while ((line = bufReader.readLine()) != null) {
                ++lineCount;
                String record = String.format("%-80s", line.replaceAll("//s+$", ""));
                recBuf = record.getBytes(platformEncoding);
                if (recBuf.length > 80) {
                    System.out.println(" [ERROR] Line number " + lineCount + " in input text exceeds available record length of dataset " + 80);
                    bufReader.close();
                    recordWriter.close();
                    this.deleteTempRexxDataset(this.datasetName);
                    System.exit(1);
                    continue;
                }
                recordWriter.write(recBuf, 0, recBuf.length);
            }
            bufReader.close();
            recordWriter.close();
        }
        catch (IOException ioe1) {
            if (bufReader != null) {
                try {
                    bufReader.close();
                }
                catch (IOException ioe2) {
                    ioe2.printStackTrace();
                    this.deleteTempRexxDataset(this.datasetName);
                    System.exit(1);
                }
            }
            ioe1.printStackTrace();
            this.deleteTempRexxDataset(this.datasetName);
            System.exit(1);
        }
        catch (Exception e) {
            if (recordWriter != null) {
                try {
                    recordWriter.close();
                }
                catch (ZFileException zfe) {
                    zfe.printStackTrace();
                    this.deleteTempRexxDataset(this.datasetName);
                    System.exit(1);
                }
            }
            e.printStackTrace();
            this.deleteTempRexxDataset(this.datasetName);
            System.exit(1);
        }
        return this.datasetName;
    }

    public void deleteTempRexxDataset(String datasetName) {
        String zFileDsn = ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
        try {
            if (ZFile.dsExists((String)zFileDsn)) {
                ZFile.remove((String)zFileDsn);
            }
        }
        catch (ZFileException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void createTempDatasetForRexx() {
        try {
            File rexxFile = new File(this.fileName);
            if (!rexxFile.exists() || !rexxFile.isFile()) {
                System.out.println(" [Error] File " + rexxFile.getCanonicalPath() + " is either does not exist or not a file");
                System.exit(1);
            }
            long bytes = rexxFile.length();
            int trks = 0;
            trks = bytes <= 56664L ? 1 : (int)(bytes / 56664L);
            String fullyQualifiedDsn = ZFile.getFullyQualifiedDSN((String)this.slashSlashQuotedDSN);
            String tempDD = ZFile.allocDummyDDName();
            ZFile.bpxwdyn((String)("alloc fi(" + tempDD + ") da(" + fullyQualifiedDsn + ") reuse new dsorg(ps) lrecl(" + 80 + ") recfm(f,b) tracks space(" + trks + "," + trks + ") blksize(" + 800 + ") catalog msg(wtp)"));
            ZFile.bpxwdyn((String)("free fi(" + tempDD + ") msg(wtp)"));
            if (!ZFile.dsExists((String)this.slashSlashQuotedDSN)) {
                System.out.println(" [Error] Failed to create temporary rexx dataset - " + fullyQualifiedDsn);
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private String tempDatasetNameGenerator() {
        Random rand = new Random();
        this.dsnPrefix = this.dsnPrefix + ".UCDRECV.R" + rand.nextInt(1000000);
        SimpleDateFormat sdfDate = new SimpleDateFormat("HHmmss.SSS");
        Date now = new Date();
        String strDate = sdfDate.format(now);
        return this.dsnPrefix + ".T" + strDate.substring(0, 6) + ".M" + strDate.substring(7, 10);
    }
}

