/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.team.enterprise.deployment.toolkit.manifest.AbstractGenerateManifest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GenerateRollbackManifest
extends AbstractGenerateManifest {
    private String CREATED_TAG = "created";
    private String DELETED_TAG = "deleted";
    private String UPDATED_TAG = "updated";
    private String TRANSIENT = "_tmp";
    private String CONTAINER_TAG = "container";
    private String RESOURCE_TAG = "resource";
    private String CHANGE_TYPE = "changeType";
    private String ADD_TYPE = "ADD";
    private String DELETE_TYPE = "DELETE";
    private String SIZE_TYPE = "size";
    private String LAST_MODIFIED_TIME_TYPE = "lastModifiedTimestamp";
    private String WORKITEM_NUMBER_TYPE = "workItemId";
    private String WORKITEM_UUID_TYPE = "workItemUUID";
    private String MISSING_ATTRIBUTE = "missing";
    private String MISSING_TRUE = "true";

    public GenerateRollbackManifest(String deltaDeployManifestPath, String rollbackManifestPath) throws Exception {
        super(deltaDeployManifestPath, rollbackManifestPath);
        DocumentBuilderFactory docBldrFactory = DocumentBuilderFactory.newInstance();
        docBldrFactory.setIgnoringElementContentWhitespace(true);
        docBldrFactory.setCoalescing(true);
        docBldrFactory.setIgnoringComments(true);
        try {
            NodeList deletedTmpNodes;
            NodeList updatedNodes;
            NodeList deletedNodes;
            DocumentBuilder docBldr = docBldrFactory.newDocumentBuilder();
            Document document = docBldr.parse(this.inputManifest);
            NodeList createdNodes = document.getElementsByTagName(this.CREATED_TAG);
            if (createdNodes.getLength() > 0) {
                document.renameNode(createdNodes.item(0), null, this.DELETED_TAG + this.TRANSIENT);
                NodeList createdChildNodes = createdNodes.item(0).getChildNodes();
                for (int i = 0; i < createdChildNodes.getLength(); ++i) {
                    Node container = createdChildNodes.item(i);
                    if (!container.getNodeName().equals(this.CONTAINER_TAG)) continue;
                    for (int j = 0; j < container.getAttributes().getLength(); ++j) {
                        NamedNodeMap attributes = container.getAttributes();
                        Node type = attributes.getNamedItem(this.CHANGE_TYPE);
                        if (!type.getNodeValue().equals(this.ADD_TYPE)) continue;
                        type.setNodeValue(this.DELETE_TYPE);
                    }
                    this.cleanUpAttributes(container);
                }
            }
            if ((deletedNodes = document.getElementsByTagName(this.DELETED_TAG)).getLength() > 0) {
                int i;
                NodeList deletedChildNodes = deletedNodes.item(0).getChildNodes();
                for (i = 0; i < deletedChildNodes.getLength(); ++i) {
                    Node container = deletedChildNodes.item(i);
                    if (!container.getNodeName().equals(this.CONTAINER_TAG)) continue;
                    if (container.getAttributes().getNamedItem(this.MISSING_ATTRIBUTE) != null && this.MISSING_TRUE.equals(container.getAttributes().getNamedItem(this.MISSING_ATTRIBUTE).getNodeValue())) {
                        deletedNodes.item(0).removeChild(container);
                        continue;
                    }
                    NodeList resources = container.getChildNodes();
                    for (int j = 0; j < resources.getLength(); ++j) {
                        Node resource = resources.item(j);
                        if (!resource.getNodeName().equals(this.RESOURCE_TAG) || resource.getAttributes().getNamedItem(this.MISSING_ATTRIBUTE) == null || !this.MISSING_TRUE.equals(resource.getAttributes().getNamedItem(this.MISSING_ATTRIBUTE).getNodeValue())) continue;
                        container.removeChild(resource);
                    }
                }
                deletedChildNodes = deletedNodes.item(0).getChildNodes();
                for (i = 0; i < deletedChildNodes.getLength(); ++i) {
                    Node container = deletedChildNodes.item(i);
                    if (!container.getNodeName().equals(this.CONTAINER_TAG)) continue;
                    for (int j = 0; j < container.getAttributes().getLength(); ++j) {
                        NamedNodeMap attributes = container.getAttributes();
                        Node type = attributes.getNamedItem(this.CHANGE_TYPE);
                        type.setNodeValue(this.ADD_TYPE);
                    }
                    this.cleanUpAttributes(container);
                }
                document.renameNode(deletedNodes.item(0), null, this.CREATED_TAG);
            }
            if ((updatedNodes = document.getElementsByTagName(this.UPDATED_TAG)).getLength() > 0) {
                NodeList updatedChildNodes = updatedNodes.item(0).getChildNodes();
                for (int i = 0; i < updatedChildNodes.getLength(); ++i) {
                    Node container = updatedChildNodes.item(i);
                    if (!container.getNodeName().equals(this.CONTAINER_TAG)) continue;
                    this.cleanUpAttributes(container);
                }
            }
            if ((deletedTmpNodes = document.getElementsByTagName(this.DELETED_TAG + this.TRANSIENT)).getLength() > 0) {
                document.renameNode(deletedTmpNodes.item(0), null, this.DELETED_TAG);
            }
            this.saveRollbackFile(document);
            this.convertToDefaultEncoding();
        }
        catch (ParserConfigurationException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (TransformerConfigurationException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    private void convertToDefaultEncoding() {
        try {
            File tempFile = new File(this.outputManifest.getAbsolutePath() + ".tmp");
            BufferedReader br = new BufferedReader(new FileReader(this.outputManifest));
            PrintWriter pw = new PrintWriter(new FileWriter(tempFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                pw.println(line);
                pw.flush();
            }
            pw.close();
            br.close();
            if (!this.outputManifest.delete()) {
                return;
            }
            tempFile.renameTo(this.outputManifest);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private void cleanUpAttributesOnResource(NamedNodeMap attributes) {
        Node workItemUUID;
        Node workItemNumber;
        Node lastModifiedTime;
        Node size = attributes.getNamedItem(this.SIZE_TYPE);
        if (size != null) {
            attributes.removeNamedItem(this.SIZE_TYPE);
        }
        if ((lastModifiedTime = attributes.getNamedItem(this.LAST_MODIFIED_TIME_TYPE)) != null) {
            attributes.removeNamedItem(this.LAST_MODIFIED_TIME_TYPE);
        }
        if ((workItemNumber = attributes.getNamedItem(this.WORKITEM_NUMBER_TYPE)) != null) {
            attributes.removeNamedItem(this.WORKITEM_NUMBER_TYPE);
        }
        if ((workItemUUID = attributes.getNamedItem(this.WORKITEM_UUID_TYPE)) != null) {
            attributes.removeNamedItem(this.WORKITEM_UUID_TYPE);
        }
    }

    private void cleanUpAttributes(Node container) {
        NodeList resources = container.getChildNodes();
        for (int i = 0; i < resources.getLength(); ++i) {
            Node resource = resources.item(i);
            if (!resource.getNodeName().equals(this.RESOURCE_TAG)) continue;
            this.cleanUpAttributesOnResource(resource.getAttributes());
        }
    }
}

