/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.jzos.ZFile;
import java.util.Properties;

public class AllocateLike {
    private Properties inputProperties;
    private Properties outputProperties;

    public AllocateLike(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() {
        boolean ERR_CODE = true;
        try {
            String indatasetName = this.inputProperties.getProperty("datasetName").trim();
            String inlikeDatasetName = this.inputProperties.getProperty("likeDatasetName").trim();
            boolean deleteDataset = Boolean.parseBoolean(this.inputProperties.getProperty("deleteDataset"));
            String volumeSerial = this.inputProperties.getProperty("volumeSerial").trim();
            String spaceUnit = this.inputProperties.getProperty("spaceUnit").trim();
            int primaryQuantity = Integer.parseInt(this.inputProperties.getProperty("primaryQuantity").trim());
            int secondaryQuantity = Integer.parseInt(this.inputProperties.getProperty("secondaryQuantity").trim());
            if (this.isNullOrEmpty(indatasetName)) {
                System.out.println(" [Error] Data set name can not be empty.");
                return 1;
            }
            String datasetName = "";
            datasetName = indatasetName.startsWith("'") ? indatasetName.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)indatasetName);
            String zFileDsn = ZFile.getSlashSlashQuotedDSN((String)datasetName, (boolean)true);
            if (ZFile.dsExists((String)zFileDsn)) {
                if (deleteDataset) {
                    System.out.println(" [INFO] Deleting existing dataset");
                    ZFile.remove((String)zFileDsn);
                } else {
                    System.out.println(" [ERROR] Dataset " + datasetName + " already exist");
                    return 1;
                }
            }
            if (this.isNullOrEmpty(inlikeDatasetName)) {
                System.out.println(" [Error] Like data set name can not be empty.");
                return 1;
            }
            String likeDatasetName = "";
            likeDatasetName = inlikeDatasetName.startsWith("'") ? inlikeDatasetName.replace('\'', ' ').trim() : ZFile.getFullyQualifiedDSN((String)inlikeDatasetName);
            String zFileLikeDsn = ZFile.getSlashSlashQuotedDSN((String)likeDatasetName, (boolean)true);
            if (!ZFile.dsExists((String)zFileLikeDsn)) {
                System.out.println(" [ERROR] Like Dataset " + likeDatasetName + " does not exist");
                return 1;
            }
            String ddName = ZFile.allocDummyDDName();
            String allocCommand = "alloc fi(" + ddName + ") da(" + datasetName + ") like(" + likeDatasetName + ")";
            if (primaryQuantity > 0 && secondaryQuantity > 0) {
                allocCommand = allocCommand + " space(" + primaryQuantity + "," + secondaryQuantity + ")";
                if (spaceUnit.equals("TRACKS") || spaceUnit.equals("CYL")) {
                    allocCommand = allocCommand + " " + spaceUnit;
                }
            }
            if (!this.isNullOrEmpty(volumeSerial)) {
                allocCommand = allocCommand + " vol(" + volumeSerial + ")";
            }
            allocCommand = allocCommand + " reuse new catalog msg(wtp)";
            System.out.println("Allocate Comand: " + allocCommand);
            ZFile.bpxwdyn((String)allocCommand);
            ZFile.bpxwdyn((String)("free fi(" + ddName + ") msg(wtp)"));
            if (ZFile.dsExists((String)zFileDsn)) {
                System.out.println(" [INFO] Dataset " + datasetName + " is created.");
                return 0;
            }
            System.out.println(" [Error] Failed to create dataset " + datasetName);
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    private boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }
}

