/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.jes.passticket;

import com.ibm.eserver.zos.racf.IRRPassTicket;
import com.ibm.eserver.zos.racf.IRRPassTicketGenerationException;
import com.ibm.urbancode.zos.jes.Logger;

public class PassTicketUtil {
    public static String generatePassTicket(String userid, String applid, String libpath) throws Exception {
        try {
            userid = userid.toUpperCase();
            Logger.getDefault().writeLog("Generating passticket. ");
            if (libpath != null || libpath.length() > 0) {
                System.setProperty("java.library.path", libpath + ":" + System.getProperty("java.library.path"));
            }
            IRRPassTicket pt = new IRRPassTicket();
            String password = pt.generate(userid, applid);
            return password;
        }
        catch (IRRPassTicketGenerationException e) {
            Logger.getDefault().writeError("Failed to generate passticket for user(" + userid + ") applid(" + applid + ")");
            if ("SafRc=8, racfRc=8 racfRsn=16".equalsIgnoreCase(e.toString())) {
                Logger.getDefault().writeError("Not authorized to use passticket.");
            } else {
                Logger.getDefault().writeError("See the 'Return and reason codes' section of the R_gensec chapter in z/OS Security Server RACF Callable Services book");
            }
            throw e;
        }
    }
}

