/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.deployment.toolkit.manifest;

import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DeployMVS {
    private static final String ENCODING_IBM_1047 = "IBM-1047";
    private static final int ERR_REC = 8;
    private static final String CONTAINER_NODE = "container";
    private static final String DELETE_ACTION_NODE = "deleted";
    private static final String RESOURCE_NODE = "resource";
    private static final String PROPERTY_NODE = "property";
    private static final String CONTAINER_TYPE_SEQUENTIAL_VALUE = "sequential";
    private static final String CONTAINER_TYPE_KEY = "type";
    private static final String CONTAINER_NAME_KEY = "name";
    private static final String RESOURCE_NAME_KEY = "name";
    private static final String RESOURCE_DEPLOY_TYPE_KEY = "deployType";
    private static final String RESOURCE_TIMESTAMP = "lastModifiedTimestamp";
    private static final String RESOURCE_USERID = "lastModifiedUserid";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_VALUE = "value";
    private static final String CONTAINER_DEPLOY_TYPE_KEY = "deployType";
    private static final String CONTAINER_COPY_TYPE_KEY = "copyType";
    private static final String CONTAINER_TYPE_PDS_VALUE = "PDS";
    private static final String TWO_SLASHES_AND_SINGLE_QUOTE = "//'";
    private static final String SINGLE_QUOTE = "'";
    private static final String ASTERISK = "*";
    private static final String DOUBLE_QUOTES = "\"";
    private static final String SINGLE_SPACE = " ";
    private static final String SEMI_COLON = ";";
    private static final String COPY_CMD = "cp ";
    private static final String SEQ = "SEQ";
    private static final String PDS = "PDS";
    private static final String DEL_ACTION = "DELETE";
    private static final String UPD_ACTION = "UPDATE";
    private static final String TEXT = "TEXT";
    private static final String BINARY = "BINARY";
    private static final String LOAD = "LOAD";
    private static final Map<String, String> copyTypesAndOptions = new HashMap<String, String>(){
        {
            this.put("EXEC", "-XI ");
            this.put(DeployMVS.LOAD, "-XI ");
            this.put(DeployMVS.BINARY, "-B ");
            this.put(DeployMVS.TEXT, "-T ");
        }
    };
    private static final String TEMP_FILE_NAME = "deploy_temp.sh";
    private static final String PACKAGE_FILE_NAME = "package.zip";
    private static final String RECLN_PROPERTY = "SYS.id.RECLN";
    private static final String RECFM_PROPERTY = "SYS.id.RECFM";
    private static final String RECORG_PROPERTY = "SYS.id.RECORG";
    private static final String BLKSZ_PROPERTY = "SYS.id.BLKSZ";
    private static final String DSNTYPE_PROPERTY = "SYS.id.LIBTYPE";
    private String manifestFilePath = null;
    private String componentVersionWorkingDir = null;
    private String containerMapperFilePath = null;
    private String tempDsnPrefix = null;
    private List<String> sourceList = new ArrayList<String>();
    private List<String> targetList = new ArrayList<String>();
    private String copyType = "";
    private String recLength = "";
    private String recFM = "";
    private String recOrg = "";
    private String blkSize = "";
    private String dsnType = "";
    private String dsnTypeString = "DSNTYPE(PDS) ";
    private int dirBlks = 0;
    private List<String> tempDataSetList = new ArrayList<String>();

    public DeployMVS(String manifestFilePath, String componentVersionWorkingDir, String containerMapperFilePath, String tempDsnPrefix) throws Exception {
        this.manifestFilePath = manifestFilePath;
        this.componentVersionWorkingDir = componentVersionWorkingDir;
        this.containerMapperFilePath = containerMapperFilePath;
        this.tempDsnPrefix = tempDsnPrefix;
    }

    public String deployArtifacts() {
        Boolean nestedInDeletedContainer = false;
        String containerName = "";
        String containerType = "";
        String containerDeployType = "";
        String containerCopyType = "";
        String tempDSNName = "";
        String resourceName = "";
        String resourceDeployType = "";
        String resourceTimestamp = "";
        Boolean nestedInPDSContainer = false;
        Boolean resourceWritten = false;
        Boolean containerWritten = false;
        Boolean mvsContainer = false;
        String tempFileName = null;
        ZFile dsnFile = null;
        BufferedWriter commandWriter = null;
        this.readContainerMapperFile();
        try {
            FileInputStream inManifestFileStream = null;
            inManifestFileStream = new FileInputStream(this.manifestFilePath);
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLEventReader manifestEventReader = inputFactory.createXMLEventReader(inManifestFileStream, ENCODING_IBM_1047);
            File commandFile = new File(this.componentVersionWorkingDir + File.separator + TEMP_FILE_NAME);
            File packageZip = new File(this.componentVersionWorkingDir + File.separator + PACKAGE_FILE_NAME);
            if (packageZip.exists()) {
                this.extractPackage(commandFile);
            }
            commandWriter = new BufferedWriter(new FileWriter(commandFile.getAbsolutePath()));
            commandWriter.write("#!/bin/sh");
            commandWriter.newLine();
            if (this.tempDsnPrefix == null || this.tempDsnPrefix.isEmpty()) {
                this.tempDsnPrefix = ZFile.getDefaultHLQ();
            }
            Random rand = new Random();
            this.tempDsnPrefix = this.tempDsnPrefix + ".UCDRECV.R" + rand.nextInt(1000000);
            tempFileName = this.tempFileNameGenerator(this.tempDsnPrefix);
            String qualTempFileName = TWO_SLASHES_AND_SINGLE_QUOTE + tempFileName + SINGLE_QUOTE;
            this.createFileWithAttributes(qualTempFileName);
            dsnFile = new ZFile(qualTempFileName, "wb,type=record,noseek");
            dsnFile.write("DSNtype;Action;SrceDSN;TargDSN;PDSmem;DepType;MDate;MUser".getBytes());
            block12: while (manifestEventReader.hasNext()) {
                XMLEvent shipListReaderEvent = manifestEventReader.nextEvent();
                switch (shipListReaderEvent.getEventType()) {
                    case 7: {
                        break;
                    }
                    case 1: {
                        StartElement startElement = shipListReaderEvent.asStartElement();
                        String nodeName = startElement.getName().getLocalPart().trim();
                        if (DELETE_ACTION_NODE.equalsIgnoreCase(nodeName)) {
                            nestedInDeletedContainer = true;
                            break;
                        }
                        if (nestedInDeletedContainer.booleanValue()) {
                            if (CONTAINER_NODE.equalsIgnoreCase(nodeName)) {
                                containerType = this.getAttributeValue(startElement, CONTAINER_TYPE_KEY);
                                containerName = this.getAttributeValue(startElement, "name");
                                if (containerType.equalsIgnoreCase("PDS")) {
                                    nestedInPDSContainer = true;
                                    mvsContainer = true;
                                    break;
                                }
                                if (containerType.equalsIgnoreCase(CONTAINER_TYPE_SEQUENTIAL_VALUE)) {
                                    dsnFile.write(("SEQ;DELETE;;" + this.targetList.get(this.sourceList.indexOf(containerName)) + SEMI_COLON + SEMI_COLON + SEMI_COLON + SEMI_COLON).getBytes());
                                    mvsContainer = true;
                                    break;
                                }
                                mvsContainer = false;
                                break;
                            }
                            if (!RESOURCE_NODE.equalsIgnoreCase(nodeName) || !nestedInPDSContainer.booleanValue()) break;
                            resourceName = this.getAttributeValue(startElement, "name");
                            dsnFile.write(("PDS;DELETE;;" + this.targetList.get(this.sourceList.indexOf(containerName)) + SEMI_COLON + resourceName + SEMI_COLON + SEMI_COLON + SEMI_COLON).getBytes());
                            resourceWritten = true;
                            break;
                        }
                        if (CONTAINER_NODE.equalsIgnoreCase(nodeName)) {
                            containerType = this.getAttributeValue(startElement, CONTAINER_TYPE_KEY);
                            if (!containerType.equalsIgnoreCase("PDS") && !containerType.equalsIgnoreCase(CONTAINER_TYPE_SEQUENTIAL_VALUE)) {
                                mvsContainer = false;
                                break;
                            }
                            mvsContainer = true;
                            containerName = this.getAttributeValue(startElement, "name");
                            containerDeployType = this.getAttributeValue(startElement, "deployType");
                            containerCopyType = this.getAttributeValue(startElement, CONTAINER_COPY_TYPE_KEY);
                            if (containerCopyType != null && copyTypesAndOptions.containsKey(containerCopyType)) {
                                this.copyType = containerCopyType;
                            } else {
                                containerDeployType = containerDeployType != null ? containerDeployType : "";
                                this.setCopyOptions(containerDeployType);
                            }
                            String targetName = this.targetList.get(this.sourceList.indexOf(containerName));
                            Path path = Paths.get(this.componentVersionWorkingDir + File.separator + containerName, new String[0]);
                            int tracks = this.getFolderSize(path);
                            String quotedtargetName = TWO_SLASHES_AND_SINGLE_QUOTE + targetName + SINGLE_QUOTE;
                            this.setContainerProperties(containerName, manifestEventReader, containerType);
                            if (!ZFile.dsExists((String)quotedtargetName)) {
                                this.createTargetDataset(targetName, tracks);
                            }
                            tempDSNName = this.tempFileNameGenerator(this.tempDsnPrefix);
                            if (containerType.equalsIgnoreCase("PDS")) {
                                nestedInPDSContainer = true;
                                this.createTempDataSet(tempDSNName, targetName, tracks);
                                if (containerDeployType == "") continue block12;
                                commandWriter.append(COPY_CMD + copyTypesAndOptions.get(this.copyType) + this.componentVersionWorkingDir + File.separator + containerName + File.separator + ASTERISK + SINGLE_SPACE + DOUBLE_QUOTES + TWO_SLASHES_AND_SINGLE_QUOTE + tempDSNName + SINGLE_QUOTE + DOUBLE_QUOTES);
                                commandWriter.newLine();
                                this.addCommandCheck(commandWriter);
                                if (containerWritten.booleanValue() || this.copyType.equals(TEXT)) continue block12;
                                dsnFile.write(("PDS;UPDATE;" + tempDSNName + SEMI_COLON + targetName + SEMI_COLON + SEMI_COLON + this.copyType + SEMI_COLON + SEMI_COLON).getBytes());
                                containerWritten = true;
                                break;
                            }
                            if (!containerType.equalsIgnoreCase(CONTAINER_TYPE_SEQUENTIAL_VALUE)) continue block12;
                            this.createTempDataSet(tempDSNName, targetName, 0);
                            commandWriter.append(COPY_CMD + copyTypesAndOptions.get(this.copyType) + this.componentVersionWorkingDir + File.separator + containerName + SINGLE_SPACE + DOUBLE_QUOTES + TWO_SLASHES_AND_SINGLE_QUOTE + tempDSNName + SINGLE_QUOTE + DOUBLE_QUOTES);
                            commandWriter.newLine();
                            this.addCommandCheck(commandWriter);
                            dsnFile.write(("SEQ;UPDATE;" + tempDSNName + SEMI_COLON + this.targetList.get(this.sourceList.indexOf(containerName)) + SEMI_COLON + SEMI_COLON + this.copyType + SEMI_COLON + SEMI_COLON).getBytes());
                            containerWritten = true;
                            break;
                        }
                        if (RESOURCE_NODE.equalsIgnoreCase(nodeName) && nestedInPDSContainer.booleanValue()) {
                            resourceName = this.getAttributeValue(startElement, "name");
                            resourceDeployType = this.getAttributeValue(startElement, "deployType");
                            resourceDeployType = resourceDeployType != null ? resourceDeployType : containerDeployType;
                            resourceTimestamp = this.getAttributeValue(startElement, RESOURCE_TIMESTAMP);
                            String string = resourceTimestamp = resourceTimestamp != null ? resourceTimestamp : "";
                            if (containerDeployType == "" && resourceDeployType != "") {
                                commandWriter.append(COPY_CMD + copyTypesAndOptions.get(this.copyType) + this.componentVersionWorkingDir + File.separator + containerName + File.separator + resourceName + SINGLE_SPACE + DOUBLE_QUOTES + TWO_SLASHES_AND_SINGLE_QUOTE + tempDSNName + SINGLE_QUOTE + DOUBLE_QUOTES);
                                commandWriter.newLine();
                                this.addCommandCheck(commandWriter);
                                break;
                            }
                            if (containerDeployType != "" || resourceDeployType != "") break;
                            throw new Exception(" [Error] Deploy type is not specified in both Container and Resource level");
                        }
                        if (!PROPERTY_NODE.equalsIgnoreCase(nodeName) || !nestedInPDSContainer.booleanValue()) break;
                        String propertyName = this.getAttributeValue(startElement, "name");
                        String propertyVal = this.getAttributeValue(startElement, PROPERTY_VALUE);
                        if (propertyName == null || !propertyName.contains(RESOURCE_USERID) || containerWritten.booleanValue()) continue block12;
                        dsnFile.write(("PDS;UPDATE;" + tempDSNName + SEMI_COLON + this.targetList.get(this.sourceList.indexOf(containerName)) + SEMI_COLON + resourceName + SEMI_COLON + this.copyType + SEMI_COLON + resourceTimestamp + SEMI_COLON + propertyVal).getBytes());
                        resourceWritten = true;
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 2: {
                        EndElement endElement = shipListReaderEvent.asEndElement();
                        String nodeName = endElement.getName().getLocalPart().trim();
                        if (DELETE_ACTION_NODE.equalsIgnoreCase(nodeName)) {
                            nestedInDeletedContainer = false;
                            break;
                        }
                        if (CONTAINER_NODE.equalsIgnoreCase(nodeName)) {
                            this.copyType = "";
                            nestedInPDSContainer = false;
                            containerWritten = false;
                            mvsContainer = false;
                            this.dirBlks = 0;
                            this.recLength = "";
                            this.recFM = "";
                            this.recOrg = "";
                            this.blkSize = "";
                            this.dsnType = "";
                            this.dsnTypeString = "DSNTYPE(PDS) ";
                            break;
                        }
                        if (!RESOURCE_NODE.equalsIgnoreCase(nodeName)) break;
                        if (!resourceWritten.booleanValue() && !containerWritten.booleanValue() && mvsContainer.booleanValue()) {
                            dsnFile.write(("PDS;UPDATE;" + tempDSNName + SEMI_COLON + this.targetList.get(this.sourceList.indexOf(containerName)) + SEMI_COLON + resourceName + SEMI_COLON + this.copyType + SEMI_COLON + resourceTimestamp + SEMI_COLON).getBytes());
                            break;
                        }
                        resourceWritten = false;
                        break;
                    }
                }
            }
            commandWriter.flush();
            commandWriter.close();
            if (dsnFile != null) {
                dsnFile.close();
            }
            this.executeTempFile();
        }
        catch (Exception e) {
            if (dsnFile != null) {
                try {
                    dsnFile.close();
                }
                catch (ZFileException zfe) {
                    zfe.printStackTrace();
                    System.exit(8);
                }
            }
            if (commandWriter != null) {
                try {
                    commandWriter.close();
                }
                catch (IOException ioe) {
                    this.cleanTempDsns();
                    ioe.printStackTrace();
                    System.exit(8);
                }
            }
            this.cleanTempDsns();
            e.printStackTrace();
            System.exit(8);
        }
        return tempFileName;
    }

    private void setContainerProperties(String containerName, XMLEventReader manifestEventReader, String containerType) throws XMLStreamException {
        if (containerType.trim().equals(CONTAINER_TYPE_SEQUENTIAL_VALUE)) {
            this.dirBlks = 0;
        } else {
            this.dirBlks = new File(this.componentVersionWorkingDir + File.separator + containerName).listFiles().length;
            this.dirBlks = this.dirBlks / 6 + 1;
        }
        boolean endOfContainerProperties = false;
        while (!endOfContainerProperties) {
            XMLEvent manifestContainerProperty;
            Integer manifestEventReaderPeek = manifestEventReader.peek().getEventType();
            if (manifestEventReaderPeek == 4) {
                XMLEvent xMLEvent = manifestEventReader.nextEvent();
            }
            if (manifestEventReaderPeek == 2 && manifestEventReader.peek().asEndElement().getName().getLocalPart().trim() == CONTAINER_NODE) {
                endOfContainerProperties = true;
            }
            if (manifestEventReaderPeek == 2 && manifestEventReader.peek().asEndElement().getName().getLocalPart().trim() == PROPERTY_NODE) {
                manifestContainerProperty = manifestEventReader.nextEvent();
                EndElement endElement = manifestContainerProperty.asEndElement();
            }
            if (manifestEventReaderPeek == 1 && manifestEventReader.peek().asStartElement().getName().getLocalPart().trim() == RESOURCE_NODE) {
                endOfContainerProperties = true;
            }
            if (manifestEventReaderPeek != 1 || manifestEventReader.peek().asStartElement().getName().getLocalPart().trim() != PROPERTY_NODE) continue;
            manifestContainerProperty = manifestEventReader.nextEvent();
            StartElement startPropertyElement = manifestContainerProperty.asStartElement();
            String propertyName = this.getAttributeValue(startPropertyElement, "name");
            String propertyValue = this.getAttributeValue(startPropertyElement, PROPERTY_VALUE);
            switch (propertyName) {
                case "SYS.id.RECLN": {
                    this.recLength = propertyValue;
                    break;
                }
                case "SYS.id.RECFM": {
                    this.recFM = propertyValue;
                    break;
                }
                case "SYS.id.RECORG": {
                    this.recOrg = propertyValue;
                    break;
                }
                case "SYS.id.BLKSZ": {
                    this.blkSize = propertyValue;
                    break;
                }
                case "SYS.id.LIBTYPE": {
                    this.dsnType = propertyValue;
                }
            }
        }
    }

    private void createTargetDataset(String targetName, int tracks) throws RcException {
        tracks += 10;
        if (this.dirBlks == 0) {
            this.dsnTypeString = SINGLE_SPACE;
        }
        if (this.dsnType.trim().equals("PDSE")) {
            this.dsnTypeString = "DSNTYPE(LIBRARY) ";
        }
        String targetDD = ZFile.allocDummyDDName();
        String targetDSN = targetName;
        String createTargetDatasetAlloc = "alloc fi(" + targetDD + ") da(" + targetDSN + ") dsorg(" + this.recOrg + ") lrecl(" + this.recLength + ") blksize(" + this.blkSize + ") space(" + tracks + "," + tracks + ") tracks RECFM(" + this.recFM + ") " + this.dsnTypeString + " dir(" + this.dirBlks + ") reuse new catalog msg(wtp)";
        ZFile.bpxwdyn((String)createTargetDatasetAlloc);
        ZFile.bpxwdyn((String)("free fi(" + targetDD + ") msg(wtp)"));
    }

    public void createTempDataSet(String newFilename, String modelFilename, int tracks) throws RcException {
        modelFilename = TWO_SLASHES_AND_SINGLE_QUOTE + modelFilename + SINGLE_QUOTE;
        newFilename = TWO_SLASHES_AND_SINGLE_QUOTE + newFilename + SINGLE_QUOTE;
        String targetDD = ZFile.allocDummyDDName();
        String sourceDSN = ZFile.getFullyQualifiedDSN((String)modelFilename);
        String targetDSN = ZFile.getFullyQualifiedDSN((String)newFilename);
        if (tracks > 0) {
            tracks += 10;
        }
        if (tracks == 0) {
            ZFile.bpxwdyn((String)("alloc fi(" + targetDD + ") da(" + targetDSN + ") like(" + sourceDSN + ") reuse new catalog msg(wtp)"));
        } else {
            ZFile.bpxwdyn((String)("alloc fi(" + targetDD + ") da(" + targetDSN + ") like(" + sourceDSN + ") blksize(" + this.blkSize + ") space(" + tracks + "," + tracks + ") tracks  reuse new catalog msg(wtp)"));
        }
        ZFile.bpxwdyn((String)("free fi(" + targetDD + ") msg(wtp)"));
        this.tempDataSetList.add(targetDSN);
    }

    private void cleanTempDsns() {
        if (this.tempDataSetList.size() > 0) {
            System.out.println(" [INFO] Cleaning temporary datasets...");
        }
        for (int i = 0; i < this.tempDataSetList.size(); ++i) {
            try {
                ZFile.remove((String)ZFile.getSlashSlashQuotedDSN((String)this.tempDataSetList.get(i), (boolean)true));
                continue;
            }
            catch (ZFileException e) {
                e.printStackTrace();
                System.exit(8);
            }
        }
    }

    private void extractPackage(File commandFile) throws Exception {
        BufferedWriter commandWriter = new BufferedWriter(new FileWriter(commandFile.getAbsolutePath()));
        commandWriter.append("#!/bin/sh");
        commandWriter.newLine();
        commandWriter.append("pax -r -f package.zip");
        commandWriter.newLine();
        this.addCommandCheck(commandWriter);
        commandWriter.flush();
        commandWriter.close();
        this.executeTempFile();
        new PrintWriter(commandFile.getAbsolutePath()).close();
    }

    private String getAttributeValue(StartElement startElement, String attributeName) {
        if (null == startElement || null == attributeName) {
            return null;
        }
        Iterator<Attribute> it = startElement.getAttributes();
        while (it.hasNext()) {
            String value;
            Attribute attr = it.next();
            if (!attr.getName().getLocalPart().trim().equalsIgnoreCase(attributeName) || null == (value = attr.getValue())) continue;
            return value.trim();
        }
        return null;
    }

    private String tempFileNameGenerator(String tempDsnPrefix) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("HHmmss.SSS");
        Date now = new Date();
        String strDate = sdfDate.format(now);
        String returnFileName = tempDsnPrefix + ".T" + strDate.substring(0, 6) + ".M" + strDate.substring(7, 10);
        return returnFileName;
    }

    private void createFileWithAttributes(String fileName) throws RcException {
        String fullyQualifiedDsn = ZFile.getFullyQualifiedDSN((String)fileName);
        String targetDD = ZFile.allocDummyDDName();
        ZFile.bpxwdyn((String)("alloc fi(" + targetDD + ") da(" + fullyQualifiedDsn + ") reuse new dsorg(ps) lrecl(120) recfm(f,b) CYL space(1,1) blksize(1200) catalog msg(wtp)"));
        ZFile.bpxwdyn((String)("free fi(" + targetDD + ") msg(wtp)"));
        this.tempDataSetList.add(fullyQualifiedDsn);
    }

    private void readContainerMapperFile() {
        File inputFile = new File(this.containerMapperFilePath);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(inputFile);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("map");
            this.sourceList = new ArrayList<String>();
            this.targetList = new ArrayList<String>();
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Element element;
                Node node1;
                int count;
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                NodeList sourceContainerList = eElement.getElementsByTagName("sourceContainer");
                NodeList targetContainerList = eElement.getElementsByTagName("targetContainer");
                for (count = 0; count < sourceContainerList.getLength(); ++count) {
                    node1 = sourceContainerList.item(count);
                    if (node1.getNodeType() != 1) continue;
                    element = (Element)node1;
                    this.sourceList.add(element.getAttribute("name"));
                }
                for (count = 0; count < targetContainerList.getLength(); ++count) {
                    node1 = targetContainerList.item(count);
                    if (node1.getNodeType() != 1) continue;
                    element = (Element)node1;
                    this.targetList.add(element.getAttribute("name"));
                }
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            System.exit(8);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(8);
        }
        catch (SAXException e) {
            e.printStackTrace();
            System.exit(8);
        }
    }

    private int getFolderSize(Path path) throws IOException {
        final AtomicLong size = new AtomicLong(0L);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                size.addAndGet(attrs.size());
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        int tracks = size.get() <= 56664L ? 1 : (int)Math.ceil((double)size.get() / 56664.0);
        return tracks;
    }

    private void addCommandCheck(BufferedWriter commandWriter) throws IOException {
        commandWriter.append("if [ $? != 0 ] ; then");
        commandWriter.newLine();
        commandWriter.append("exit 99");
        commandWriter.newLine();
        commandWriter.append("fi");
        commandWriter.newLine();
    }

    private void setCopyOptions(String deployType) {
        this.copyType = (deployType = deployType.toUpperCase()).contains(LOAD) ? LOAD : (deployType.contains("DBRM") || deployType.contains("OBJ") ? BINARY : TEXT);
    }

    private void executeTempFile() throws Exception {
        String line;
        int c;
        File workDir = new File(this.componentVersionWorkingDir);
        File tempFile = new File(this.componentVersionWorkingDir + File.separator + TEMP_FILE_NAME);
        String[] cmdArgs = new String[]{"chmod", "+x", tempFile.getAbsolutePath()};
        ProcessBuilder pb = new ProcessBuilder(cmdArgs);
        pb.directory(workDir);
        pb.redirectErrorStream(true);
        Process chmod = pb.start();
        InputStream iStream = chmod.getInputStream();
        while ((c = iStream.read()) != -1) {
            System.out.print((char)c);
        }
        chmod.getOutputStream().close();
        chmod.waitFor();
        int exitCode = -1;
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.directory(workDir);
        processBuilder.command("./deploy_temp.sh");
        Process process = processBuilder.start();
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream(), ENCODING_IBM_1047));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream(), ENCODING_IBM_1047));
        while ((line = stdInput.readLine()) != null) {
            System.out.println(line);
        }
        stdInput.close();
        while ((line = stdError.readLine()) != null) {
            System.out.println(line);
        }
        stdError.close();
        process.waitFor();
        exitCode = process.exitValue();
        if (exitCode > 0) {
            while ((line = stdError.readLine()) != null) {
                System.out.println(line);
            }
            throw new Exception("Copy from Datasets failed with exit code " + exitCode);
        }
    }
}

