/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2020. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
package com.ibm.urbancode.zos.common

class DeploymentConstants {
	//Constants for mapping ruler handle
	def static final MAPPING_RULER_DELIMETER = ",";
	def static final SYSTEM_LINE_SEPARATOR = System.getProperty("line.separator");
	def static final SRC_TO_TARGET_DELIMETER = "\n";
	def static final ENCODING = "IBM-1047";
	def static final ARTIFACT_NOT_FOUND = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
	
	//Constants for copy/ftp/deploy/rollback files or path name 
	def static final CONTAINER_MAPPER_FILE_NAME = "containerMapper.xml";
	def static final CONTAINER_MAPPER_HFS_FILE_NAME = "containerMapperHFS.xml";
	def static final TEMP_FILE_NEW_VERSION = "tempFileNewVersion.xml";
	def static final PACKAGE_FILE_NAME = "package.zip";
    def static final PROCESSED_PACKAGE_FILE_NAME = "processed_package.zip";
	def static final PACKAGE_MANIFEST_FILE_NAME = "packageManifest.xml";
	def static final PACKAGE_MANIFEST_FILE_DEPLOY_NAME = "packageManifest_deploy.xml";
	def static final PACKAGE_MANIFEST_FILE_BACKUP_DEPLOY_NAME = "packageManifest_backup_deploy.xml";
	def static final DEPLOY_CONTAINER_TRACKER = "deployContainerTracker.txt";
	def static final ROLLBACK_MANIFEST_FILE_NAME = "rollbackManifest.xml";
	def static final DEPLOY_DELTA_FILE_NAME = "deltaDeployed.xml";
	def static final DEPLOY_BACKUP_FILE_NAME = "backup.zip";
	def static final ADDITIONAL_FOLDER_FOR_BASE_PATH = "deploy";
	def static final GENERIC_CONTAINER_TYPE = "GENERIC";
	def static final DIRECTORY_CONTAINER_TYPE = "directory";
	def static final FILE_CONTAINER_TYPE = "file";
	def static final PDS_CONTAINER_TYPE = "PDS";
	def static final SEQUANTIAL_CONTAINER_TYPE = "sequential";
	def static final HFS_UNPACK_DIR = "unpacked";
	
	//Constants for check access
	def static final CHECK_ACCESS_DS_FILE_NAME_BACKUP = "dataSetListFile4BackUp";
	def static final CHECK_ACCESS_DS_FILE_NAME = "dataSetListFile";
	def static final CHECK_ACCESS_DS_INPUT_LEADER = "INPUT";
	def static final CHECK_ACCESS_DS_OUTPUT_LEADER = "OUTPUT";
	
	//Constants for exec related
	def static final ZOS_TOOLKIT_EXEC_FOLDER_NAME = "bin";
	def static final ZOS_TOOLKIT_ISPF_SCRIPT_NAME = "startispf.sh";
	def static final CHECK_ACCESS_EXE = "checkaccess";
	def static final ZOS_TOOLKIT_BACKUP_COMMAND = "BUZBKPZP";
	def static final ZOS_TOOLKIT_DEPLOY_COMMAND = "BUZDEPZP";
	def static final ZOS_TOOLKIT_DEPLOY_V2_COMMAND = "BUZDEPV2";
	def static final ZOS_TOOLKIT_ROLLBACK_COMMAND = "BUZDEPZP";
	
	def static final ZOS_TOOLKIT_BUILDER_VERSION = "6.2.0";
	def static final ZOS_TOOLKIT_RUNTIME_MINIMAL_VERSION = "5.0.2";
	def static final ZOS_TOOLKIT_TRACE_ON = false;

}