/*
 * Licensed Materials - Property of IBM* and/or HCL**
 * UrbanCode Deploy
 * UrbanCode Build
 * UrbanCode Release
 * AnthillPro
 * (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
 * (c) Copyright HCL Technologies Ltd. 2020. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 *
 * * Trademark of International Business Machines
 * ** Trademark of HCL Technologies Limited
 */
package com.ibm.urbancode.zos.common


import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

class DeploymentHelper {

    static getStringInput(input) {
        return input?.trim();
    }
    
    //Repository path not located in the component name folder, we need to add this folder on the path
    static getVersionDirPathInRepository(basePath, componentName, versionName) {
        def repobasePathToVersion = basePath + File.separator + componentName + File.separator + versionName;
        return (repobasePathToVersion);
    }
    
    //Verify copy/ftp result
    static verifyGetArtifectResult(filePath, errorInfo) {
        def file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            throw new IOException(errorInfo);
        }
    }
    
    //Working copy default path is located in the component folder
    static getVersionDirPathInWorkingDir(basePath, versionname, resourceId) {
        return (basePath + File.separator + resourceId + File.separator + versionname);
    }

    static inputNotEmptyCheck(input, errorInformation) {
        if (null == input || input.length() <= 0) {
            throw new IllegalArgumentException(errorInformation);
        }
    }

    static getBooleanInput(input) {
        return Boolean.valueOf(input?.trim());
    }
    
    static getFilePathInWorkingDir(basePath, versionname, resourceId, fileName) {
        def pathToFileInWorkDir = getVersionDirPathInWorkingDir(basePath, versionname, resourceId) + File.separator + fileName
        return (pathToFileInWorkDir);
    }


    static getFilePathInRepository(basePath, componentName, versionName, fileName) {
        def patToFileInRepo = getVersionDirPathInRepository(basePath, componentName, versionName) + File.separator + fileName;
        return (patToFileInRepo);
    }
    
    //Clean up after deploy or rollback
    static cleanWorkDir(workdir) {
        def versionWorkingDirectory = new File(workdir);
        if (versionWorkingDirectory.exists() && versionWorkingDirectory.isDirectory()) {
            versionWorkingDirectory.deleteDir();
        }
    }
}
