/*
* Licensed Materials - Property of HCL
* UrbanCode Deploy
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*/
/* This is an example step groovy to show the proper use of APTool
 * In order to use import these utilities, you have to use the "pluginutilscripts" jar
 * that comes bundled with this plugin example.
 */
import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper
import org.apache.log4j.Level
import org.apache.log4j.Logger

/* This gets us the plugin tool helper.
 * This assumes that args[0] is input props file and args[1] is output props file.
 * By default, this is true. If your plugin.xml looks like the example.
 * Any arguments you wish to pass from the plugin.xml to this script that you don't want to
 * pass through the step properties can be accessed using this argument syntax
 */
AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])

/* Here we call getStepProperties() to get a Properties object that contains the step properties
 * provided by the user.
 */
Properties props = apTool.getStepProperties()

/* We acquire the specified log4j level from the input properties and set the root logger level.
 * This will set the logger level for all loggers retrieved in this step.
 * If the logger level specified is invalid, we default to INFO.
 */
String logLevel = props['loggerLevel']
Logger.getRootLogger().setLevel(Level.toLevel(logLevel, Level.INFO))
Logger logger = Logger.getLogger(getClass())

/* This is how you retrieve properties from the object. You provide the "name" attribute of the
 * <property> element
 */
String dirOffset = props['dirOffset']

//example commandHelper
File workDir = new File(".")
CommandHelper ch = new CommandHelper(workDir)
List<String> args = ['fileToExecute', 'arg1', 'arg2']

/* We print a logging statement to list the command being run.
 * A null value can be passed as the message parameter if we would rather log our own message.
 */
logger.info("Executing command: " + args.toString())
ch.runCommand(null, args)

//Set an output property
apTool.setOutputProperty("outPropName", "outPropValue")

//write the output properties to the file
apTool.storeOutputProperties()

