#!/bin/sh
#
# Licensed Materials - Property of IBM and/or HCL
# UrbanCode Deploy
#
# (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
# (c) Copyright HCL Technologies Ltd. 2021. All Rights Reserved.
#
# U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
# GSA ADP Schedule Contract with IBM Corp.
#
##############################################################################
##                                                                          ##
##  Run IIB process for zOS                                                 ##
##                                                                          ##
##############################################################################

#Add jar paths from environment variable CLASSPATH
jarPath=""
if [ -z "$CLASSPATH" ]; then
	echo "[Info] No CLASSPATH found"
	jarPath=$2
else
	echo "[Ok] Found CLASSPATH from system environment: $CLASSPATH."
	jarPath="$2:$CLASSPATH"
fi

if [ -z "$7" ]; then
      echo "[Info] Environment variables file is not passed"
else
	  if [ -r "$7" ]; then
	  	echo "[Info] Setting environment variables from file - $7"
		while IFS='=' read -r pkey pvalue
		do
			first_char=`printf '%s' "$pkey" | cut -c1 `
			if [ $first_char != "#" ]; then
				pvalue=`printf '%s' "$pvalue" | sed -e 's/"$//' | sed -e 's/^"//' `
				echo "[Action] Setting environment variable $pkey=\"$pvalue\""
				export $pkey="$pvalue"
			fi
		done < "$7"
	  else
	  	echo "[Error] Either file $7 does not exist or do not have right permissions"
	  	exit 1
	  fi
fi

if [ -z "$6" ]; then
      echo "[Info] MQSIPROFILE Executable file is not passed"
else
	  if [ -r "$6" ]; then
	  	echo "[Info] Executing MQSIPROFILE - $6"
  		. "$6"
  		if [ $? -ne '0' ]; then 
  			exit $?
	  	fi        
	  else
	  	echo "[Error] Either file $6 does not exist or do not have right permissions"
	  	exit 1
	  fi
fi

echo "${GROOVY_HOME}/bin/groovy $1 $jarPath $3 $4 $5"
exec "${GROOVY_HOME}"/bin/groovy "$1" "$jarPath" "$PLUGIN_HOME"/"$3" "$4" "$5"