/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.urbancode.zos.generate.artifact.info.FilterInputs;
import com.ibm.urbancode.zos.generate.artifact.info.LoopType;
import com.ibm.urbancode.zos.xml.utils.common.DeployedVersion;
import com.ibm.urbancode.zos.xml.utils.deploy.OrderBy;
import com.urbancode.air.plugin.command.MissingInputException;
import com.urbancode.air.plugin.command.MultiGenerateInfoInputs;
import com.urbancode.air.plugin.command.YamlInfoParser;
import java.util.Map;
import java.util.Properties;

class MultiGenerateInfoYamlInputs
implements MultiGenerateInfoInputs {
    public static final String LOOP_TYPE = "loopType";
    public static final String ORDER_BY = "orderBy";
    public static final String FILTERS = "filters";
    public static final String IGNORE_UNRESOLVED = "ignoreUnresolved";
    public static final String DEPLOY_BASE_PATH = "deployBasePath";
    public static final String COMPONENT_NAME = "componentName";
    public static final String VERSION_NAME = "versionName";
    public static final String RESOURCE_ID = "resourceId";
    private final LoopType loopType;
    private final OrderBy orderBy;
    private final String filtersYaml;
    private final boolean ignoreUnresolved;
    private final String componentName;
    private final String versionName;
    private final String resourceId;
    private final DeployedVersion deployedVersion;

    private MultiGenerateInfoYamlInputs(Properties inputProperties) {
        this.loopType = LoopType.valueOf(inputProperties.getProperty(LOOP_TYPE));
        this.orderBy = OrderBy.valueOf(inputProperties.getProperty(ORDER_BY));
        this.filtersYaml = inputProperties.getProperty(FILTERS).trim();
        this.ignoreUnresolved = Boolean.parseBoolean(inputProperties.getProperty(IGNORE_UNRESOLVED));
        this.componentName = inputProperties.getProperty(COMPONENT_NAME).trim();
        this.versionName = inputProperties.getProperty(VERSION_NAME).trim();
        this.resourceId = inputProperties.getProperty(RESOURCE_ID).trim();
        this.deployedVersion = new DeployedVersion(inputProperties);
    }

    public static MultiGenerateInfoYamlInputs getValidatedInputs(Properties inputProperties) {
        MultiGenerateInfoYamlInputs pluginInputs = new MultiGenerateInfoYamlInputs(inputProperties);
        pluginInputs.validateInputs();
        return pluginInputs;
    }

    private void validateInputs() {
        if (this.filtersYaml.isEmpty()) {
            throw new MissingInputException("Filter YAML cannot be empty.");
        }
    }

    @Override
    public LoopType getLoopType() {
        return this.loopType;
    }

    @Override
    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    @Override
    public Map<String, FilterInputs> getCombinedProperties() {
        return YamlInfoParser.parse(this.loopType, this.filtersYaml);
    }

    @Override
    public boolean isIgnoreUnresolved() {
        return this.ignoreUnresolved;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public String getVersionName() {
        return this.versionName;
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    public DeployedVersion getDeployedVersion() {
        return this.deployedVersion;
    }

    public String getFiltersYaml() {
        return this.filtersYaml;
    }
}

