/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.urbancode.zos.generate.artifact.info.FilterInputs;
import com.ibm.urbancode.zos.generate.artifact.info.LoopType;
import com.ibm.urbancode.zos.xml.utils.common.DeployedVersion;
import com.ibm.urbancode.zos.xml.utils.deploy.OrderBy;
import com.urbancode.air.plugin.command.JsonInfoParser;
import com.urbancode.air.plugin.command.MissingInputException;
import com.urbancode.air.plugin.command.MultiGenerateInfoInputs;
import java.util.Map;
import java.util.Properties;

class MultiGenerateInfoJsonInputs
implements MultiGenerateInfoInputs {
    public static final String LOOP_TYPE = "loopType";
    public static final String ORDER_BY = "orderBy";
    public static final String DEPLOY_TYPE_NAME = "deployTypeName";
    public static final String SRC_DATASET_NAME = "srcDatasetName";
    public static final String DATASET_NAME = "datasetName";
    public static final String MEMBER_NAME = "memberName";
    public static final String CUST_PROPERTIES = "custProperties";
    public static final String TEMPLATE_TEXT = "templateText";
    public static final String IGNORE_UNRESOLVED = "ignoreUnresolved";
    public static final String DEPLOY_ACTION = "deployAction";
    public static final String DEPLOY_BASE_PATH = "deployBasePath";
    public static final String COMPONENT_NAME = "componentName";
    public static final String VERSION_NAME = "versionName";
    public static final String RESOURCE_ID = "resourceId";
    private final LoopType loopType;
    private final OrderBy orderBy;
    private final String deployTypeJSON;
    private final String sourceDatasetJSON;
    private final String targetDatasetJSON;
    private final String memberJSON;
    private final String customPropertiesJSON;
    private final String templateJSON;
    private final boolean ignoreUnresolved;
    private final String deployActionJSON;
    private final String componentName;
    private final String versionName;
    private final String resourceId;
    private final DeployedVersion deployedVersion;

    private MultiGenerateInfoJsonInputs(Properties inputProperties) {
        this.loopType = LoopType.valueOf(inputProperties.getProperty(LOOP_TYPE));
        this.orderBy = OrderBy.valueOf(inputProperties.getProperty(ORDER_BY));
        this.sourceDatasetJSON = inputProperties.getProperty(SRC_DATASET_NAME).trim();
        this.targetDatasetJSON = inputProperties.getProperty(DATASET_NAME).trim();
        this.memberJSON = inputProperties.getProperty(MEMBER_NAME).trim();
        this.deployTypeJSON = inputProperties.getProperty(DEPLOY_TYPE_NAME).trim();
        this.customPropertiesJSON = inputProperties.getProperty(CUST_PROPERTIES).trim();
        this.templateJSON = inputProperties.getProperty(TEMPLATE_TEXT).trim();
        this.ignoreUnresolved = Boolean.parseBoolean(inputProperties.getProperty(IGNORE_UNRESOLVED));
        this.deployActionJSON = inputProperties.getProperty(DEPLOY_ACTION).trim();
        this.componentName = inputProperties.getProperty(COMPONENT_NAME).trim();
        this.versionName = inputProperties.getProperty(VERSION_NAME).trim();
        this.resourceId = inputProperties.getProperty(RESOURCE_ID).trim();
        this.deployedVersion = new DeployedVersion(inputProperties);
    }

    public static MultiGenerateInfoJsonInputs getValidatedInputs(Properties inputProperties) {
        MultiGenerateInfoJsonInputs pluginInputs = new MultiGenerateInfoJsonInputs(inputProperties);
        pluginInputs.validateInputs();
        return pluginInputs;
    }

    private void validateInputs() {
        boolean isLoopTypeNeitherSequentialNorMember;
        if (this.templateJSON.isEmpty()) {
            throw new MissingInputException("Template JSON cannot be empty.");
        }
        boolean bl = isLoopTypeNeitherSequentialNorMember = this.loopType != LoopType.Sequential && this.loopType != LoopType.Member;
        if (!this.deployActionJSON.isEmpty() && isLoopTypeNeitherSequentialNorMember) {
            throw new IllegalArgumentException("Unsupported Loop Type '" + (Object)((Object)this.loopType) + "' found with deployment action. Deployment Action is supported for Loop Types - 'Sequential' or 'PDS Member'");
        }
        if (!this.targetDatasetJSON.isEmpty() && !LoopType.isDatasetLevel(this.loopType)) {
            throw new IllegalArgumentException("Target Dataset Filter JSON is applicable for only dataset/member loop types.");
        }
    }

    @Override
    public LoopType getLoopType() {
        return this.loopType;
    }

    @Override
    public OrderBy getOrderBy() {
        return this.orderBy;
    }

    @Override
    public Map<String, FilterInputs> getCombinedProperties() {
        return new JsonInfoParser(this).parse();
    }

    public String getDeployTypeJSON() {
        return this.deployTypeJSON;
    }

    public String getSourceDatasetJSON() {
        return this.sourceDatasetJSON;
    }

    public String getTargetDatasetJSON() {
        return this.targetDatasetJSON;
    }

    public String getMemberJSON() {
        return this.memberJSON;
    }

    public String getCustomPropertiesJSON() {
        return this.customPropertiesJSON;
    }

    public String getTemplateJSON() {
        return this.templateJSON;
    }

    @Override
    public boolean isIgnoreUnresolved() {
        return this.ignoreUnresolved;
    }

    public String getDeployActionJSON() {
        return this.deployActionJSON;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public String getVersionName() {
        return this.versionName;
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    public DeployedVersion getDeployedVersion() {
        return this.deployedVersion;
    }
}

