/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.urbancode.zos.generate.artifact.info.DeploymentAction;
import com.ibm.urbancode.zos.generate.artifact.info.FilterInputs;
import com.ibm.urbancode.zos.generate.artifact.info.LoopType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.yaml.snakeyaml.Yaml;

public class YamlInfoParser {
    private static final String TEMPLATE = "template";
    private static final String SOURCE_CONTAINER = "sourceContainer";
    private static final String TARGET_CONTAINER = "targetContainer";
    private static final String RESOURCE = "resource";
    private static final String DEPLOY_TYPE = "deployType";
    private static final String DEPLOY_ACTION = "deployAction";
    private static final String CUSTOM_PROPERTIES = "customProperties";
    private static final Set<String> VALID_YAML_KEYS = Stream.of("template", "sourceContainer", "targetContainer", "resource", "deployType", "deployAction", "customProperties").collect(Collectors.toSet());

    static Map<String, FilterInputs> parse(LoopType loopType, String yamlFilters) {
        Map<String, Object> yamlMap = YamlInfoParser.getYamlMap(yamlFilters);
        HashMap<String, FilterInputs> propertyFilterMap = new HashMap<String, FilterInputs>();
        for (Map.Entry<String, Object> entry : yamlMap.entrySet()) {
            String propertyName = entry.getKey();
            Map<String, Object> propertyKeyValuePairs = YamlInfoParser.getPropertyKeyValuePairs(entry);
            YamlInfoParser.validateAttributes(propertyKeyValuePairs, propertyName);
            FilterInputs filterInputs = YamlInfoParser.getFilterInputs(loopType, propertyKeyValuePairs, propertyName);
            propertyFilterMap.put(propertyName, filterInputs);
        }
        return propertyFilterMap;
    }

    private static Map<String, Object> getYamlMap(String yamlFilters) {
        try {
            Yaml yaml = new Yaml();
            return (Map)yaml.load(yamlFilters);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to load YAML filters - " + e.getMessage());
        }
    }

    private static Map<String, Object> getPropertyKeyValuePairs(Map.Entry<String, Object> entry) {
        try {
            return (Map)entry.getValue();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to read key-value pairs for property '" + entry.getKey() + "'");
        }
    }

    private static void validateAttributes(Map<String, Object> propertyConfigs, String propertyName) {
        Set<String> propertyKeys = propertyConfigs.keySet();
        for (String key : propertyKeys) {
            if (VALID_YAML_KEYS.contains(key)) continue;
            throw new IllegalArgumentException("Key '" + key + "' for property '" + propertyName + "' is either incorrect or unsupported. Valid keys are " + VALID_YAML_KEYS);
        }
    }

    private static FilterInputs getFilterInputs(LoopType loopType, Map<String, Object> propertyKeyValuePairs, String propertyName) {
        YamlInfoParser.validateTemplate(propertyKeyValuePairs, propertyName);
        String templateValue = propertyKeyValuePairs.get(TEMPLATE).toString();
        FilterInputs filterInputs = new FilterInputs(loopType, templateValue);
        filterInputs.setSourceContainer(propertyKeyValuePairs.getOrDefault(SOURCE_CONTAINER, "").toString());
        filterInputs.setTargetDataset(propertyKeyValuePairs.getOrDefault(TARGET_CONTAINER, "").toString());
        filterInputs.setResource(propertyKeyValuePairs.getOrDefault(RESOURCE, "").toString());
        filterInputs.setDeployType(propertyKeyValuePairs.getOrDefault(DEPLOY_TYPE, "").toString());
        if (propertyKeyValuePairs.containsKey(CUSTOM_PROPERTIES)) {
            Map<String, String> customerProperties = YamlInfoParser.getCustomerProperties(propertyKeyValuePairs, propertyName);
            filterInputs.setCustomProperties(customerProperties);
        }
        if (propertyKeyValuePairs.containsKey(DEPLOY_ACTION)) {
            String deployAction = propertyKeyValuePairs.get(DEPLOY_ACTION).toString();
            DeploymentAction deploymentAction = YamlInfoParser.getDeploymentAction(deployAction, propertyName);
            filterInputs.setDeploymentAction(deploymentAction);
        }
        return filterInputs;
    }

    private static void validateTemplate(Map<String, Object> propertyConfigs, String propertyName) {
        if (!propertyConfigs.containsKey(TEMPLATE)) {
            throw new IllegalArgumentException("Mandatory key 'template' not found for property '" + propertyName + "'");
        }
        if (propertyConfigs.get(TEMPLATE).toString().trim().isEmpty()) {
            throw new IllegalArgumentException("Template value is blank for property '" + propertyName + "'");
        }
    }

    private static Map<String, String> getCustomerProperties(Map<String, Object> propertyKeyValuePairs, String propertyName) {
        try {
            return (Map)propertyKeyValuePairs.get(CUSTOM_PROPERTIES);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to read 'custom properties' as key-value pairs for property '" + propertyName + "'");
        }
    }

    private static DeploymentAction getDeploymentAction(String deployAction, String propertyName) {
        try {
            return DeploymentAction.valueOf(deployAction.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("ERROR: Invalid value '" + deployAction + "' has been assigned to property '" + propertyName + "' in 'deployAction' input. Action value can be either 'created' or 'updated'.");
        }
    }
}

