/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.ibm.urbancode.zos.generate.artifact.info.ArtifactInfo;
import com.ibm.urbancode.zos.generate.artifact.info.FilterInputs;
import com.ibm.urbancode.zos.generate.artifact.info.LoopType;
import com.ibm.urbancode.zos.generate.artifact.info.utils.ServerManifest;
import com.ibm.urbancode.zos.xml.utils.common.DeployedVersion;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackManifest;
import com.urbancode.air.plugin.command.MultiGenerateInfoInputs;
import com.urbancode.air.plugin.command.Printer;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;

public class MultiGenerateArtifactInfo {
    public static final int ERR_CODE = 1;
    private static final String PRESENT_WORKING_DIRECTORY = ".";
    private static final String PACKAGE_MANIFEST_FILE_NAME = "packageManifest.xml";
    private final MultiGenerateInfoInputs pluginInputs;
    private final Properties outputProperties;
    private Map<String, FilterInputs> combinedProperties;

    public MultiGenerateArtifactInfo(MultiGenerateInfoInputs pluginInputs, Properties outputProperties) {
        this.pluginInputs = pluginInputs;
        this.outputProperties = outputProperties;
    }

    public void generateArtifactInfo(MultiGenerateInfoInputs pluginInputs) throws Exception {
        this.combinedProperties = pluginInputs.getCombinedProperties();
        DeployedVersion deployedVersion = pluginInputs.getDeployedVersion();
        if (!deployedVersion.exist()) {
            this.ignoreTargetDatasetIfExist();
            this.ignoreDeployActionIfExist();
        }
        PackageManifest packageManifest = this.getPackageManifest().sort(pluginInputs.getOrderBy());
        Optional<RollbackManifest> rollbackManifest = this.getRollbackManifest();
        for (Map.Entry<String, FilterInputs> entry : this.combinedProperties.entrySet()) {
            Printer.printHeader(entry.getKey());
            ArtifactInfo artifactInfo = rollbackManifest.isPresent() ? ArtifactInfo.generate(entry.getValue(), packageManifest, rollbackManifest.get()) : ArtifactInfo.generate(entry.getValue(), packageManifest);
            if (!pluginInputs.isIgnoreUnresolved()) {
                ArtifactInfo.checkForUnresolvedProperty(artifactInfo.getText());
            }
            String generatedText = StringUtils.chomp(artifactInfo.getText());
            Printer.printGeneratedTextToConsole(generatedText);
            this.outputProperties.setProperty(entry.getKey(), generatedText);
            String count = Long.toString(artifactInfo.getCount());
            this.outputProperties.setProperty(entry.getKey() + "-count", count);
        }
    }

    private PackageManifest getPackageManifest() throws Exception {
        DeployedVersion deployedVersion = this.pluginInputs.getDeployedVersion();
        if (deployedVersion.exist()) {
            return deployedVersion.getPackageManifest();
        }
        return ServerManifest.from(this.pluginInputs);
    }

    private Optional<RollbackManifest> getRollbackManifest() throws XMLStreamException, IOException {
        if (this.isRollbackManifestOperationsNeeded()) {
            DeployedVersion deployedVersion = this.pluginInputs.getDeployedVersion();
            return Optional.of(deployedVersion.getRollbackManifest());
        }
        return Optional.empty();
    }

    private boolean isRollbackManifestOperationsNeeded() {
        if (this.isDeployActionPassed()) {
            return true;
        }
        return this.pluginInputs.getLoopType() == LoopType.DeletedMemberExcludingMissingMembers;
    }

    private String getVersionWorkingDir() throws IOException {
        String basePath = new File(PRESENT_WORKING_DIRECTORY).getCanonicalPath();
        return basePath + File.separator + this.pluginInputs.getResourceId() + File.separator + this.pluginInputs.getVersionName();
    }

    private String getManifestFilePath() throws IOException {
        return this.getVersionWorkingDir() + File.separator + PACKAGE_MANIFEST_FILE_NAME;
    }

    private void ignoreTargetDatasetIfExist() {
        this.combinedProperties.values().forEach(filterInputs -> {
            if (!filterInputs.getTargetDataset().isEmpty()) {
                System.out.println("Warning: Target Dataset Name Filter ignored because version " + this.pluginInputs.getVersionName() + " is not deployed");
                filterInputs.setTargetDataset("");
            }
        });
    }

    private void ignoreDeployActionIfExist() {
        this.combinedProperties.values().forEach(filterInputs -> {
            if (filterInputs.getDeploymentAction() != null) {
                System.out.println("Warning: Deployment Action Filter ignored because version " + this.pluginInputs.getVersionName() + " is not deployed");
                filterInputs.setDeploymentAction(null);
            }
        });
    }

    private boolean isDeployActionPassed() {
        return this.combinedProperties.values().stream().anyMatch(filterInputs -> filterInputs.getDeploymentAction() != null);
    }
}

