/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;

public class LocalNetworkResourceResolver {
    private static long lastLocalIpQuery = 0L;
    private static String[] latestLocalIpArray = new String[0];

    public static String[] getLocalIpArray() throws SocketException {
        String[] result = null;
        if (System.currentTimeMillis() - lastLocalIpQuery > 900000L) {
            ArrayList<String> resultList = new ArrayList<String>();
            NetworkInterface iface = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                iface = ifaces.nextElement();
                InetAddress iaddress = null;
                Enumeration<InetAddress> ips = iface.getInetAddresses();
                while (ips.hasMoreElements()) {
                    iaddress = ips.nextElement();
                    String ip = iaddress.getHostAddress();
                    if (ip == null || ip.indexOf(58) != -1 || "127.0.0.1".equals(ip)) continue;
                    resultList.add(ip.trim());
                }
            }
            resultList.add("0.0.0.0");
            result = new String[resultList.size()];
            resultList.toArray(result);
            lastLocalIpQuery = new Date().getTime();
            latestLocalIpArray = result;
        } else {
            result = latestLocalIpArray;
        }
        return result;
    }

    public static boolean isAddressLocal(InetAddress address) {
        boolean result = false;
        if (address != null) {
            String ip = address.getHostAddress();
            String[] localIpArray = new String[]{};
            try {
                localIpArray = LocalNetworkResourceResolver.getLocalIpArray();
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            if ("localhost".equals(ip) || "127.0.0.1".equals(ip)) {
                result = true;
            } else {
                for (String element : localIpArray) {
                    if (!element.trim().equals(ip)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }
}

