/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.crypto.algs.hash;

import com.urbancode.commons.util.crypto.algs.hash.AbstractHashAlgorithm;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PBKDF2WithHmacSHA1Alg
extends AbstractHashAlgorithm {
    private static final int SALT_LENGTH = SALT_160_bit;
    private static final int DEFAULT_ROUNDS = Integer.getInteger("com.urbancode.commons.util.crypto.algs.hash.PBKDF2WithHmacSHA1Alg.ROUNDS", 40960);
    private static final int DEFAULT_BIT_LEN = Integer.getInteger("com.urbancode.commons.util.crypto.algs.hash.PBKDF2WithHmacSHA1Alg.BIT_LEN", 160);
    private static final char SEPARATOR_CHAR = '|';
    private static final String KEY_ALG = "PBKDF2WithHmacSHA1";
    int rounds = DEFAULT_ROUNDS;
    int bitLen = DEFAULT_BIT_LEN;

    @Override
    public String getAlgPrefix() {
        return "pbkdf2";
    }

    @Override
    public boolean isSupported() {
        try {
            SecretKeyFactory f = this.getKeyFactory();
            return f != null;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
        catch (NoSuchProviderException e) {
            return false;
        }
    }

    @Override
    public String encode(String value) throws GeneralSecurityException {
        return this.encode0(value);
    }

    @Override
    public boolean validate(String plainText, String cipherText) throws GeneralSecurityException {
        int saltEnd = cipherText.indexOf(124);
        int roundEnd = cipherText.indexOf(124, saltEnd + 1);
        String salt64 = cipherText.substring(0, saltEnd);
        byte[] salt = this.decodeBase64(salt64);
        int rounds = Integer.valueOf(cipherText.substring(saltEnd + 1, roundEnd));
        String hash64 = cipherText.substring(roundEnd + 1);
        byte[] hash = this.decodeBase64(hash64);
        int bitLen = hash.length * 8;
        String encoded = this.encode0(salt, rounds, bitLen, plainText);
        return this.secureEquals(encoded, cipherText);
    }

    @Override
    public boolean shouldReencode(String cipherText) throws GeneralSecurityException {
        int roundEnd;
        int saltEnd = cipherText.indexOf(124);
        int rounds = Integer.valueOf(cipherText.substring(saltEnd + 1, roundEnd = cipherText.indexOf(124, saltEnd + 1)));
        return rounds < this.rounds;
    }

    public void setRounds(int rounds) {
        this.rounds = rounds;
    }

    public int getRounds() {
        return this.rounds;
    }

    public void setBitLen(int bitLen) {
        this.bitLen = bitLen;
    }

    public int getBitLen() {
        return this.bitLen;
    }

    protected String encode0(String value) throws GeneralSecurityException {
        String result;
        if (value != null) {
            byte[] salt = this.randomSalt(SALT_LENGTH);
            result = this.encode0(salt, this.rounds, this.bitLen, value);
        } else {
            result = null;
        }
        return result;
    }

    protected String encode0(byte[] salt, int rounds, int bitLen, String value) throws GeneralSecurityException {
        String result;
        if (value != null) {
            char[] data = value.toCharArray();
            if (data.length == 0) {
                data = new char[]{'\u0000'};
            }
            SecretKeyFactory f = this.getKeyFactory();
            PBEKeySpec ks = new PBEKeySpec(data, salt, rounds, bitLen);
            SecretKey s = f.generateSecret(ks);
            byte[] hash = s.getEncoded();
            result = this.encodeBase64String(salt) + '|' + rounds + '|' + this.encodeBase64String(hash);
        } else {
            result = null;
        }
        return result;
    }

    protected SecretKeyFactory getKeyFactory() throws NoSuchAlgorithmException, NoSuchProviderException {
        SecretKeyFactory f = SecretKeyFactory.getInstance(KEY_ALG);
        return f;
    }
}

