/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.iterator;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.iterator.ArrayAccessor;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public final class ArrayIterator<T>
implements ListIterator<T> {
    private final ArrayAccessor<T> accessor;
    private int index;
    private int lastIndex = -1;

    public static <T> ArrayIterator<T> get(Object array) {
        return new ArrayIterator(ArrayAccessor.get(array));
    }

    private ArrayIterator(ArrayAccessor<T> accessor) {
        this.accessor = Check.nonNull(accessor, "accessor");
    }

    @Override
    public boolean hasNext() {
        return this.index < this.accessor.length();
    }

    @Override
    public T next() {
        try {
            T result = this.accessor.get(this.index);
            this.lastIndex = this.index++;
            return result;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void add(T o) {
        throw new UnsupportedOperationException("add");
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public T previous() {
        int prevIndex = this.index - 1;
        try {
            T result = this.accessor.get(prevIndex);
            this.lastIndex = this.index = prevIndex;
            return result;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public void set(T v) {
        this.accessor.set(this.lastIndex, v);
    }
}

