/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.authentication;

import com.urbancode.commons.web.WebException;
import com.urbancode.security.SecurityManager;
import com.urbancode.security.SecurityUser;
import com.urbancode.security.authentication.AuthenticationException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public abstract class AbstractCookieAuthenticator {
    protected static Logger logger = Logger.getLogger(AbstractCookieAuthenticator.class);

    public SecurityUser authenticate(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        SecurityUser result = null;
        String cookieValue = this.getValue(request);
        if (cookieValue != null) {
            try {
                String[] loginAndPassword = this.getLoginAndPassword(cookieValue);
                if (loginAndPassword != null) {
                    result = SecurityManager.getInstance().getAuthenticator().authenticate((Object)request, loginAndPassword[0], loginAndPassword[1]);
                } else {
                    this.delete(request, response);
                }
            }
            catch (AuthenticationException e) {
                this.delete(request, response);
                throw e;
            }
            catch (WebException e) {
                this.delete(request, response);
                throw new AuthenticationException("Login cookie processing", (Throwable)e);
            }
        }
        return result;
    }

    public void store(String login, String password, HttpServletRequest request, HttpServletResponse response) throws WebException {
        String cookieValue = this.createCookieValue(login, password);
        Cookie rememberMeCookie = new Cookie(this.getCookieName(request), cookieValue);
        rememberMeCookie.setPath("/");
        rememberMeCookie.setMaxAge(Integer.MAX_VALUE);
        response.addCookie(rememberMeCookie);
    }

    public void delete(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(this.getCookieName(request))) continue;
                cookie.setMaxAge(0);
                cookie.setPath("/");
                response.addCookie(cookie);
            }
        }
    }

    protected String getValue(HttpServletRequest request) {
        String cookieName = this.getCookieName(request);
        String result = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                result = cookie.getValue();
                break;
            }
        }
        return result;
    }

    protected String getCookieName(HttpServletRequest request) {
        return (request.getSession().getServletContext().getServletContextName() + "LoginCookie").replaceAll(" ", "");
    }

    protected abstract String[] getLoginAndPassword(String var1) throws WebException;

    abstract String createCookieValue(String var1, String var2) throws WebException;
}

