/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.v2;

import com.ibm.team.enterprise.automation.CpDataset;
import com.ibm.team.enterprise.automation.ScriptFileGenerator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;

final class V2ScriptFileGenerator
extends ScriptFileGenerator {
    private final String zipName;

    private V2ScriptFileGenerator(String workDirPath, List<CpDataset> cpDatasets, String zipName) {
        super(workDirPath, cpDatasets);
        this.zipName = zipName;
    }

    public static File generate(String workDirPath, List<CpDataset> cpDatasets, String zipName) throws Exception {
        V2ScriptFileGenerator scriptFileGenerator = new V2ScriptFileGenerator(workDirPath, cpDatasets, zipName);
        return ((ScriptFileGenerator)scriptFileGenerator).generateFile();
    }

    @Override
    public File generateFile() throws Exception {
        File directory = new File(this.workDirPath);
        File tempScriptFile = this.createTempScriptFile(directory);
        this.writeScriptStatementsToFile(tempScriptFile);
        return tempScriptFile;
    }

    private void writeScriptStatementsToFile(File tempFile) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(tempFile));){
            bufferedWriter.append("#!/bin/sh");
            bufferedWriter.newLine();
            this.writeCpCommands(bufferedWriter);
            this.writeZipCommand(bufferedWriter);
        }
    }

    private void writeCpCommands(BufferedWriter bufferedWriter) throws IOException {
        for (CpDataset cpDataset : this.cpDatasets) {
            if (cpDataset.getDsType().equals("PDS")) {
                this.writeCpCommandForPdsDataset(bufferedWriter, cpDataset);
                continue;
            }
            this.writeCpCommandForSequentialDataset(bufferedWriter, cpDataset);
        }
    }

    private void writeZipCommand(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.append("tar -cf ").append(this.zipName);
        for (CpDataset cpDataset : this.cpDatasets) {
            bufferedWriter.append(" ").append("'").append(cpDataset.getName()).append("'");
        }
        this.addCommandCheck(bufferedWriter);
    }

    private void writeCpCommandForPdsDataset(BufferedWriter bufferedWriter, CpDataset cpDataset) throws IOException {
        if (cpDataset.getMembers().isEmpty()) {
            System.out.println(" [INFO] Dataset " + cpDataset.getName() + " is an empty PDS.");
            return;
        }
        String pdsDir = this.workDirPath + File.separator + cpDataset.getName();
        if (!new File(pdsDir).mkdir()) {
            throw new RuntimeException("Failed to create directory " + pdsDir);
        }
        for (String member : cpDataset.getMembers()) {
            String cpCommand = this.getCpCommand(cpDataset.getName() + "(" + member + ")", Paths.get(pdsDir, new String[0]).resolve(member).toString(), cpDataset.getCpOption());
            bufferedWriter.append(cpCommand);
            this.addCommandCheck(bufferedWriter);
        }
    }

    private void writeCpCommandForSequentialDataset(BufferedWriter bufferedWriter, CpDataset cpDataset) throws IOException {
        String cpCommand = this.getCpCommand(cpDataset.getName(), Paths.get(this.workDirPath, new String[0]).resolve(cpDataset.getName()).toString(), cpDataset.getCpOption());
        bufferedWriter.append(cpCommand);
        this.addCommandCheck(bufferedWriter);
    }
}

