/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.securedata.crypto;

import com.urbancode.air.securedata.crypto.CipherAlgorithm2;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

abstract class CipherAlgorithmAES
implements CipherAlgorithm2 {
    private static final String ALGORITHM = "AES";
    private static final String MODE = "CBC";
    private static final String PADDING = "PKCS5Padding";

    CipherAlgorithmAES() throws GeneralSecurityException {
        this.testAlgorithms();
    }

    public String toString() {
        return this.getName();
    }

    public int getInitializationVectorLength() {
        return 16;
    }

    public String getJavaName() {
        return "AES/CBC/PKCS5Padding";
    }

    public Cipher createCipher(SecretKey key, byte[] initializationVector, int mode) {
        try {
            Cipher cipher = Cipher.getInstance(this.getJavaName());
            cipher.init(mode, (Key)key, new IvParameterSpec(initializationVector));
            return cipher;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] createInitializationVector(SecureRandom r) {
        byte[] b = this.createIVArray();
        r.nextBytes(b);
        return b;
    }

    public SecretKey createKey(byte[] keyBytes) {
        return new SecretKeySpec(keyBytes, ALGORITHM);
    }

    protected void testAlgorithms() throws GeneralSecurityException {
        SecretKey key = this.createKey(new byte[this.getKeyLength()]);
        Cipher cipher = Cipher.getInstance(this.getJavaName());
        cipher.init(1, (Key)key, new IvParameterSpec(this.createIVArray()));
    }

    private byte[] createIVArray() {
        return new byte[this.getInitializationVectorLength()];
    }
}

