/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import com.urbancode.commons.fileutils.filelister.FileLister;
import com.urbancode.commons.fileutils.filelister.TypedFile;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.http.entity.AbstractHttpEntity;

public class ZipRequestEntity
extends AbstractHttpEntity {
    private FileLister lister;

    public ZipRequestEntity(FileLister lister) {
        this.lister = lister;
        this.setContentType("application/zip");
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean isRepeatable() {
        return true;
    }

    public void writeTo(OutputStream requestOutput) throws IOException {
        ZipOutputStream zipOutput = new ZipOutputStream(requestOutput);
        this.writeAllFilesToStream(zipOutput);
        zipOutput.flush();
        zipOutput.close();
    }

    private void writeAllFilesToStream(ZipOutputStream zipOutput) throws IOException, FileNotFoundException {
        for (TypedFile typedFile : this.lister.list()) {
            this.addZipEntryForFile(zipOutput, typedFile);
        }
    }

    private void addZipEntryForFile(ZipOutputStream zipOutput, TypedFile typedFile) throws FileNotFoundException, IOException {
        String filePath = typedFile.path();
        File base = this.lister.base();
        File file = new File(base, filePath);
        zipOutput.putNextEntry(this.getZipEntry(filePath, file));
        this.writeFileToStream(zipOutput, file);
        zipOutput.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileToStream(ZipOutputStream zipOutput, File file) throws FileNotFoundException, IOException {
        FileInputStream fileInput = null;
        try {
            int len;
            fileInput = new FileInputStream(file);
            byte[] buf = new byte[1024];
            while ((len = fileInput.read(buf)) > 0) {
                zipOutput.write(buf, 0, len);
            }
        }
        catch (Throwable throwable) {
            IO.close(fileInput);
            throw throwable;
        }
        IO.close(fileInput);
    }

    private ZipEntry getZipEntry(String filePath, File file) {
        ZipEntry entry = new ZipEntry(filePath);
        entry.setTime(file.lastModified());
        entry.setSize(file.length());
        return entry;
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public boolean isStreaming() {
        return false;
    }
}

