/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.ibm.urbancode.zos.deploy.common.DataSet;
import com.ibm.urbancode.zos.deploy.common.DeploymentHelper;
import com.ibm.urbancode.zos.deploy.common.DeploymentResultHelper;
import com.ibm.urbancode.zos.deploy.common.Inputs;
import com.ibm.urbancode.zos.deploy.common.Member;
import com.urbancode.commons.util.ssl.XTrustProvider;
import com.urbancode.ud.client.VersionClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MultiGenerateArtifactInfo {
    private Properties inputProperties;
    private Properties outputProperties;
    private final LinkedHashSet<String> containerLevels = new LinkedHashSet();
    private final LinkedHashSet<String> resourceLevels = new LinkedHashSet();

    public MultiGenerateArtifactInfo(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws IOException, Exception {
        TreeSet<DataSet> containersSet;
        File workDir = new File(".");
        String loopTypeIn = DeploymentHelper.getStringInput((String)this.inputProperties.getProperty("loopType"));
        String orderByIn = DeploymentHelper.getStringInput((String)this.inputProperties.getProperty("orderBy"));
        String deployTypeNameIn = DeploymentHelper.getStringInput((String)this.inputProperties.getProperty("deployTypeName"));
        String srcDatasetNameIn = DeploymentHelper.getStringInput((String)this.inputProperties.getProperty("srcDatasetName"));
        String targetDatasetNameIn = DeploymentHelper.getStringInput((String)this.inputProperties.getProperty("datasetName"));
        String memberNameIn = DeploymentHelper.getStringInput((String)this.inputProperties.getProperty("memberName"));
        String custPropertiesIn = DeploymentHelper.getStringInput((String)this.inputProperties.getProperty("custProperties"));
        String templateIn = DeploymentHelper.getStringInput((String)this.inputProperties.getProperty("templateText"));
        boolean ignoreUnresolved = DeploymentHelper.getBooleanInput((String)this.inputProperties.getProperty("ignoreUnresolved"));
        String deployBasePath = DeploymentHelper.getStringInput((String)this.inputProperties.getProperty("deployBasePath"));
        String componentName = DeploymentHelper.getStringInput((String)this.inputProperties.getProperty("componentName"));
        String versionName = DeploymentHelper.getStringInput((String)this.inputProperties.getProperty("versionName"));
        String resourceId = DeploymentHelper.getStringInput((String)this.inputProperties.getProperty("resourceId"));
        if (MultiGenerateArtifactInfo.isNullOrEmpty(componentName)) {
            System.out.println("ERROR: Component Name must be set.");
            System.exit(1);
        }
        if (MultiGenerateArtifactInfo.isNullOrEmpty(deployBasePath)) {
            System.out.println("ERROR: Deploy Base Path must be set.");
            System.exit(1);
        }
        if (MultiGenerateArtifactInfo.isNullOrEmpty(versionName)) {
            System.out.println("ERROR: Version Name must be set.");
            System.exit(1);
        }
        DeploymentHelper.inputNotEmptyCheck((String)resourceId, (String)"Resource Id is empty.");
        if (MultiGenerateArtifactInfo.isNullOrEmpty(orderByIn)) {
            orderByIn = "ASC";
        }
        if (DeploymentResultHelper.checkVersionDeployed((String)deployBasePath, (String)resourceId, (String)componentName, (String)versionName)) {
            containersSet = DeploymentResultHelper.getDeployedDataSets((String)deployBasePath, (String)resourceId, (String)componentName, (String)versionName);
        } else {
            String udUser = "PasswordIsAuthToken";
            String udPass = "{\"token\" : \"" + System.getenv("AUTH_TOKEN") + "\"}";
            String weburl = System.getenv("AH_WEB_URL");
            VersionClient envClient = new VersionClient(new URI(weburl), udUser, udPass);
            XTrustProvider.install();
            String versionWorkingDir = DeploymentHelper.getVersionDirPathInWorkingDir((String)workDir.getCanonicalPath(), (String)versionName, (String)resourceId);
            String versionManifestPath = DeploymentHelper.getFilePathInWorkingDir((String)workDir.getCanonicalPath(), (String)versionName, (String)resourceId, (String)"packageManifest.xml");
            PrintStream oriOut = System.out;
            System.setOut(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                }
            }));
            try {
                envClient.downloadFiles(componentName, versionName, versionWorkingDir, "packageManifest.xml");
            }
            catch (Exception e) {
                System.setOut(oriOut);
                System.out.println("Failed to locate metadata for version.");
                System.out.println("Generate artifact information works for deployed versions or versions created with UCD 6.1.1.6 and later.");
                System.exit(1);
            }
            finally {
                System.setOut(oriOut);
            }
            containersSet = DeploymentResultHelper.getNotDeployedDataSets((String)versionManifestPath);
            if (!targetDatasetNameIn.isEmpty()) {
                System.out.println("Warning: Target Data Set Name Filter ignored because version " + versionName + " is not deployed");
                targetDatasetNameIn = "";
            }
        }
        if (orderByIn.equals("ASC")) {
            containersSet = new TreeSet(containersSet);
        } else if (orderByIn.equals("DESC")) {
            containersSet = new TreeSet(containersSet).descendingSet();
        }
        Collections.addAll(this.containerLevels, "PDS", "DeletedPDS", "Sequential", "DeletedSequential");
        Collections.addAll(this.resourceLevels, "Member", "DeletedMember");
        HashMap<String, List<String>> combinedProperties = MultiGenerateArtifactInfo.combineJsonObjects(templateIn, deployTypeNameIn, srcDatasetNameIn, targetDatasetNameIn, memberNameIn, custPropertiesIn);
        for (Map.Entry entry : combinedProperties.entrySet()) {
            String propName = (String)entry.getKey();
            List params = (List)entry.getValue();
            this.processProperty(propName, params, containersSet, loopTypeIn, orderByIn, ignoreUnresolved);
        }
        return 0;
    }

    public void processProperty(String propertyName, List<String> parmList, Set<DataSet> containers, String loopType, String orderBy, boolean ignoreUnresolved) throws IOException {
        String template = parmList.get(0);
        String srcDatasetName = parmList.get(1);
        String targetDatasetName = parmList.get(2);
        String memberName = parmList.get(3);
        String deployTypeName = parmList.get(4);
        String customProperties = parmList.get(5);
        HashMap<String, String> properties = new HashMap<String, String>();
        if (!MultiGenerateArtifactInfo.isNullOrEmpty(customProperties)) {
            BufferedReader reader = new BufferedReader(new StringReader(customProperties));
            String line = reader.readLine();
            while (line != null) {
                if (!MultiGenerateArtifactInfo.isNullOrEmpty(line) && line.indexOf(61) > 0) {
                    int index = line.indexOf(61);
                    String propName = line.substring(0, index).trim();
                    String propValue = index < line.length() - 1 ? line.substring(index + 1) : "";
                    properties.put(propName, propValue);
                } else if (!MultiGenerateArtifactInfo.isNullOrEmpty(line)) {
                    properties.put(line, "");
                }
                line = reader.readLine();
            }
        }
        System.out.println("Filter: [container:" + srcDatasetName + " target dataset:" + targetDatasetName + " resource:" + memberName + " deployType:" + deployTypeName + "] " + properties);
        System.out.println("");
        String text = "";
        StringBuilder strDataBuilder = new StringBuilder();
        int count = 0;
        for (DataSet currentContainer : containers) {
            if (this.containerLevels.contains(loopType)) {
                Map itemCustomerProperties;
                String itemDeployType;
                String itemMemberName;
                String itemDsName;
                String itemSrcDsName;
                if (loopType.equals("PDS")) {
                    if (!currentContainer.getType().equals("PDS") || currentContainer.isDelete()) {
                        continue;
                    }
                } else if (loopType.equals("DeletedPDS")) {
                    if (!currentContainer.getType().equals("PDS") || !currentContainer.isDelete()) {
                        continue;
                    }
                } else if (!loopType.equals("Sequential") ? loopType.equals("DeletedSequential") && (!currentContainer.getType().equals("sequential") || !currentContainer.isDelete()) : !currentContainer.getType().equals("sequential") || currentContainer.isDelete()) continue;
                if (!this.filter(itemSrcDsName = currentContainer.getSrcDataSetName(), itemDsName = currentContainer.getName(), itemMemberName = "", itemDeployType = currentContainer.getDeployType(), itemCustomerProperties = currentContainer.getCustomerProperties(), deployTypeName, properties, srcDatasetName, targetDatasetName, memberName)) continue;
                HashMap<String, String> vars = new HashMap<String, String>();
                if (null != itemCustomerProperties) {
                    vars.putAll(itemCustomerProperties);
                }
                vars.put("sourceDataset", itemSrcDsName);
                vars.put("dataset", itemDsName);
                vars.put("member", itemMemberName);
                vars.put("deployType", itemDeployType);
                String envline = this.envCommand(template, vars, itemDsName, ignoreUnresolved);
                strDataBuilder.append(envline);
                ++count;
                continue;
            }
            if (!this.resourceLevels.contains(loopType) || (!loopType.equals("Member") ? loopType.equals("DeletedMember") && (!currentContainer.getType().equals("PDS") || !currentContainer.isDelete()) : !currentContainer.getType().equals("PDS") || currentContainer.isDelete())) continue;
            HashMap pdsCustomerProperties = currentContainer.getCustomerProperties();
            if (pdsCustomerProperties == null) {
                pdsCustomerProperties = new HashMap();
            }
            NavigableSet deployedMembersInCurrentDataSet = currentContainer.getMembers();
            if (orderBy.equals("ASC")) {
                deployedMembersInCurrentDataSet = new TreeSet(deployedMembersInCurrentDataSet);
            } else if (orderBy.equals("DESC")) {
                deployedMembersInCurrentDataSet = new TreeSet(deployedMembersInCurrentDataSet).descendingSet();
            }
            if (deployedMembersInCurrentDataSet == null) continue;
            for (Member member : deployedMembersInCurrentDataSet) {
                String itemSrcDsName = member.getSrcDataSetName();
                String itemDsName = member.getDataSetName();
                String itemMemberName = member.getName();
                String itemDeployType = member.getDeployType();
                HashMap<String, String> itemCustomerProperties = member.getCustomerProperties();
                Inputs inputs = member.getInputs();
                if (itemCustomerProperties == null) {
                    itemCustomerProperties = new HashMap<String, String>();
                }
                itemCustomerProperties.putAll(pdsCustomerProperties);
                if (!this.filter(itemSrcDsName, itemDsName, itemMemberName, itemDeployType, itemCustomerProperties, deployTypeName, properties, srcDatasetName, targetDatasetName, memberName)) continue;
                HashMap<String, String> vars = new HashMap<String, String>();
                if (null != itemCustomerProperties) {
                    vars.putAll(itemCustomerProperties);
                }
                vars.put("sourceDataset", itemSrcDsName);
                vars.put("dataset", itemDsName);
                vars.put("member", itemMemberName);
                vars.put("deployType", itemDeployType);
                vars.put("inputsUrl", inputs.getUrl());
                String envline = this.envCommand(template, vars, itemDsName, ignoreUnresolved);
                strDataBuilder.append(envline);
                ++count;
            }
        }
        System.out.println();
        System.out.println("Output text for property '" + propertyName + "' :   [ '" + propertyName + "-count' = " + count + " ]");
        System.out.println("========================================================================================================================");
        text = strDataBuilder.toString();
        text = StringUtils.chomp((String)text);
        System.out.println(text);
        System.out.println("========================================================================================================================");
        this.outputProperties.setProperty(propertyName, text);
        this.outputProperties.setProperty(propertyName + "-count", Integer.toString(count));
    }

    public boolean filter(String srcDsName, String dsName, String memberName, String deployType, Map<String, String> customerProperties, String filterDeployType, Map<String, String> filterProperties, String filterSrcDsName, String filterDsName, String filterMemberName) {
        String pattern;
        System.out.println("Apply filter to " + srcDsName + " - " + dsName + "(" + memberName + ") " + customerProperties);
        if (!filterDeployType.isEmpty()) {
            if (filterDeployType.startsWith("/") && filterDeployType.endsWith("/")) {
                pattern = filterDeployType.substring(1, filterDeployType.length() - 1);
                if (deployType == null || !deployType.matches(pattern)) {
                    System.out.println("  Not selected because deployType=" + filterDeployType + " does not match");
                    return false;
                }
            } else if (deployType == null || !deployType.equals(filterDeployType)) {
                System.out.println("  Not selected because deployType=" + filterDeployType + " does not match");
                return false;
            }
        }
        if (!filterDsName.isEmpty()) {
            if (filterDsName.startsWith("/") && filterDsName.endsWith("/")) {
                pattern = filterDsName.substring(1, filterDsName.length() - 1);
                if (!dsName.matches(pattern)) {
                    System.out.println("  Not selected because target data set name=" + filterDsName + " does not match");
                    return false;
                }
            } else if (!dsName.equals(filterDsName)) {
                System.out.println("  Not selected because target data set name=" + filterDsName + " does not match");
                return false;
            }
        }
        if (!filterSrcDsName.isEmpty()) {
            if (filterSrcDsName.startsWith("/") && filterSrcDsName.endsWith("/")) {
                pattern = filterSrcDsName.substring(1, filterSrcDsName.length() - 1);
                if (!srcDsName.matches(pattern)) {
                    System.out.println("  Not selected because container name=" + filterSrcDsName + " does not match");
                    return false;
                }
            } else if (!srcDsName.equals(filterSrcDsName)) {
                System.out.println("  Not selected because container name=" + filterSrcDsName + " does not match");
                return false;
            }
        }
        if (!filterMemberName.isEmpty()) {
            if (filterMemberName.startsWith("/") && filterMemberName.endsWith("/")) {
                pattern = filterMemberName.substring(1, filterMemberName.length() - 1);
                if (memberName == null || !memberName.matches(pattern)) {
                    System.out.println("  Not selected because resource name=" + filterMemberName + " does not match");
                    return false;
                }
            } else if (memberName == null || !memberName.equals(filterMemberName)) {
                System.out.println("  Not selected because resource name=" + filterMemberName + " does not match");
                return false;
            }
        }
        for (Map.Entry<String, String> entry : filterProperties.entrySet()) {
            String filterPropKey = entry.getKey();
            String filterPropValue = entry.getValue();
            boolean match = false;
            if (customerProperties.size() != 0) {
                for (Map.Entry<String, String> entryCustProp : customerProperties.entrySet()) {
                    String custKey = entryCustProp.getKey();
                    String custValue = entryCustProp.getValue();
                    if (!custKey.equals(filterPropKey)) continue;
                    if (filterPropValue.isEmpty()) {
                        match = true;
                        continue;
                    }
                    if (filterPropValue.startsWith("/") && filterPropValue.endsWith("/")) {
                        String pattern2 = filterPropValue.substring(1, filterPropValue.length() - 1);
                        if (!custValue.matches(pattern2)) continue;
                        match = true;
                        continue;
                    }
                    if (!custValue.equals(filterPropValue)) continue;
                    match = true;
                }
            }
            if (match) continue;
            System.out.println("Not selected because custom property " + filterPropKey + "=" + filterPropValue + " does not match");
            return false;
        }
        return true;
    }

    public String envCommand(String s, Map<String, String> vars, String itemDSN, boolean ignoreUnresolved) {
        for (Map.Entry<String, String> entry : vars.entrySet()) {
            s = StringUtils.replace((String)s, (String)("${" + entry.getKey() + "}"), (String)entry.getValue());
        }
        Pattern pattern = Pattern.compile("\\$\\{.*\\}");
        Matcher matcher = pattern.matcher(s);
        if (matcher.find() && !ignoreUnresolved) {
            System.out.println("Missing property for data set " + itemDSN + ". Please make sure the property is set on the data set.");
            System.exit(1);
        }
        return s;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static HashMap<String, List<String>> combineJsonObjects(String parmTemplate, String parmDeployTypeName, String parmSrcDatasetName, String parmTargetDatasetName, String parmMemberName, String parmCustProperties) {
        HashMap<String, List<String>> summationMap = new HashMap<String, List<String>>();
        JsonObject templateJsonObj = MultiGenerateArtifactInfo.getJsonObjectFromString(parmTemplate, "'Template JSON'");
        JsonObject srcDatasetNameJsonObj = null;
        JsonObject targetDatasetNameJsonObj = null;
        JsonObject memberNameJsonObj = null;
        JsonObject deployTypeNameJsonObj = null;
        JsonObject customPropertiesJsonObj = null;
        if (!MultiGenerateArtifactInfo.isNullOrEmpty(parmSrcDatasetName)) {
            srcDatasetNameJsonObj = MultiGenerateArtifactInfo.getJsonObjectFromString(parmSrcDatasetName, "'Container Name filter JSON'");
        }
        if (!MultiGenerateArtifactInfo.isNullOrEmpty(parmTargetDatasetName)) {
            targetDatasetNameJsonObj = MultiGenerateArtifactInfo.getJsonObjectFromString(parmTargetDatasetName, "'Target Name filter JSON'");
        }
        if (!MultiGenerateArtifactInfo.isNullOrEmpty(parmMemberName)) {
            memberNameJsonObj = MultiGenerateArtifactInfo.getJsonObjectFromString(parmMemberName, "'Resource Name filter JSON'");
        }
        if (!MultiGenerateArtifactInfo.isNullOrEmpty(parmDeployTypeName)) {
            deployTypeNameJsonObj = MultiGenerateArtifactInfo.getJsonObjectFromString(parmDeployTypeName, "'Deploy Type filter JSON'");
        }
        if (!MultiGenerateArtifactInfo.isNullOrEmpty(parmCustProperties)) {
            customPropertiesJsonObj = MultiGenerateArtifactInfo.getJsonObjectFromString(parmCustProperties, "'Custom properties filter JSON'");
        }
        for (Map.Entry entry : templateJsonObj.entrySet()) {
            ArrayList<String> parametersList = new ArrayList<String>();
            JsonElement jsonElementValue = (JsonElement)entry.getValue();
            String templateKey = (String)entry.getKey();
            String templateValue = jsonElementValue.getAsString();
            if (MultiGenerateArtifactInfo.isNullOrEmpty(templateValue)) {
                System.out.println("ERROR: Value missing in template for key " + templateKey);
                System.exit(1);
            }
            parametersList.add(templateValue);
            String srcDatasetNameValue = "";
            if (srcDatasetNameJsonObj != null && srcDatasetNameJsonObj.has(templateKey)) {
                srcDatasetNameValue = srcDatasetNameJsonObj.get(templateKey).isJsonNull() ? "" : srcDatasetNameJsonObj.get(templateKey).getAsString();
            }
            parametersList.add(srcDatasetNameValue);
            String targetDatasetNameValue = "";
            if (targetDatasetNameJsonObj != null && targetDatasetNameJsonObj.has(templateKey)) {
                targetDatasetNameValue = targetDatasetNameJsonObj.get(templateKey).isJsonNull() ? "" : targetDatasetNameJsonObj.get(templateKey).getAsString();
            }
            parametersList.add(targetDatasetNameValue);
            String memberNameValue = "";
            if (memberNameJsonObj != null && memberNameJsonObj.has(templateKey)) {
                memberNameValue = memberNameJsonObj.get(templateKey).isJsonNull() ? "" : memberNameJsonObj.get(templateKey).getAsString();
            }
            parametersList.add(memberNameValue);
            String deployTypeNameValue = "";
            if (deployTypeNameJsonObj != null && deployTypeNameJsonObj.has(templateKey)) {
                deployTypeNameValue = deployTypeNameJsonObj.get(templateKey).isJsonNull() ? "" : deployTypeNameJsonObj.get(templateKey).getAsString();
            }
            parametersList.add(deployTypeNameValue);
            String customPropertiesValue = "";
            if (customPropertiesJsonObj != null && customPropertiesJsonObj.has(templateKey)) {
                customPropertiesValue = customPropertiesJsonObj.get(templateKey).isJsonNull() ? "" : customPropertiesJsonObj.get(templateKey).getAsString();
            }
            parametersList.add(customPropertiesValue);
            summationMap.put(templateKey, parametersList);
        }
        return summationMap;
    }

    public static JsonObject getJsonObjectFromString(String str, String inputSource) {
        Gson gson = new Gson();
        JsonObject jsonObj = new JsonObject();
        try {
            JsonElement element = (JsonElement)gson.fromJson(str, JsonElement.class);
            jsonObj = element.getAsJsonObject();
        }
        catch (JsonSyntaxException e) {
            System.out.println("Error while processing JSON for " + inputSource);
            e.printStackTrace();
            System.exit(1);
        }
        return jsonObj;
    }
}

