/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.manifest;

import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.ManifestUtils;
import com.ibm.team.enterprise.automation.manifest.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ManifestReader {
    private static ManifestReader instance;
    private SAXParser parser;
    private Manifest manifest;
    private List<Container> currentContainerList;
    private Container currentContainer = null;
    private Resource currentResource = null;

    private ManifestReader() throws Exception {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(ManifestUtils.getInstance().getSchemaURL());
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setSchema(schema);
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        this.parser = factory.newSAXParser();
    }

    public static final ManifestReader getInstance() throws Exception {
        if (instance == null) {
            instance = new ManifestReader();
        }
        return instance;
    }

    public void read(File file) throws SAXException, IOException {
        FileInputStream inputStream = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader(inputStream);
        this.currentContainerList = null;
        InputSource is = new InputSource(reader);
        this.parser.parse(is, (DefaultHandler)new ManifestHandler());
    }

    public Manifest getManifest(File file) throws SAXException, IOException {
        this.manifest = null;
        if (file.exists()) {
            this.read(file);
        }
        return this.manifest;
    }

    public Manifest getManifest(InputStream inputStream) throws SAXException, IOException {
        this.manifest = null;
        InputStreamReader reader = new InputStreamReader(inputStream);
        this.currentContainerList = null;
        InputSource is = new InputSource(reader);
        this.parser.parse(is, (DefaultHandler)new ManifestHandler());
        return this.manifest;
    }

    private class ManifestHandler
    extends DefaultHandler {
        private ManifestHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("manifest")) {
                ManifestReader.this.manifest = new Manifest();
                ManifestReader.this.manifest.setType(attributes.getValue("type"));
                ManifestReader.this.manifest.setVersion(attributes.getValue("version"));
                ManifestReader.this.manifest.setTimeZone(attributes.getValue("timeZone"));
            }
            if (qName.equals("created")) {
                ManifestReader.this.currentContainerList = ManifestReader.this.manifest.getCreatedContainers();
            } else if (qName.equals("updated")) {
                ManifestReader.this.currentContainerList = ManifestReader.this.manifest.getUpdatedContainers();
            } else if (qName.equals("deleted")) {
                ManifestReader.this.currentContainerList = ManifestReader.this.manifest.getDeletedContainers();
            }
            if (qName.equals("container")) {
                String copyType;
                String deployType;
                String rootDir;
                String missing;
                String workItemUUID;
                String workItemId;
                if (ManifestReader.this.currentContainerList == null) {
                    ManifestReader.this.currentContainerList = ManifestReader.this.manifest.getContainers();
                }
                Container container = new Container();
                container.setName(attributes.getValue("name"));
                container.setType(attributes.getValue("type"));
                String changeType = attributes.getValue("changeType");
                if (changeType != null && !changeType.equals("")) {
                    container.setChangeType(changeType);
                }
                if ((workItemId = attributes.getValue("workItemId")) != null && !workItemId.equals("")) {
                    container.setWorkItemId(workItemId);
                }
                if ((workItemUUID = attributes.getValue("workItemUUID")) != null && !workItemUUID.equals("")) {
                    container.setWorkitemUUID(workItemUUID);
                }
                if ((missing = attributes.getValue("missing")) != null && !missing.isEmpty()) {
                    container.setMissing(missing);
                }
                if ((rootDir = attributes.getValue("rootDir")) != null) {
                    container.setRootDir(rootDir);
                }
                if ((deployType = attributes.getValue("deployType")) != null) {
                    container.setDeployType(deployType);
                }
                if ((copyType = attributes.getValue("copyType")) != null) {
                    container.setCopyType(copyType);
                }
                ManifestReader.this.currentContainerList.add(container);
                ManifestReader.this.currentContainer = container;
            } else if (qName.equals("resource")) {
                String missing;
                String versionId;
                String deployType;
                String languageDefinitionUUID;
                String languageDefinitionName;
                String workItemUUID;
                String workItemId;
                String tag;
                String size;
                String IBMiAttribute;
                String IBMiType;
                String lastModifiedTimestamp;
                Resource resource = new Resource();
                resource.setName(attributes.getValue("name"));
                resource.setType(attributes.getValue("type"));
                String creationTimestamp = attributes.getValue("creationTimestamp");
                if (creationTimestamp != null && !creationTimestamp.equals("")) {
                    resource.setCreationTimestamp(creationTimestamp);
                }
                if ((lastModifiedTimestamp = attributes.getValue("lastModifiedTimestamp")) != null && !lastModifiedTimestamp.equals("")) {
                    resource.setLastModifiedTimestamp(lastModifiedTimestamp);
                }
                if ((IBMiType = attributes.getValue("IBMiType")) != null && !IBMiType.equals("")) {
                    resource.setIbmiType(IBMiType);
                }
                if ((IBMiAttribute = attributes.getValue("IBMiAttribute")) != null && !IBMiAttribute.equals("")) {
                    resource.setIbmiAttrribute(IBMiAttribute);
                }
                if ((size = attributes.getValue("size")) != null && !size.equals("")) {
                    resource.setSize(size);
                }
                if ((tag = attributes.getValue("tag")) != null && !tag.equals("")) {
                    resource.setTag(tag);
                }
                if ((workItemId = attributes.getValue("workItemId")) != null && !workItemId.equals("")) {
                    resource.setWorkItemId(workItemId);
                }
                if ((workItemUUID = attributes.getValue("workItemUUID")) != null && !workItemUUID.equals("")) {
                    resource.setWorkitemUUID(workItemUUID);
                }
                if ((languageDefinitionName = attributes.getValue("languageDefinitionName")) != null && !languageDefinitionName.equals("")) {
                    resource.setLanguageDefinitionName(languageDefinitionName);
                }
                if ((languageDefinitionUUID = attributes.getValue("languageDefinitionUUID")) != null && !languageDefinitionUUID.equals("")) {
                    resource.setLanguageDefinitionUUID(languageDefinitionUUID);
                }
                if ((deployType = attributes.getValue("deployType")) != null && !deployType.isEmpty()) {
                    resource.setDeployType(deployType);
                }
                if ((versionId = attributes.getValue("versionId")) != null && !versionId.isEmpty()) {
                    resource.setVersionId(versionId);
                }
                if ((missing = attributes.getValue("missing")) != null && !missing.isEmpty()) {
                    resource.setMissing(missing);
                }
                ((Container)ManifestReader.this.currentContainerList.get(ManifestReader.this.currentContainerList.size() - 1)).addResource(resource);
                ManifestReader.this.currentResource = resource;
            } else if (qName.equals("property")) {
                Map<String, String> properties = null;
                if (ManifestReader.this.currentResource != null) {
                    properties = ManifestReader.this.currentResource.getProperties();
                    if (properties == null) {
                        properties = new HashMap<String, String>();
                        ManifestReader.this.currentResource.setProperties(properties);
                    }
                } else if (ManifestReader.this.currentContainer != null && (properties = ManifestReader.this.currentContainer.getProperties()) == null) {
                    properties = new HashMap<String, String>();
                    ManifestReader.this.currentContainer.setProperties(properties);
                }
                String name = attributes.getValue("name");
                String value = attributes.getValue("value");
                if (name != null && !name.isEmpty() && value != null) {
                    properties.put(name, value);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("created".equals(qName) || "updated".equals(qName) || "deleted".equals(qName)) {
                ManifestReader.this.currentContainerList = null;
            }
            if ("resource".equals(qName)) {
                ManifestReader.this.currentResource = null;
            }
            if ("container".equals(qName)) {
                ManifestReader.this.currentContainer = null;
            }
        }
    }
}

